package eu.javaexpereince.spider.selenium;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Queue;

import eu.javaexperience.collection.queue.QueueAdapter;
import eu.javaexperience.io.FileContentMapper;

public class SeleniumSpiderFileStorage
{
	protected String root;
	
	protected Map<String, byte[]> pages;
	protected Map<String, List<String>> linkMap;
	protected Queue<String> pendingLinks;
	
	protected Map<String, Object> pageAttributes;
	
	public Map<String, byte[]> getPagesMap()
	{
		return pages;
	}
	
	public Map<String, List<String>> getLinkMap()
	{
		return linkMap;
	}
	
	public Queue<String> getPendingUrlsQueue()
	{
		return pendingLinks;
	}
	
	public Map<String, Object> getPageAttributeMap()
	{
		return pageAttributes;
	}
	
	public SeleniumSpiderFileStorage(String dir) throws FileNotFoundException
	{
		pages = (Map)FileContentMapper.openWithCreate(dir+"/pages");
		linkMap = (Map)FileContentMapper.openWithCreate(dir+"/link_maps");
		pageAttributes = (Map)FileContentMapper.openWithCreate(dir+"/page_attrs");
		
		Map<String, String> tmp = FileContentMapper.openWithCreate(dir+"/pendings");
		pendingLinks = new QueueAdapter<>(tmp);
	}
	
}