/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexpereince.spider.selenium;

import eu.javaexpereince.spider.selenium.AbstractSeleniumSpider;
import eu.javaexpereince.spider.selenium.SeleniumSpiderFileStorage;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.url.UrlBuilder;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumSpider
extends AbstractSeleniumSpider {
    protected String domain;

    public SeleniumSpider(String domain, Queue<String> urlsToVisit, Map<String, List<String>> pageLinks) {
        super(urlsToVisit, pageLinks);
        this.domain = domain;
    }

    @Override
    public boolean needWisit(String url) {
        return new UrlBuilder(url).getHost().endsWith(this.domain);
    }

    @Override
    public void selectUrls(Collection<String> dst, WebDriver wd) {
        try {
            URL url = null;
            WebElement base = SeleniumSpider.querySelector((SearchContext)wd, "base");
            if (null != base) {
                url = new URL(base.getAttribute("href"));
            }
            if (null == url) {
                url = new URL(wd.getCurrentUrl());
            }
            List<WebElement> as = SeleniumSpider.querySelectorAll((SearchContext)wd, "a");
            for (WebElement a : as) {
                try {
                    String href = a.getAttribute("href");
                    if (null == href) continue;
                    href = SeleniumSpider.getAbsPath(href, url);
                    dst.add(href);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static WebElement querySelector(SearchContext elem, String selector) {
        try {
            return elem.findElement(By.cssSelector((String)selector));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<WebElement> querySelectorAll(SearchContext elem, String selector) {
        try {
            return elem.findElements(By.cssSelector((String)selector));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getAbsPath(String url, URL host) {
        try {
            url = url.trim();
            URL cim = new URL(url);
            if (!cim.getHost().equals(host.getHost())) {
                return url;
            }
            return url;
        }
        catch (MalformedURLException e) {
            if (url.startsWith("/")) {
                String on = host.toString();
                int index = on.indexOf(47, 9);
                if (-1 != index) {
                    on = on.substring(0, index);
                }
                return on + url;
            }
            return host.getProtocol() + "://" + host.getHost() + SeleniumSpider.relative(host.getPath(), url);
        }
    }

    protected static void delPrev(String[] arr, int pos) {
        for (int i = pos - 1; i >= 0; --i) {
            if (null == arr[i]) continue;
            arr[i] = null;
            return;
        }
    }

    public static String relative(String path, String rel) {
        int i;
        if ("".equals(rel)) {
            return "";
        }
        if (rel.startsWith("/")) {
            return rel;
        }
        String[] ps = path.split("/");
        String[] re = rel.split("/");
        String[] build = new String[ps.length + re.length];
        if (!path.endsWith("/")) {
            ps[ps.length - 1] = null;
        }
        for (i = 0; i < ps.length; ++i) {
            build[i] = ps[i];
        }
        for (i = 0; i < re.length; ++i) {
            build[ps.length + i] = re[i];
        }
        for (i = 0; i < build.length; ++i) {
            String p = build[i];
            if (".".equals(p) || "".equals(p)) {
                build[i] = null;
                continue;
            }
            if (!"..".equals(p)) continue;
            build[i] = null;
            SeleniumSpider.delPrev(build, i);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : build) {
            if (null == s) continue;
            sb.append("/");
            sb.append(s);
        }
        return sb.toString();
    }

    protected static void examineCookies(Set<Cookie> dst, WebDriver driver) {
        CollectionTools.copyInto((Collection)driver.manage().getCookies(), dst);
    }

    public static void discoverSite(WebDriver wd, String storage, String rootDomain) throws FileNotFoundException {
        final SeleniumSpiderFileStorage ssfs = new SeleniumSpiderFileStorage(storage);
        SeleniumSpider sp = new SeleniumSpider(rootDomain, ssfs.pendingLinks, ssfs.linkMap){

            @Override
            public void sniffPage(String link, WebDriver wd) {
                super.sniffPage(link, wd);
                System.out.println(link);
                ssfs.getPagesMap().put(link, wd.findElement(By.cssSelector((String)"html")).getAttribute("outerHTML").getBytes());
            }

            @Override
            public boolean needWisit(String url) {
                if (url.contains("?referer=")) {
                    return false;
                }
                return super.needWisit(url);
            }
        };
        if (ssfs.getPendingUrlsQueue().isEmpty()) {
            sp.addPage("http://" + rootDomain);
        }
        sp.continueCrawling(wd);
    }
}

