/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.spider;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.storage.StoragesWarehouse;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.proxy.ProxyStorage;
import eu.javaexperience.proxy.TorProxySpawner;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.spider.AbstractWebSpider;
import eu.javaexperience.spider.SpiderFunctions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpiderTools {
    public static SimplePublish3<Map<String, byte[]>, Proxy, String> DOWNLOAD_INTO_STORAGE = new SimplePublish3<Map<String, byte[]>, Proxy, String>(){

        public void publish(Map<String, byte[]> a, Proxy b, String c) {
            try {
                a.put(c, SpiderTools.download(b, c, null));
            }
            catch (Exception e) {
                Mirror.throwSoftOrHardButAnyway((Throwable)e);
            }
        }
    };
    protected static Map<String, String> HEADERS;

    public static void tryLogDownloadTime(String url, long dt) {
        LoggingTools.tryLogFormat((Logger)SpiderFunctions.LOG, (LoggingDetailLevel)LogLevel.MEASURE, (String)"Url download \"%s\" took %s ms", (Object)url, (Object)dt);
    }

    public static byte[] download(String url) throws MalformedURLException, IOException {
        return SpiderTools.download(url, null);
    }

    public static byte[] download(String url, @MayNull Map<String, String> headers) throws MalformedURLException, IOException {
        return SpiderTools.download(url, headers, null);
    }

    public static byte[] download(Proxy proxy, String url, @MayNull Map<String, String> headers) throws MalformedURLException, IOException {
        return SpiderTools.download(proxy, url, headers, null);
    }

    public static byte[] download(String url, @MayNull Map<String, String> headers, String post_data) throws MalformedURLException, IOException {
        return SpiderTools.download(null, new URL(url), headers, -1, null == post_data ? null : post_data.getBytes());
    }

    public static byte[] download(Proxy proxy, String url, @MayNull Map<String, String> headers, String post_data) throws MalformedURLException, IOException {
        return SpiderTools.download(proxy, new URL(url), headers, -1, null == post_data ? null : post_data.getBytes());
    }

    public static byte[] download(URL url, Map<String, String> headers) throws IOException {
        return SpiderTools.download(null, url, headers, -1, null);
    }

    public static byte[] download(Proxy proxy, URL url, Map<String, String> headers) throws IOException {
        return SpiderTools.download(proxy, url, headers, -1, null);
    }

    public static byte[] download(Proxy proxy, URL url, Map<String, String> headers, byte[] POST_data) throws IOException {
        return SpiderTools.download(proxy, url, headers, 60000, POST_data);
    }

    public static byte[] download(Proxy proxy, URL url, Map<String, String> headers, int timeoutMs, byte[] POST_data) throws IOException {
        Throwable throwable;
        URLConnection connection = null;
        connection = null == proxy ? url.openConnection() : url.openConnection(proxy);
        if (timeoutMs > 0) {
            connection.setConnectTimeout(timeoutMs);
        }
        if (null != headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (null == header.getValue()) continue;
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (null != POST_data) {
            connection.addRequestProperty("Content-Length", String.valueOf(POST_data.length));
            connection.setDoOutput(true);
            throwable = null;
            try (OutputStream os = connection.getOutputStream();){
                if (null != POST_data) {
                    os.write(POST_data);
                    os.flush();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        throwable = null;
        try (InputStream is = connection.getInputStream();){
            int ep = 0;
            int read = 0;
            byte[] ret = new byte[10240];
            while ((read = is.read(ret, ep, ret.length - ep)) >= 0) {
                if (ep + read == ret.length) {
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                ep += read;
            }
            HttpURLConnection conn = (HttpURLConnection)connection;
            int status = conn.getResponseCode();
            if (status == 302 || status == 301 || status == 303) {
                byte[] byArray = SpiderTools.download(proxy, new URL(conn.getHeaderField("Location")), headers, timeoutMs, POST_data);
                return byArray;
            }
            byte[] byArray = Arrays.copyOf(ret, ep);
            return byArray;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public static HttpRequestResult httpDownload(Proxy proxy, URL url, Map<String, String> headers, byte[] POST_data) throws IOException {
        return SpiderTools.httpDownload(proxy, url, headers, 0, POST_data);
    }

    public static HttpRequestResult httpDownload(Proxy proxy, URL url, Map<String, String> headers, int timeoutMs, byte[] POST_data) throws IOException {
        URLConnection connection = null;
        connection = null == proxy ? url.openConnection() : url.openConnection(proxy);
        if (timeoutMs > 0) {
            connection.setConnectTimeout(timeoutMs);
        }
        if (null != headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (null == header.getValue()) continue;
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (null != POST_data) {
            Map.Entry<String, String> header;
            connection.addRequestProperty("Content-Length", String.valueOf(POST_data.length));
            connection.setDoOutput(true);
            OutputStream os = connection.getOutputStream();
            header = null;
            try {
                if (null != POST_data) {
                    os.write(POST_data);
                    os.flush();
                }
            }
            catch (Throwable throwable) {
                header = throwable;
                throw throwable;
            }
            finally {
                if (os != null) {
                    if (header != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)header)).addSuppressed(throwable);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        HttpRequestResult res = new HttpRequestResult();
        res.responseCode = httpConn.getResponseCode();
        res.headers = httpConn.getHeaderFields();
        try {
            res.responseStatus = res.headers.get(null).get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (InputStream is = 200 == res.responseCode ? httpConn.getInputStream() : httpConn.getErrorStream();){
            int ep = 0;
            int read = 0;
            byte[] ret = new byte[10240];
            while ((read = is.read(ret, ep, ret.length - ep)) > 0) {
                if (ep + read == ret.length) {
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                ep += read;
            }
            res.data = Arrays.copyOf(ret, ep);
        }
        return res;
    }

    public static void processLinkPage(Document doc, SimplePublish2<Node, Collection<String>> selector, Collection<String> urls) {
        SpiderTools.processLinkPage(doc.getChildNodes(), selector, urls);
    }

    public static void processLinkPage(NodeList nl, SimplePublish2<Node, Collection<String>> selector, Collection<String> urls) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            selector.publish((Object)n, urls);
            SpiderTools.processLinkPage(n.getChildNodes(), selector, urls);
        }
    }

    public static void downloadPage(String link, Map<String, byte[]> url_to_content, Map<String, String> headers) throws MalformedURLException, IOException {
        byte[] data = SpiderTools.download(new URL(link), headers);
        url_to_content.put(link, data);
    }

    public static void downloadPages(Collection<String> links, Map<String, byte[]> url_to_content, Map<String, String> headers) {
        for (String url : links) {
            try {
                SpiderTools.downloadPage(url, url_to_content, headers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void processAndStoreListerPage(NodeList doc, String list_destination_file, SimplePublish2<Node, Collection<String>> selector, Collection<String> urls) throws FileNotFoundException, IOException {
        SpiderTools.processLinkPage(doc, selector, urls);
        SpiderTools.storeUrlList(list_destination_file, urls);
    }

    public static void loadFillUrlList(String source, Collection<String> urls) throws FileNotFoundException, IOException {
        IOTools.loadFillAllLine((String)source, urls);
    }

    public static void storeUrlList(String dst, Collection<String> urls) throws FileNotFoundException, IOException {
        try (PrintWriter pw = new PrintWriter(dst);){
            for (String s : urls) {
                pw.println(URLEncoder.encode(s));
            }
            pw.flush();
        }
    }

    public static void discoverSiteInDepth(URL start_link, int depth, final Map<String, byte[]> download_to, final GetBy1<Boolean, URL> may_visit, final SimplePublish3<URL, List<URL>, List<URL>> url_map) throws MalformedURLException {
        AbstractWebSpider aws = new AbstractWebSpider(start_link){

            @Override
            public boolean shallReturnByParsedDocument(URL link, String data, Document doc) {
                return false;
            }

            @Override
            public boolean preShallReturn(URL link) {
                return false;
            }

            @Override
            public boolean postShallReturn(URL link, byte[] data) {
                download_to.put(link.toString(), data);
                return false;
            }

            @Override
            public void publishSiteLinks(URL url, List<URL> all_link, List<URL> domain_links) {
                if (null != url_map) {
                    url_map.publish((Object)url, all_link, domain_links);
                }
            }

            @Override
            public boolean isSelfURL(URL URL2) {
                return Boolean.TRUE == may_visit.getBy((Object)URL2);
            }
        };
        aws.getRecursiveSiteMapWhitoutDuplication(start_link, Integer.MAX_VALUE);
    }

    public static void fullSiteIterateOnDomain(URL start_link, Map<String, byte[]> download_to, GetBy1<Boolean, URL> may_visit, SimplePublish3<URL, List<URL>, List<URL>> url_map) throws MalformedURLException {
        SpiderTools.discoverSiteInDepth(start_link, Integer.MAX_VALUE, download_to, may_visit, url_map);
    }

    public static Map<String, String> getExtraHeaders() {
        return HEADERS;
    }

    public static SimplePublish3<Map<String, String>, Proxy, String> downloadIntoStorageWithEncoding(final String encoding) {
        return new SimplePublish3<Map<String, String>, Proxy, String>(){

            public void publish(Map<String, String> a, Proxy b, String c) {
                try {
                    byte[] data = SpiderTools.download(b, c, null);
                    a.put(c, new String(data, encoding));
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway((Throwable)e);
                }
            }
        };
    }

    public static SimplePublish3<Map<String, byte[]>, Proxy, String> downloadIntoStorageRaw() {
        return new SimplePublish3<Map<String, byte[]>, Proxy, String>(){

            public void publish(Map<String, byte[]> a, Proxy b, String c) {
                try {
                    byte[] data = SpiderTools.download(b, c, null);
                    a.put(c, data);
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway((Throwable)e);
                }
            }
        };
    }

    public static void downloadPagesIntoParallelWithProxies(Map<String, byte[]> dst, Collection<String> src, ProxyStorage spawnerStorage, int proxies, int concurrency, boolean skip_exists) {
        SpiderTools.downloadPagesIntoParallelWithProxies(null, dst, src, spawnerStorage, proxies, concurrency, skip_exists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadPagesIntoParallelWithProxies(final @MayNull GetBy2<byte[], Proxy, URL> downloader, final Map<String, byte[]> dst, Collection<String> src, final ProxyStorage spawnerStorage, final int proxies, int concurrency, final boolean skip_exists) {
        final LinkedBlockingQueue<String> urls_queue = new LinkedBlockingQueue<String>();
        urls_queue.addAll(src);
        final AtomicInteger nums = new AtomicInteger(concurrency);
        int i = 0;
        while (i < concurrency) {
            final int thread_ordinal = i++;
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String toDownload = null;
                        while (null != (toDownload = (String)urls_queue.poll())) {
                            if (skip_exists && dst.containsKey(toDownload)) continue;
                            try {
                                long t0 = System.currentTimeMillis();
                                byte[] data = null;
                                int try_count = 10;
                                int i = 0;
                                while (true) {
                                    block12: {
                                        try {
                                            TorProxySpawner.ProxySource tp = spawnerStorage.getAtOffset(thread_ordinal % proxies);
                                            Proxy p = tp.getProxy();
                                            data = null == downloader ? SpiderTools.download(p, toDownload, SpiderTools.getExtraHeaders()) : (byte[])downloader.getBy((Object)p, (Object)new URL(toDownload));
                                            if (null != data) {
                                            }
                                            break block12;
                                        }
                                        catch (Exception e) {
                                            if (10 != i) break block12;
                                            LoggingTools.tryLogFormat((Logger)SpiderFunctions.LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"Can't download URL \"%s\" %s", (Object)toDownload, (Object)e.getMessage());
                                        }
                                        break;
                                    }
                                    ++i;
                                }
                                if (null == data) continue;
                                LoggingTools.tryLogFormat((Logger)SpiderFunctions.LOG, (LoggingDetailLevel)LogLevel.MEASURE, (String)"Url download \"%s\" took %s ms", (Object)toDownload, (Object)(System.currentTimeMillis() - t0));
                                dst.put(toDownload, data);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    AtomicInteger atomicInteger = nums;
                    synchronized (atomicInteger) {
                        nums.decrementAndGet();
                        nums.notifyAll();
                    }
                }
            }.start();
        }
        AtomicInteger atomicInteger = nums;
        synchronized (atomicInteger) {
            while (0 != nums.get()) {
                try {
                    nums.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public static StoragesWarehouse<byte[]> getWarehouseStorage(String warehouse_dir, String unit_name) {
        return new StoragesWarehouse(warehouse_dir + "/" + unit_name + "/");
    }

    static {
        SmallMap map = new SmallMap();
        map.put("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.104 Safari/537.36");
        map.put("Accept-Language", "hu-HU,hu;q=0.8,en-US;q=0.6,en;q=0.4");
        map.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,");
        map.put("Cache-Control", "max-age=0");
        HEADERS = Collections.unmodifiableMap(map);
    }

    public static class HttpRequestResult {
        public String responseStatus;
        public int responseCode;
        public byte[] data;
        public Map<String, List<String>> headers;
    }
}

