/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexpereince.spider.selenium;

import eu.javaexperience.collection.PublisherCollection;
import eu.javaexperience.spider.AbstractWebSpider;
import eu.javaexperience.url.UrlBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.openqa.selenium.WebDriver;

public abstract class AbstractSeleniumSpider {
    protected Queue<String> urlsToVisit;
    protected Map<String, List<String>> pageLinks;

    public AbstractSeleniumSpider(Queue<String> urlsToVisit, Map<String, List<String>> pageLinks) {
        this.urlsToVisit = urlsToVisit;
        this.pageLinks = pageLinks;
    }

    public abstract boolean needWisit(String var1);

    public abstract void selectUrls(Collection<String> var1, WebDriver var2);

    public void sniffPage(String link, WebDriver wd) {
    }

    public synchronized void enqueueLinks(Collection<String> links) {
        Set<String> ex = this.pageLinks.keySet();
        for (String s : links) {
            if (ex.contains(s)) continue;
            this.urlsToVisit.add(s);
        }
    }

    public synchronized boolean isVisited(String url) {
        return this.pageLinks.keySet().contains(url);
    }

    public synchronized void addPage(String url) {
        if (!this.isVisited(url = this.normalizeUrl(url))) {
            this.urlsToVisit.add(url);
        }
    }

    public String normalizeUrl(String url) {
        return AbstractSeleniumSpider.defaultNormalizeUrl(url);
    }

    public static String defaultNormalizeUrl(String url) {
        url = (String)AbstractWebSpider.betterNormalizeURL.getBy((Object)url);
        return new UrlBuilder(url).getUrl().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueCrawling(WebDriver wd) {
        String link = null;
        while (null != (link = this.urlsToVisit.poll())) {
            if (this.isVisited(link)) {
                System.out.println("Skip visited page: " + link);
                continue;
            }
            wd.navigate().to(link);
            this.sniffPage(link, wd);
            final HashSet add = new HashSet();
            this.selectUrls((Collection<String>)new PublisherCollection<String>(){

                public boolean add(String obj) {
                    if (AbstractSeleniumSpider.this.needWisit(obj = AbstractSeleniumSpider.this.normalizeUrl(obj))) {
                        add.add(obj);
                    }
                    return false;
                }
            }, wd);
            ArrayList<String> put = new ArrayList<String>(add);
            AbstractSeleniumSpider abstractSeleniumSpider = this;
            synchronized (abstractSeleniumSpider) {
                this.pageLinks.put(link, put);
            }
            this.enqueueLinks(put);
        }
    }

    public static void main(String[] args) {
        System.out.println(AbstractSeleniumSpider.defaultNormalizeUrl("http://www.site.com/list?page=1&page=7"));
        System.out.println(AbstractSeleniumSpider.defaultNormalizeUrl("http://www.site.com/"));
        System.out.println(AbstractSeleniumSpider.defaultNormalizeUrl("http://www.site.com"));
    }
}

