/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.spider;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.collection.set.OneShotSet;
import eu.javaexperience.document.DocumentTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.url.UrlTools;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractWebSpider {
    protected final String thisDomain;
    protected URL baseURL = null;
    protected boolean isBaseURLDynamic = true;
    public GetBy1<byte[], URL> downloadFacitlity = defaultDownloadFacility;
    public GetBy1<Document, String> parser = defaultParser;
    private HashSet<URL> SK = new HashSet();
    protected static final GetBy1<Boolean, Node> selectHrefs = new GetBy1<Boolean, Node>(){

        public Boolean getBy(Node a) {
            String name = a.getNodeName();
            if (null == name || null == a.getAttributes().getNamedItem("href")) {
                return Boolean.FALSE;
            }
            return "a".equals(name) || "area".equals(name);
        }
    };
    public static final GetBy1<byte[], URL> defaultDownloadFacility = new GetBy1<byte[], URL>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] getBy(URL a) {
            try {
                URLConnection connection = a.openConnection();
                try (InputStream is = connection.getInputStream();){
                    byte[] byArray = IOTools.loadAllFromInputStream((InputStream)is);
                    return byArray;
                }
                catch (Exception e) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
    };
    public static final GetBy1<Document, String> defaultParser = new GetBy1<Document, String>(){

        public Document getBy(String a) {
            try {
                Method m = Mirror.getClassMethodOrNull((String)"org.jsoup.Jsoup", (String)"parse", (Class[])new Class[]{String.class});
                return (Document)m.invoke(null, a);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    };
    public static final GetBy1<Boolean, Node> selectBase = new GetBy1<Boolean, Node>(){

        public Boolean getBy(Node a) {
            return "base".equals(a.getNodeName()) && null != a.getAttributes().getNamedItem("href");
        }
    };
    public static final GetBy1<Boolean, Node> selectBaseWithHref = new GetBy1<Boolean, Node>(){

        public Boolean getBy(Node a) {
            return "base".equalsIgnoreCase(a.getNodeName()) && a.getAttributes().getNamedItem("href") != null;
        }
    };
    public GetBy1<String, String> norlamizeUrl = defaultNormalizeURL;
    private static final Pattern slash = Pattern.compile("(//)+");
    public static final GetBy1<String, String> defaultNormalizeURL = new GetBy1<String, String>(){

        public String getBy(String s) {
            String ki = s;
            int n = 0;
            while ((n = ki.indexOf("#")) != -1) {
                ki = ki.substring(0, n);
            }
            ki = slash.matcher(ki).replaceAll("/");
            ki = StringTools.replaceAllStrings((String)ki, (String)":/", (String)"://");
            return ki;
        }
    };
    public static final GetBy1<String, String> betterNormalizeURL = new GetBy1<String, String>(){
        private final Pattern slash = Pattern.compile("(//)+");

        public String getBy(String s) {
            try {
                Map map;
                URL re = new URL(s);
                StringBuilder sb = new StringBuilder();
                sb.append(re.getProtocol());
                sb.append("://");
                sb.append(re.getHost());
                if (re.getPort() > 0) {
                    sb.append(":");
                    sb.append(re.getPort());
                }
                sb.append(this.slash.matcher(re.getPath()).replaceAll("/"));
                if (null != re.getQuery() && (map = UrlTools.resolvMap((String)re.getQuery())).size() > 0) {
                    SmallMap out = new SmallMap();
                    for (Map.Entry kv : map.entrySet()) {
                        String k = (String)kv.getKey();
                        String[] vv = (String[])kv.getValue();
                        if (null == k || k.length() <= 0 || null == vv || vv.length <= 0) continue;
                        for (String v : vv) {
                            if (null == v) continue;
                            out.put(k, v);
                        }
                    }
                    sb.append(UrlTools.renderRequestParams((Map)out));
                }
                return sb.toString();
            }
            catch (Exception e) {
                return null;
            }
        }
    };

    public void setBaseUrl(URL base) {
        this.baseURL = base;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public AbstractWebSpider(URL startlink) throws MalformedURLException {
        this.baseURL = startlink;
        this.thisDomain = AbstractWebSpider.getLinkDomain(startlink);
    }

    public abstract boolean preShallReturn(URL var1);

    public abstract boolean postShallReturn(URL var1, byte[] var2);

    public abstract boolean shallReturnByParsedDocument(URL var1, String var2, Document var3);

    public Set<URL> getRecursiveSiteMapWhitoutDuplication(URL cim, int depth) {
        return this.getRecursiveSM(cim, depth);
    }

    protected Set<URL> singleSet(URL elem) {
        return new OneShotSet((Object)elem);
    }

    private Set<URL> getRecursiveSM(URL cim, int depth) {
        try {
            cim = new URL((String)this.norlamizeUrl.getBy((Object)cim.toString()));
        }
        catch (MalformedURLException e3) {
            e3.printStackTrace();
            return this.singleSet(cim);
        }
        if (this.SK.contains(cim) || depth < 0) {
            return this.singleSet(cim);
        }
        this.SK.add(cim);
        if (this.preShallReturn(cim)) {
            return this.singleSet(cim);
        }
        ArrayList c = null;
        URL currentBaseURL = null;
        Document doc = null;
        String tart = null;
        Object data22 = (byte[])this.downloadFacitlity.getBy((Object)cim);
        if (null == data22) {
            return this.singleSet(cim);
        }
        if (this.postShallReturn(cim, (byte[])data22)) {
            return this.singleSet(cim);
        }
        tart = new String((byte[])data22);
        try {
            doc = (Document)this.parser.getBy((Object)tart);
        }
        catch (Exception data22) {
            // empty catch block
        }
        if (this.shallReturnByParsedDocument(cim, tart, doc)) {
            return this.singleSet(cim);
        }
        if (tart == null || null == doc) {
            return this.singleSet(cim);
        }
        currentBaseURL = AbstractWebSpider.determineBaseURL(doc, cim);
        if (null == this.baseURL && null == currentBaseURL) {
            currentBaseURL = cim;
        } else if (null == this.baseURL) {
            currentBaseURL = this.baseURL;
        }
        c = new ArrayList();
        DocumentTools.selectAll((Node)doc, c, selectHrefs);
        Object buffer = null;
        ArrayList<URL> out = new ArrayList<URL>();
        data22 = c.iterator();
        while (data22.hasNext()) {
            Node node = (Node)data22.next();
            Node href = node.getAttributes().getNamedItem("href");
            if (null == href) continue;
            try {
                out.add(new URL((String)this.norlamizeUrl.getBy((Object)AbstractWebSpider.getAbsPath(href.getTextContent(), currentBaseURL))));
            }
            catch (Exception e) {
                try {
                    out.add((URL)buffer);
                }
                catch (Exception dsfsf) {
                    dsfsf.printStackTrace();
                }
            }
        }
        c = null;
        ArrayList<URL> dfd = new ArrayList<URL>(out.size());
        for (URL a : out) {
            if (null == a || !this.isSelfURL(a)) continue;
            dfd.add(a);
        }
        for (int i = 0; i < out.size(); ++i) {
            URL at = (URL)out.get(i);
            if (null == at || this.isSelfURL(at)) continue;
            out.set(i, null);
        }
        this.publishSiteLinks(cim, out, dfd);
        out = dfd;
        HashSet<URL> ki = new HashSet<URL>();
        ki.add(cim);
        for (URL news : out) {
            if (this.SK.contains(news)) continue;
            Set<URL> tobbi = this.getRecursiveSM(news, depth - 1);
            for (URL u : tobbi) {
                ki.add(u);
            }
        }
        return this.SK;
    }

    protected void publishSiteLinks(URL cim, List<URL> page_links, List<URL> self_links) {
    }

    public static String getAbsPath(String url, URL host) {
        try {
            url = url.trim();
            URL cim = new URL(url);
            if (!cim.getHost().equals(host.getHost())) {
                return "";
            }
            return url;
        }
        catch (MalformedURLException e) {
            if (url.startsWith("/")) {
                String on = host.toString();
                int index = on.indexOf(47, 9);
                if (-1 != index) {
                    on = on.substring(0, index);
                }
                return on + url;
            }
            return host.getProtocol() + "://" + host.getHost() + AbstractWebSpider.relative(host.getPath(), url);
        }
    }

    protected static void delPrev(String[] arr, int pos) {
        for (int i = pos - 1; i >= 0; --i) {
            if (null == arr[i]) continue;
            arr[i] = null;
            return;
        }
    }

    public static String relative(String path, String rel) {
        int i;
        if ("".equals(rel)) {
            return "";
        }
        if (rel.startsWith("/")) {
            return rel;
        }
        String[] ps = path.split("/");
        String[] re = rel.split("/");
        String[] build = new String[ps.length + re.length];
        if (!path.endsWith("/")) {
            ps[ps.length - 1] = null;
        }
        for (i = 0; i < ps.length; ++i) {
            build[i] = ps[i];
        }
        for (i = 0; i < re.length; ++i) {
            build[ps.length + i] = re[i];
        }
        for (i = 0; i < build.length; ++i) {
            String p = build[i];
            if (".".equals(p) || "".equals(p)) {
                build[i] = null;
                continue;
            }
            if (!"..".equals(p)) continue;
            build[i] = null;
            AbstractWebSpider.delPrev(build, i);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : build) {
            if (null == s) continue;
            sb.append("/");
            sb.append(s);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws MalformedURLException {
        System.out.println((String)betterNormalizeURL.getBy((Object)"http://www.site.com/list?page=1&page=7"));
        System.out.println((String)betterNormalizeURL.getBy((Object)"http://www.site.com/"));
        AbstractWebSpider.test("./index.php", new URL("https://google.hu/"), "https://google.hu/index.php");
        AbstractWebSpider.test("index.php", new URL("https://google.hu/"), "https://google.hu/index.php");
        AbstractWebSpider.test("/index.php", new URL("https://google.hu/"), "https://google.hu/index.php");
        AbstractWebSpider.test("./index.php", new URL("https://google.hu/valami/"), "https://google.hu/valami/index.php");
        AbstractWebSpider.test("index.php", new URL("https://google.hu/valami/"), "https://google.hu/valami/index.php");
        AbstractWebSpider.test("/index.php", new URL("https://google.hu/valami/"), "https://google.hu/index.php");
        AbstractWebSpider.test("../index.php", new URL("https://google.hu/valami/"), "https://google.hu/index.php");
        AbstractWebSpider.test("../index.php", new URL("https://google.hu/valami/asdf"), "https://google.hu/index.php");
        AbstractWebSpider.test("../index.php", new URL("https://google.hu/valami/asdf/"), "https://google.hu/valami/index.php");
        AbstractWebSpider.test("../index.php", new URL("https://google.hu/valami/asdf/../"), "https://google.hu/index.php");
        AbstractWebSpider.test("../../index.php", new URL("https://google.hu/valami/asdf/"), "https://google.hu/index.php");
        AbstractWebSpider.test("../../index.php", new URL("https://google.hu/valami/asdf/../"), "https://google.hu/index.php");
        AbstractWebSpider.test("http://google.hu/index.php", new URL("https://google.hu/valami/"), "http://google.hu/index.php");
        AbstractWebSpider.test("http://facebook.hu/index.php", new URL("https://google.hu/valami/"), "http://google.hu/index.php");
    }

    public static void test(String file, URL url, String result) {
        String ret = AbstractWebSpider.getAbsPath(file, url);
        String out = url + " " + file + " => " + result;
        if (ret.equals(result)) {
            System.out.println(out);
        } else {
            System.out.println("FAIL: " + out + " OUT: " + ret);
        }
    }

    public static URL determineBaseURL(Document webcontent, URL url) {
        Node c = DocumentTools.findFirst((Node)webcontent, selectBaseWithHref);
        if (null != c) {
            try {
                Node val = c.getAttributes().getNamedItem("href");
                if (null != val) {
                    int ind;
                    String ki = val.getTextContent();
                    if (null == ki || ki.length() == 0) {
                        ki = url.toString();
                    }
                    if ((ind = ki.lastIndexOf(47)) != -1) {
                        ki = ki.substring(0, ind);
                        while (ki.charAt(ki.length() - 1) == '/') {
                            ki = ki.substring(0, ki.length() - 1);
                            ki.trim();
                        }
                    }
                    return new URL(ki);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(url);
                return url;
            }
        }
        return url;
    }

    public abstract boolean isSelfURL(URL var1);

    public boolean __defaultIsSelfURL(String url, String thisHost) {
        try {
            URL cim = new URL(url);
            System.out.println(cim.getHost());
            return cim.getHost().equals(thisHost);
        }
        catch (MalformedURLException e) {
            return true;
        }
    }

    public boolean __defaultIsSelfURLbyDomain(String url, String thisHost) {
        try {
            URL cim = new URL(url);
            String[] domtags = cim.getHost().split("\\.");
            if (domtags.length == 0) {
                return true;
            }
            if (domtags.length == 1) {
                return domtags[0].equals(thisHost);
            }
            return (domtags[domtags.length - 2] + "." + domtags[domtags.length - 1]).equals(thisHost);
        }
        catch (MalformedURLException e) {
            return true;
        }
    }

    public static String getLinkDomain(URL link) throws MalformedURLException {
        String[] pre = link.getHost().split("\\.");
        if (pre.length == 1) {
            return pre[0];
        }
        return pre[pre.length - 2] + "." + pre[pre.length - 1];
    }
}

