/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.spider;

import eu.javaexperience.arrays.ListMapAdapter;
import eu.javaexperience.collection.PublisherCollection;
import eu.javaexperience.document.DocumentTools;
import eu.javaexperience.functional.PointOfCreationException;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.FileContentMapper;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.storage.StoragesWarehouse;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.measurement.Measure;
import eu.javaexperience.proxy.ProxyStorage;
import eu.javaexperience.proxy.TorProxySpawner;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.spider.SpiderFunctions;
import eu.javaexperience.spider.SpiderTools;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SpiderProcessFunctions {
    protected static final Logger LOG = SpiderFunctions.LOG;

    public static SimplePublish1<Map<String, Object>> print_time_checkpoint_ms(final String name) {
        return new SimplePublish1<Map<String, Object>>(){

            public void publish(Map<String, Object> a) {
                System.out.println(Measure.checkpoint((String)name));
            }
        };
    }

    public static SimplePublish1<Map<String, Object>> print_storage_size(final String label, final String key) {
        return new SimplePublish1<Map<String, Object>>(){

            public void publish(Map<String, Object> a) {
                Object o = a.get(key);
                if (null == o) {
                    System.out.println(label + " storage_size: null");
                } else if (o instanceof Collection) {
                    System.out.println(label + " collection size: " + ((Collection)o).size());
                } else if (o instanceof Map) {
                    System.out.println(label + " map size: " + ((Map)o).size());
                } else if (o.getClass().isArray()) {
                    System.out.println(label + " array size: " + Array.getLength(o));
                } else {
                    System.out.println(label + " is not storage: " + o);
                }
            }
        };
    }

    public static GetBy1 get_page_storage_and_insert_scope(final String warehouse, final String storage_name) {
        return new GetBy1<FileContentMapper<byte[]>, Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public FileContentMapper<byte[]> getBy(Map<String, Object> env) {
                StoragesWarehouse wh = (StoragesWarehouse)SpiderProcessFunctions.assertCastType(StoragesWarehouse.class, env.get(warehouse), this.POINT);
                FileContentMapper store = null;
                try {
                    store = wh.getStorage(storage_name);
                }
                catch (FileNotFoundException e) {
                    Mirror.throwSoftOrHardButAnyway((Throwable)e);
                }
                env.put(storage_name, store);
                return store;
            }
        };
    }

    public static GetBy1<Collection<?>, Map<String, Object>> get_storage_as_collection_and_insert_scope(String warehouse, String storage_name) {
        return SpiderProcessFunctions.get_storage_as_collection_and_insert_scope(warehouse, storage_name, false);
    }

    public static GetBy1<Collection<?>, Map<String, Object>> get_storage_as_collection_and_insert_scope(final String warehouse, final String storage_name, final boolean clear_brefore_use) {
        return new GetBy1<Collection<?>, Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public Collection<?> getBy(Map<String, Object> env) {
                StoragesWarehouse wh = (StoragesWarehouse)SpiderProcessFunctions.assertCastType(StoragesWarehouse.class, env.get(warehouse), this.POINT);
                ListMapAdapter store = null;
                try {
                    FileContentMapper in = wh.getStorage(storage_name);
                    store = new ListMapAdapter((Map)in, ListMapAdapter.INDEXED_KEYS);
                    if (clear_brefore_use) {
                        store.clear();
                    }
                }
                catch (FileNotFoundException e) {
                    Mirror.throwSoftOrHardButAnyway((Throwable)e);
                }
                env.put(storage_name, store);
                return store;
            }
        };
    }

    public static GetBy1<FileContentMapper<?>, Map<String, Object>> get_storage_as_map_and_insert_scope(final String warehouse, final String storage_name, final boolean clear_brefore_use) {
        return new GetBy1<FileContentMapper<?>, Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public FileContentMapper<?> getBy(Map<String, Object> env) {
                StoragesWarehouse wh = (StoragesWarehouse)SpiderProcessFunctions.assertCastType(StoragesWarehouse.class, env.get(warehouse), this.POINT);
                FileContentMapper store = null;
                try {
                    store = wh.getStorage(storage_name);
                    if (clear_brefore_use) {
                        store.clear();
                    }
                }
                catch (FileNotFoundException e) {
                    Mirror.throwSoftOrHardButAnyway((Throwable)e);
                }
                env.put(storage_name, store);
                return store;
            }
        };
    }

    public static <T> GetBy1 getAndAbsorb(final String key) {
        return new GetBy1<T, Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public T getBy(Map<String, Object> a) {
                Object ret = a.get(key);
                a.remove(key);
                if (null == ret) {
                    throw new RuntimeException("getAndAbsorb: value not present under key: " + key, (Throwable)this.POINT);
                }
                return ret;
            }
        };
    }

    public static <T> GetBy1 get(final String key) {
        return new GetBy1<T, Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public T getBy(Map<String, Object> a) {
                Object ret = a.get(key);
                if (null == ret) {
                    throw new RuntimeException("get: value not present under key: " + key, (Throwable)this.POINT);
                }
                return ret;
            }
        };
    }

    public static <T> GetBy1 createInto(final String key, final SimpleGet<?> collection_creator) {
        return new GetBy1<T, Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public T getBy(Map<String, Object> a) {
                Object ret = collection_creator.get();
                a.put(key, ret);
                return ret;
            }
        };
    }

    public static <T> GetBy1 create_into_if_nonex(final String key, final SimpleGet<T> creator) {
        return new GetBy1<T, Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public T getBy(Map<String, Object> a) {
                Object ret = a.get(key);
                if (null == ret) {
                    ret = creator.get();
                    a.put(key, ret);
                }
                return ret;
            }
        };
    }

    public static Collection<String> set(String ... val) {
        HashSet<String> ret = new HashSet<String>();
        for (String v : val) {
            ret.add(v);
        }
        return ret;
    }

    public static SimplePublish1<Map<String, Object>> download_pages_into_with_local_serial_connection(final GetBy1<Map<String, byte[]>, Map<String, Object>> dst_coll_get, final GetBy1<Collection<String>, Map<String, Object>> src_coll_get) {
        return new SimplePublish1<Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public void publish(Map<String, Object> env) {
                Map dst = (Map)SpiderProcessFunctions.assertCastType(Map.class, dst_coll_get.getBy(env), this.POINT);
                Collection src = (Collection)SpiderProcessFunctions.assertCastType(Collection.class, src_coll_get.getBy(env), this.POINT);
                for (String s : src) {
                    try {
                        byte[] data = SpiderTools.download((String)s, SpiderTools.getExtraHeaders());
                        if (null == data) continue;
                        dst.put(s, data);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public static SimplePublish1<Map<String, Object>> download_pages_with_single_proxy(GetBy1<Map<String, byte[]>, Map<String, Object>> dst_coll_get, GetBy1<Collection<String>, Map<String, Object>> src_coll_get, GetBy1<ProxyStorage, Map<String, Object>> get_spawnerStorage) {
        return SpiderProcessFunctions.download_pages_with_proxy_downloader(null, dst_coll_get, src_coll_get, get_spawnerStorage);
    }

    public static SimplePublish1<Map<String, Object>> download_pages_with_proxy_downloader(final @MayNull GetBy2<byte[], Proxy, URL> downloader, final GetBy1<Map<String, byte[]>, Map<String, Object>> dst_coll_get, final GetBy1<Collection<String>, Map<String, Object>> src_coll_get, final GetBy1<ProxyStorage, Map<String, Object>> get_spawnerStorage) {
        return new SimplePublish1<Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public void publish(Map<String, Object> env) {
                Map dst = (Map)SpiderProcessFunctions.assertCastType(Map.class, dst_coll_get.getBy(env), this.POINT);
                Collection src = (Collection)SpiderProcessFunctions.assertCastType(Collection.class, src_coll_get.getBy(env), this.POINT);
                ProxyStorage spawnerStorage = (ProxyStorage)SpiderProcessFunctions.assertCastType(ProxyStorage.class, get_spawnerStorage.getBy(env), this.POINT);
                try {
                    TorProxySpawner.ProxySource tp = spawnerStorage.getAtOffset(0);
                    Proxy p = tp.getProxy();
                    for (String toDownload : src) {
                        try {
                            long t0 = System.currentTimeMillis();
                            byte[] data = null;
                            data = null == downloader ? SpiderTools.download((Proxy)p, (String)toDownload, SpiderTools.getExtraHeaders()) : (byte[])downloader.getBy((Object)p, (Object)new URL(toDownload));
                            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.MEASURE, (String)"Url download \"%s\" took %s ms", (Object)toDownload, (Object)(System.currentTimeMillis() - t0));
                            if (null == data) continue;
                            dst.put(toDownload, data);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static <T> GetBy1<T, Map<String, Object>> wrapConst(final T ret) {
        return new GetBy1<T, Map<String, Object>>(){

            public T getBy(Map<String, Object> a) {
                return ret;
            }
        };
    }

    public static SimplePublish1<Map<String, Object>> download_pages_into_parallel_with_proxies(GetBy1<Map<String, byte[]>, Map<String, Object>> dst_coll_get, GetBy1<Collection<String>, Map<String, Object>> src_coll_get, GetBy1<ProxyStorage, Map<String, Object>> get_spawnerStorage, GetBy1<Integer, Map<String, Object>> get_proxies, GetBy1<Integer, Map<String, Object>> get_concurrency, boolean skip_exists) {
        return SpiderProcessFunctions.download_pages_into_parallel_with_proxies(null, dst_coll_get, src_coll_get, get_spawnerStorage, get_proxies, get_concurrency, skip_exists);
    }

    public static SimplePublish1<Map<String, Object>> download_pages_into_parallel_with_proxies(final @MayNull GetBy2<byte[], Proxy, URL> downloader, final GetBy1<Map<String, byte[]>, Map<String, Object>> dst_coll_get, final GetBy1<Collection<String>, Map<String, Object>> src_coll_get, final GetBy1<ProxyStorage, Map<String, Object>> get_spawnerStorage, final GetBy1<Integer, Map<String, Object>> get_proxies, final GetBy1<Integer, Map<String, Object>> get_concurrency, final boolean skip_exists) {
        return new SimplePublish1<Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public void publish(Map<String, Object> env) {
                Map dst = (Map)SpiderProcessFunctions.assertCastType(Map.class, dst_coll_get.getBy(env), this.POINT);
                ProxyStorage spawnerStorage = (ProxyStorage)SpiderProcessFunctions.assertCastType(ProxyStorage.class, get_spawnerStorage.getBy(env), this.POINT);
                int proxies = (Integer)SpiderProcessFunctions.assertCastType(Integer.class, get_proxies.getBy(env), this.POINT);
                int concurrency = (Integer)SpiderProcessFunctions.assertCastType(Integer.class, get_concurrency.getBy(env), this.POINT);
                Collection src = (Collection)SpiderProcessFunctions.assertCastType(Collection.class, src_coll_get.getBy(env), this.POINT);
                SpiderTools.downloadPagesIntoParallelWithProxies((GetBy2)downloader, (Map)dst, (Collection)src, null, (ProxyStorage)spawnerStorage, (int)proxies, (int)concurrency, (boolean)skip_exists);
            }
        };
    }

    public static SimplePublish1<Map<String, Object>> download_pages_into_parallel_with_proxies(GetBy1<Map<String, byte[]>, Map<String, Object>> dst_coll_get, GetBy1<Collection<String>, Map<String, Object>> src_coll_get, GetBy1<ProxyStorage, Map<String, Object>> get_spawnerStorage, GetBy1<Integer, Map<String, Object>> get_proxies, GetBy1<Integer, Map<String, Object>> get_concurrency) {
        return SpiderProcessFunctions.download_pages_into_parallel_with_proxies(dst_coll_get, src_coll_get, get_spawnerStorage, get_proxies, get_concurrency, false);
    }

    public static <T> T assertCastType(Class<?> dst, Object o, PointOfCreationException marker) {
        if (null == o) {
            throw new RuntimeException("Object is null", (Throwable)marker);
        }
        if (!dst.isAssignableFrom(o.getClass())) {
            throw new RuntimeException("Object [" + o.getClass() + "]:\"" + o + "\" is not instance of " + dst, (Throwable)marker);
        }
        return (T)o;
    }

    public static String tryParse(String name, byte[] data) throws IOException {
        if (name.endsWith(".gz")) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            GZIPInputStream in = new GZIPInputStream(bais);
            return new String(IOTools.loadAllFromInputStream((InputStream)in));
        }
        return new String(data);
    }

    public static SimplePublish1<Map<String, Object>> collect_site_map_xml_loc(final GetBy1<? extends Collection<String>, Map<String, Object>> src_coll_get, final GetBy1<? extends Map<String, byte[]>, Map<String, Object>> dst_coll_get, final GetBy1<String, String> ... filter) {
        return new SimplePublish1<Map<String, Object>>(){
            PointOfCreationException POINT = new PointOfCreationException();

            public void publish(Map<String, Object> env) {
                Map sitemap = (Map)SpiderProcessFunctions.assertCastType(Map.class, dst_coll_get.getBy(env), this.POINT);
                final Collection dst = (Collection)SpiderProcessFunctions.assertCastType(Collection.class, src_coll_get.getBy(env), this.POINT);
                final int[] added = new int[1];
                for (Map.Entry kv : sitemap.entrySet()) {
                    try {
                        String xml = SpiderProcessFunctions.tryParse((String)kv.getKey(), (byte[])kv.getValue());
                        SpiderProcessFunctions.selectAllLoc(DocumentTools.parseDocument((String)xml), (Collection<Node>)new PublisherCollection<Node>(){

                            public boolean add(Node n) {
                                if (null != n) {
                                    String add = n.getTextContent();
                                    added[0] = added[0] + 1;
                                    for (GetBy1 f : filter) {
                                        if (null != (add = (String)f.getBy((Object)add))) continue;
                                        return false;
                                    }
                                    if (null != add) {
                                        dst.add(add);
                                        return true;
                                    }
                                }
                                return false;
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public static void selectAllLoc(Document doc, Collection<Node> node) {
        DocumentTools.selectAll((Node)doc, node, (GetBy1)DocumentTools.selectNodesByTagName((String)"loc"));
    }
}

