/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.spider;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.storage.StoragesWarehouse;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.spider.AbstractWebSpider;
import eu.javaexperience.spider.SpiderFunctions;
import eu.javaexperience.url.UrlDownloadTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpiderTools
extends UrlDownloadTools {
    public static SimplePublish3<Map<String, byte[]>, Proxy, String> DOWNLOAD_INTO_STORAGE = new SimplePublish3<Map<String, byte[]>, Proxy, String>(){

        public void publish(Map<String, byte[]> a, Proxy b, String c) {
            try {
                a.put(c, UrlDownloadTools.download((Proxy)b, (String)c, null));
            }
            catch (Exception e) {
                Mirror.throwSoftOrHardButAnyway((Throwable)e);
            }
        }
    };
    protected static Map<String, String> HEADERS;

    public static void tryLogDownloadTime(String url, long dt) {
        LoggingTools.tryLogFormat((Logger)SpiderFunctions.LOG, (LoggingDetailLevel)LogLevel.MEASURE, (String)"Url download \"%s\" took %s ms", (Object)url, (Object)dt);
    }

    public static void processLinkPage(Document doc, SimplePublish2<Node, Collection<String>> selector, Collection<String> urls) {
        SpiderTools.processLinkPage(doc.getChildNodes(), selector, urls);
    }

    public static void processLinkPage(NodeList nl, SimplePublish2<Node, Collection<String>> selector, Collection<String> urls) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            selector.publish((Object)n, urls);
            SpiderTools.processLinkPage(n.getChildNodes(), selector, urls);
        }
    }

    public static void downloadPage(String link, Map<String, byte[]> url_to_content, Map<String, String> headers) throws MalformedURLException, IOException {
        byte[] data = SpiderTools.download((URL)new URL(link), headers);
        url_to_content.put(link, data);
    }

    public static void downloadPages(Collection<String> links, Map<String, byte[]> url_to_content, Map<String, String> headers) {
        for (String url : links) {
            try {
                SpiderTools.downloadPage(url, url_to_content, headers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void processAndStoreListerPage(NodeList doc, String list_destination_file, SimplePublish2<Node, Collection<String>> selector, Collection<String> urls) throws FileNotFoundException, IOException {
        SpiderTools.processLinkPage(doc, selector, urls);
        SpiderTools.storeUrlList(list_destination_file, urls);
    }

    public static void loadFillUrlList(String source, Collection<String> urls) throws FileNotFoundException, IOException {
        IOTools.loadFillAllLine((String)source, urls);
    }

    public static void storeUrlList(String dst, Collection<String> urls) throws FileNotFoundException, IOException {
        try (PrintWriter pw = new PrintWriter(dst);){
            for (String s : urls) {
                pw.println(URLEncoder.encode(s));
            }
            pw.flush();
        }
    }

    public static void discoverSiteInDepth(URL start_link, int depth, final Map<String, byte[]> download_to, final GetBy1<Boolean, URL> may_visit, final SimplePublish3<URL, List<URL>, List<URL>> url_map) throws MalformedURLException {
        AbstractWebSpider aws = new AbstractWebSpider(start_link){

            @Override
            public boolean shallReturnByParsedDocument(URL link, String data, Document doc) {
                return false;
            }

            @Override
            public boolean preShallReturn(URL link) {
                return false;
            }

            @Override
            public boolean postShallReturn(URL link, byte[] data) {
                download_to.put(link.toString(), data);
                return false;
            }

            @Override
            public void publishSiteLinks(URL url, List<URL> all_link, List<URL> domain_links) {
                if (null != url_map) {
                    url_map.publish((Object)url, all_link, domain_links);
                }
            }

            @Override
            public boolean isSelfURL(URL URL2) {
                return Boolean.TRUE == may_visit.getBy((Object)URL2);
            }
        };
        aws.getRecursiveSiteMapWhitoutDuplication(start_link, Integer.MAX_VALUE);
    }

    public static void fullSiteIterateOnDomain(URL start_link, Map<String, byte[]> download_to, GetBy1<Boolean, URL> may_visit, SimplePublish3<URL, List<URL>, List<URL>> url_map) throws MalformedURLException {
        SpiderTools.discoverSiteInDepth(start_link, Integer.MAX_VALUE, download_to, may_visit, url_map);
    }

    public static Map<String, String> getExtraHeaders() {
        return HEADERS;
    }

    public static SimplePublish3<Map<String, String>, Proxy, String> downloadIntoStorageWithEncoding(final String encoding) {
        return new SimplePublish3<Map<String, String>, Proxy, String>(){

            public void publish(Map<String, String> a, Proxy b, String c) {
                try {
                    byte[] data = UrlDownloadTools.download((Proxy)b, (String)c, null);
                    a.put(c, new String(data, encoding));
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway((Throwable)e);
                }
            }
        };
    }

    public static SimplePublish3<Map<String, byte[]>, Proxy, String> downloadIntoStorageRaw() {
        return new SimplePublish3<Map<String, byte[]>, Proxy, String>(){

            public void publish(Map<String, byte[]> a, Proxy b, String c) {
                try {
                    byte[] data = UrlDownloadTools.download((Proxy)b, (String)c, null);
                    a.put(c, data);
                }
                catch (Exception e) {
                    Mirror.throwSoftOrHardButAnyway((Throwable)e);
                }
            }
        };
    }

    public static StoragesWarehouse<byte[]> getWarehouseStorage(String warehouse_dir, String unit_name) {
        return new StoragesWarehouse(warehouse_dir + "/" + unit_name + "/");
    }

    static {
        SmallMap map = new SmallMap();
        map.put("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.104 Safari/537.36");
        map.put("Accept-Language", "hu-HU,hu;q=0.8,en-US;q=0.6,en;q=0.4");
        map.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,");
        map.put("Cache-Control", "max-age=0");
        HEADERS = Collections.unmodifiableMap(map);
    }
}

