/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.DataReprezType;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.datareprez.convertFrom.ReadWriteObjectLike;
import eu.javaexperience.datareprez.jsonImpl.DataArrayJsonImpl;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotModified;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.Validatable;
import eu.javaexperience.webgsdb.RemoteGsdbTools;
import eu.jvx.js.lib.TeaVmTools;
import eu.jvx.js.lib.reflect.TeaVmMockedReflection;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStorageMappingData;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreException;
import hu.ddsi.java.database.GsdbModel;
import hu.ddsi.java.database.fieldAnnotations.GenericStoreIgnore;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;

public abstract class WebDbModel
extends GsdbModel
implements ReadWriteObjectLike,
Cloneable,
Validatable<LanguageTranslatableValidationEntry>,
ExternalDataAttached {
    @MayNotModified
    public Date createdOn = new Date();
    @MayNotModified
    public Date lastModify = new Date();
    private static final long serialVersionUID = 1L;
    protected static final ConcurrentHashMap<Class<? extends GenericStorable>, GsdbModelMappingData> mappingData = new ConcurrentHashMap();
    @GenericStoreIgnore
    protected transient Map<String, Object> extraData;

    public void beforeStored(GenericStoreDatabase db) {
        super.beforeStored(db);
        this.lastModify = new Date();
    }

    protected static GsdbModelMappingData getMappingData(Class<? extends GenericStorable> cls) throws InstantiationException, IllegalAccessException {
        GsdbModelMappingData ret = mappingData.get(cls);
        if (null == ret) {
            ret = new GsdbModelMappingData();
            FieldData[] d = GenericStorageMappingData.getOrCollectAllClassData(cls).allFd;
            ret.keys = new String[d.length + 2];
            ret.keys[0] = "do";
            ret.keys[1] = "class";
            int n = 1;
            for (int i = 0; i < d.length; ++i) {
                Field f = d[i].f;
                if (!RemoteGsdbTools.isWebgsdbUseField(f)) continue;
                ret.keys[++n] = f.getName();
                ret.getFieldValue.put(f.getName(), f);
            }
            if (n != ret.keys.length) {
                ret.keys = Arrays.copyOfRange(ret.keys, 0, n + 1);
            }
        }
        return ret;
    }

    public static <G extends WebDbModel> G parse(GenericStoreDatabase gdb, Class<G> cls, DataObject from) throws InstantiationException, IllegalAccessException, GenericStoreException {
        WebDbModel ret = (WebDbModel)cls.newInstance();
        GsdbModelMappingData mapping = WebDbModel.getMappingData(cls);
        for (Map.Entry<String, Field> kv : mapping.getFieldValue.entrySet()) {
            String key = kv.getKey();
            ret.set(key, from.get(key));
        }
        return (G)ret;
    }

    public Long getModelId() {
        return GenericStorage.getID((GenericStorable)this);
    }

    public Object get(String key) {
        if ("do".equals(key)) {
            return GenericStorage.getID((GenericStorable)this);
        }
        if ("class".equals(key)) {
            return this.getClass().getName();
        }
        GsdbModelMappingData mapping = null;
        try {
            mapping = WebDbModel.getMappingData(this.getClass());
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        Field f = mapping.getFieldValue.get(key);
        if (null == f) {
            return this.getExtraDataMap().get(key);
        }
        try {
            Object ret = null;
            if (TeaVmTools.IS_FRONTEND) {
                return TeaVmMockedReflection.getObjectField((Object)this, (String)key);
            }
            ret = f.get(this);
            if (null != ret) {
                if (ret.getClass().isEnum()) {
                    return ((Enum)ret).name();
                }
                if (ret.getClass().isArray()) {
                    Class<?> comp = ret.getClass().getComponentType();
                    if (GenericStorable.class.isAssignableFrom(comp)) {
                        Long[] r = new Long[((Object[])ret).length];
                        for (int i = 0; i < r.length; ++i) {
                            GenericStorable elem = ((GenericStorable[])ret)[i];
                            r[i] = null == elem ? Long.valueOf(-1L) : Long.valueOf(GenericStorage.getID((GenericStorable)elem));
                        }
                        return r;
                    }
                    return ret;
                }
                if (ret instanceof GenericStorable) {
                    return GenericStorage.getID((GenericStorable)((GenericStorable)ret));
                }
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DataReprezType getDataReprezType() {
        return DataReprezType.OBJECT;
    }

    public boolean has(String key) {
        return ArrayTools.contains((Object[])this.keys(), (Object)key);
    }

    public String[] keys() {
        GsdbModelMappingData mapping = null;
        try {
            mapping = WebDbModel.getMappingData(this.getClass());
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        return mapping.keys;
    }

    public int size() {
        return this.keys().length;
    }

    public boolean set(String key, Object src) {
        return this.set(key, src, false);
    }

    public boolean set(String key, Object src, boolean filter) {
        try {
            GsdbModelMappingData mapping = WebDbModel.getMappingData(this.getClass());
            Field f = mapping.getFieldValue.get(key);
            if (null != f) {
                if (filter && null != f.getAnnotation(MayNotModified.class)) {
                    return false;
                }
                if (null != src) {
                    src = WebDbModel.tryCast(this, f.getType(), src);
                    if (TeaVmTools.IS_FRONTEND) {
                        return TeaVmMockedReflection.setObjectField((Object)this, (String)key, (Object)src);
                    }
                    f.set(this, src);
                    return true;
                }
            } else {
                this.getExtraDataMap().put(key, src);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected static <T> Object tryCast(WebDbModel subject, Class reqType, Object src) throws Exception {
        if (GenericStorable.class.isAssignableFrom(reqType)) {
            GenericStoreDatabase gdb;
            Long id = (Long)CastTo.Long.cast(src);
            if (null != id && null != (gdb = GenericStorage.getOwnerDatabase((GenericStorable)subject))) {
                return GenericStorage.getObjectByIDDescendantOf((long)id, (Class)reqType, (GenericStoreDatabase)gdb);
            }
        } else {
            if (reqType.isEnum()) {
                return EnumTools.recogniseSymbol((Class)reqType, (Object)src);
            }
            CastTo c = CastTo.getCasterRestrictlyForTargetClass((Class)reqType);
            if (null != c) {
                return c.cast(src);
            }
        }
        if (reqType.isEnum()) {
            if (src instanceof DataObject) {
                return EnumTools.recogniseSymbol((Class)reqType, (Object)((DataObject)src).optString("name"));
            }
        } else {
            if (reqType.isArray()) {
                DataArray arr = null;
                if (src instanceof String) {
                    arr = new DataArrayJsonImpl(new JSONArray(src.toString()));
                } else if (src instanceof DataArray) {
                    arr = (DataArray)src;
                }
                Class<?> nType = reqType.getComponentType();
                Object[] ret = (Object[])Array.newInstance(nType, arr.size());
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = WebDbModel.tryCast(subject, nType, arr.get(i));
                }
                return ret;
            }
            if (null != reqType && null != src && reqType.isAssignableFrom(src.getClass())) {
                return src;
            }
        }
        return null;
    }

    public void unset(String key) {
        this.set(key, null);
    }

    public WebDbModel clone() {
        try {
            return (WebDbModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public void loadFrom(ObjectLike from) {
        for (String k : from.keys()) {
            this.set(k, from.get(k));
        }
    }

    public void loadFromUser(ObjectLike from) {
        for (String k : from.keys()) {
            this.set(k, from.get(k), true);
        }
    }

    public Map<String, Object> getExtraDataMap() {
        if (null == this.extraData) {
            this.extraData = new SmallMap();
        }
        return this.extraData;
    }

    public static boolean letDeleteIfNoRef(GenericStorable gs, Collection<LanguageTranslatableValidationEntry> validate) {
        try {
            ArrayList gss = new ArrayList();
            GenericStorage.getReferences((GenericStorable)gs, gss);
            if (gss.isEmpty()) {
                GenericStoreDatabase gdb = GenericStorage.getOwnerDatabase((GenericStorable)gs);
                GenericStorage.removeObject((GenericStorable)gs, (GenericStoreDatabase)gdb);
                return true;
            }
            for (GenericStorable ref : gss) {
                validate.add(new LanguageTranslatableValidationEntry((LoggingDetailLevel)LogLevel.ERROR, new TranslationFriendlyValidationEntry("reference", "db_referenced_in_use", (Map)new OneShotMap((Object)"str", (Object)ref.toString()))));
            }
            return false;
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return false;
        }
    }

    public abstract boolean delete(Collection<LanguageTranslatableValidationEntry> var1);

    public String getModelClass() {
        return (String)this.get("class");
    }

    protected static class GsdbModelMappingData {
        protected HashMap<String, Field> getFieldValue = new HashMap();
        public String[] keys;

        protected GsdbModelMappingData() {
        }
    }
}

