/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassDescriptorTools;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;
import eu.javaexperience.collection.map.ConcurrentMapTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.teavm.datareprez.DataArrayTeaVMImpl;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.webgsdb.RemoteGsdbTools;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.commons.FieldExtraAttributes;
import eu.javaexperience.webgsdb.commons.FrontendFieldEditContext;
import eu.javaexperience.webgsdb.commons.FrontendFieldManager;
import eu.javaexperience.webgsdb.commons.ModelData;
import eu.javaexperience.webgsdb.frontend.modellayer.ModelManager;
import eu.javaexperience.webgsdb.frontend.modellayer.WebModel;
import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainerTools;
import eu.jvx.js.lib.ui.component.func.HtmlListContainerUserEditable;
import eu.jvx.js.lib.ui.component.input.SelectList;
import eu.jvx.js.lib.ui.component.input.SelectOption;
import eu.jvx.js.tbs.ui.TbsLayoutTools;
import hu.ddsi.java.database.F;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStorageMappingData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.teavm.jso.JSObject;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.json.JSON;

public class WebGsdbTools {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("WebGsdbTools"));
    public static final FrontendFieldManager DEFAULT_FRONTEND_FIELD_MANAGER = new FrontendFieldManager<WebDbModel>(){

        @Override
        public String toString(WebDbModel model, String field) {
            Object ret = model.get(field);
            if (!(ret instanceof Object)) {
                return "";
            }
            if (ret instanceof Date) {
                return Format.SQL_TIMESTAMP.format((Date)ret);
            }
            if (ret.getClass().isArray()) {
                return ArrayTools.toString((Object[])((Object[])ret));
            }
            return String.valueOf(ret);
        }

        @Override
        public HTMLElement toEditable(FrontendFieldEditContext<WebDbModel> ctx) {
            return WebGsdbTools.generateEditableOfType(ctx, ctx.field.getName(), ctx.field.getType(), ctx.value);
        }
    };
    public static final Set<String> CLS_BOOLEAN = WebGsdbTools.collect("java.lang.Boolean", "boolean");
    public static final Set<String> CLS_NUMBER = WebGsdbTools.collect("java.lang.Byte", "byte", "java.lang.Short", "short", "java.lang.Integer", "int", "java.lang.Long", "long", "java.lang.Float", "float", "java.lang.Double", "double", "java.lang.Number", "java.math.BigDecimal", "java.math.BigInteger");
    public static final Set<String> CLS_DATE = WebGsdbTools.collect("java.util.Date", "java.sql.Date");
    public static final String GSDB_FIELD_EXTRA_ATTRIBUTES_KEY = "GSDB_FIELD_EXTRA_ATTRIBUTES";
    protected static final ConcurrentMap<Class, ModelData> MODEL_EXTRA_DATA = new ConcurrentHashMap<Class, ModelData>();
    protected static final GetBy1<ModelData, Class> CREATE_MODEL_DATA_STORAGE = cls -> new ModelData((Class<? extends WebDbModel>)cls);

    public static <E extends EnumLike<E>> HTMLElement generateEnumChoose(EnumManager<E> es, @MayNull String noneLabel, String name, String value) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateEnumChoose(enumManager: %s, noneLabel: %s, name: %s, value: %s)", (Object[])new Object[]{es, noneLabel, name, value});
        SelectList l = new SelectList();
        if (null != noneLabel) {
            l.addOption(null, noneLabel);
        }
        for (Object s : es.getValues()) {
            EnumLike e = (EnumLike)s;
            String n = e.getName();
            SelectOption so = l.addOption(n, n);
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateEnumChoose: add option (%s)", (Object)n);
            if (null == value || !value.equals(n)) continue;
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateEnumChoose: selecting (%s)", (Object)n);
            so.selectThis();
        }
        if (null != name) {
            l.getHtml().setAttribute("name", name);
        }
        VanillaTools.stringAttrs((HTMLElement)l.getHtml(), (String)"class", (String)"form-control");
        return l.getHtml();
    }

    public static <T extends WebDbModel> TbsLayoutTools.SimpleFormRow createModelFieldInputRow(String fieldLabel, FrontendFieldEditContext<T> ctx, @MayNull FrontendFieldManager<T> mngr) {
        if (null == mngr) {
            mngr = DEFAULT_FRONTEND_FIELD_MANAGER;
        }
        return new TbsLayoutTools.SimpleFormRow(ctx.idLabelFor, fieldLabel + ": ", mngr.toEditable(ctx));
    }

    public static TbsLayoutTools.SimpleFormRow createModelFieldInputRow(ModelManager<WebDbModel> sma, String id, String trname, ClassFieldDescriptor fd, Object value) {
        FrontendFieldEditContext ctx = new FrontendFieldEditContext();
        return WebGsdbTools.createModelFieldInputRow(trname, ctx, DEFAULT_FRONTEND_FIELD_MANAGER);
    }

    protected static Set<String> collect(String ... args) {
        return Collections.unmodifiableSet((Set)CollectionTools.inlineAdd(new HashSet(), (Object[])args));
    }

    protected static HTMLElement generateModelEditable(FrontendFieldEditContext<WebDbModel> ctx, String name, ClassDescriptor type, Object value) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateModelEditable type is GenericStorable", (Object[])new Object[0]);
        SelectList sl = new SelectList();
        List a = ctx.acc.select(type, F.gt.is("do", (Object)-1));
        Long selected = (Long)CastTo.Long.cast(value);
        for (WebDbModel d : a) {
            String id = String.valueOf(CastTo.Long.cast((Object)d.getModelId()));
            SelectOption so = sl.addOption(id, d.toString());
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateModelEditable - GenericStorable: add option: %s -> %s", (Object)id, (Object)d.toString());
            Long check = (Long)CastTo.Long.cast((Object)id);
            if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"generateModelEditable - isSelected? search: %s actual: %s", (Object)selected, (Object)check);
            }
            if (null == selected || !selected.equals(check)) continue;
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateModelEditable - GenericStorable: set selected: %s -> %s", (Object)selected, (Object)check);
            so.selectThis();
        }
        return new H(sl.getHtml()).attrs(new String[]{"name", name, "class", "form-control"}).getHtml();
    }

    protected static HTMLElement generateEditableOfPrimitiveType(FrontendFieldEditContext<WebDbModel> ctx, String name, ClassDescriptor type, Object value) {
        String fType = "text";
        if (CLS_BOOLEAN.contains(type.getClassName())) {
            fType = "checkbox";
        } else if (CLS_NUMBER.contains(type.getClassName())) {
            fType = "number";
        }
        H elem = new H("input").attrs(new String[]{"type", fType, "name", name, "class", "form-control"});
        HTMLInputElement e = (HTMLInputElement)elem.getHtml();
        HtmlDataContainer dc = null;
        if (CLS_DATE.contains(type.getClassName())) {
            elem.attrs(new String[]{"type", "datetime-local"});
            dc = HtmlDataContainerTools.browserDatetimeLocal((HTMLInputElement)e);
        } else {
            dc = HtmlDataContainerTools.wrapInput((HTMLInputElement)e);
        }
        ImpTools.appendImp((Element)e, (ImpersonalisedHtml)dc);
        if (null != value && value instanceof Object) {
            dc.setData((Object)value.toString());
        }
        return e;
    }

    protected static HTMLElement generateEditableOfType(FrontendFieldEditContext<WebDbModel> ctx, String name, ClassDescriptor type, Object value) {
        if (type.isArray()) {
            return WebGsdbTools.generateMultiOf(name, type.getComponentType(), ctx, value);
        }
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateEditableOfType(name: %s, type: %s, value: %s)", (Object)name, (Object)type.getClassName(), (Object)value);
        FieldExtraAttributes fa = ctx.field.getExtraAttributes();
        if (null != fa && null != fa.frontendFieldManager) {
            try {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateEditableOfType(fa.frontendFieldManager: %s)", (Object)fa.frontendFieldManager);
                return ((FrontendFieldManager)Class.forName(fa.frontendFieldManager).newInstance()).toEditable(ctx);
            }
            catch (Exception e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"generateEditableOfType: ");
                Mirror.propagateAnyway((Throwable)e);
            }
        }
        boolean gs = false;
        ArrayList<ClassDescriptor> sups = new ArrayList<ClassDescriptor>();
        ClassDescriptorTools.collectAllSuperClass(sups, type);
        for (ClassDescriptor sup : sups) {
            if (!sup.getClassName().equals("hu.ddsi.java.database.GenericStorable")) continue;
            gs = true;
            break;
        }
        if (gs) {
            return WebGsdbTools.generateModelEditable(ctx, name, type, value);
        }
        if (type.isEnum()) {
            return new H(WebGsdbTools.generateEnumChoose(type.getEnumManager(), null, name, String.valueOf(value))).getHtml();
        }
        return WebGsdbTools.generateEditableOfPrimitiveType(ctx, name, type, value);
    }

    public static HTMLElement generateMultiOf(String masterName, final ClassDescriptor type, final FrontendFieldEditContext ctx, Object value, final GetBy2<HtmlDataContainer<String>, FrontendFieldEditContext, ClassDescriptor> unitCreator) {
        final HtmlListContainerUserEditable ret = new HtmlListContainerUserEditable(){

            protected HtmlDataContainer<String> create() {
                return (HtmlDataContainer)unitCreator.getBy((Object)ctx, (Object)type);
            }
        };
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateMultiOf(name: %s, type: %s, value: %s)", (Object)masterName, (Object)type.getClassName(), (Object)value);
        final H input = new H("input").attrs(new String[]{"type", "hidden", "name", masterName});
        input.on("serialize", (EventListener)new EventListener<Event>(){

            public void handleEvent(Event arg0) {
                ((HTMLInputElement)input.getHtml()).setValue((String)ret.getData());
            }
        });
        new H(ret.getHtml()).addChilds(new H[]{input});
        if (null != value) {
            if (value.getClass().isArray()) {
                DataArrayTeaVMImpl arr = new DataArrayTeaVMImpl();
                Object[] os = (Object[])value;
                for (int i = 0; i < os.length; ++i) {
                    Object o = os[i];
                    if (o instanceof GenericStorable) {
                        o = GenericStorage.getID((GenericStorable)((GenericStorable)o));
                    }
                    DataReprezTools.put((DataArray)arr, (int)i, (Object)o);
                }
                value = JSON.stringify((JSObject)((JSObject)arr.getImpl()));
            } else if (value instanceof DataArray) {
                value = JSON.stringify((JSObject)((JSObject)((DataArray)value).getImpl()));
            }
            try {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateMultiOf -  setting container value: %s", (Object)value);
                ret.setData((Object)String.valueOf(value));
            }
            catch (Exception e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"value: %s", (Object)value);
            }
        }
        return ret.getHtml();
    }

    public static HTMLElement generateMultiOf(String masterName, ClassDescriptor type, FrontendFieldEditContext ctx, Object value) {
        return WebGsdbTools.generateMultiOf(masterName, type, ctx, value, new GetBy2<HtmlDataContainer<String>, FrontendFieldEditContext, ClassDescriptor>(){

            public HtmlDataContainer<String> getBy(FrontendFieldEditContext ctx, ClassDescriptor type) {
                HTMLElement cre = WebGsdbTools.generateEditableOfType(ctx, null, type, null);
                return (HtmlDataContainer)ImpTools.getImp((Element)cre);
            }
        });
    }

    public static FieldExtraAttributes tryGetModelFieldExtraAttributes(FieldData fd) {
        return (FieldExtraAttributes)fd.getExtraDataMap().get(GSDB_FIELD_EXTRA_ATTRIBUTES_KEY);
    }

    public static ModelData getModelData(Class<? extends WebModel> cls) {
        return (ModelData)ConcurrentMapTools.getOrCreate(MODEL_EXTRA_DATA, cls, CREATE_MODEL_DATA_STORAGE);
    }

    public static void putFieldAttributes(Class<? extends WebDbModel> cls, Object ... name_FieldExtraAttributes) {
        FieldData[] fds;
        HashMap<String, FieldExtraAttributes> fieldDatas = new HashMap<String, FieldExtraAttributes>();
        for (int i = 0; i < name_FieldExtraAttributes.length; i += 2) {
            fieldDatas.put((String)name_FieldExtraAttributes[i], (FieldExtraAttributes)name_FieldExtraAttributes[i + 1]);
        }
        ModelData md = new ModelData(cls);
        for (FieldData fd : fds = GenericStorageMappingData.getOrCollectAllClassData(cls).allFd) {
            if (!RemoteGsdbTools.isWebgsdbUseField(fd.f)) continue;
            FieldExtraAttributes dat = (FieldExtraAttributes)fieldDatas.get(fd.f.getName());
            if (null == dat) {
                System.out.println("No field metadata attached: " + cls.getName() + "." + fd.f.getName());
                continue;
            }
            dat.owner = md;
            if (null == dat) continue;
            fd.getExtraDataMap().put(GSDB_FIELD_EXTRA_ATTRIBUTES_KEY, dat);
        }
    }

    public static <D extends WebDbModel> FrontendFieldManager<D> getFrontendFieldManager(D model, ClassFieldDescriptor fd, FieldExtraAttributes fa) {
        FrontendFieldManager ffm = null;
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"getFrontendFieldManager(model: %s, field: %s, extra: %s)", model, (Object)fd, (Object)fa);
        if (null != fa && null != fa.frontendFieldManager) {
            try {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"getFrontendFieldManager - creating new instance of custom frontendFieldManager: %s", (Object)fa.frontendFieldManager);
                ffm = (FrontendFieldManager)Class.forName(fa.frontendFieldManager).newInstance();
            }
            catch (Exception e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"getFrontendFieldManager - Can't initialize FrontendFieldManager for: %s : %s | %s ", (Object[])new Object[]{model.getClass(), fd.getName(), fa.frontendFieldManager});
                e.printStackTrace();
            }
        }
        if (null == ffm) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"getFrontendFieldManager - using default frontendFieldManager", (Object[])new Object[0]);
            ffm = DEFAULT_FRONTEND_FIELD_MANAGER;
        }
        return ffm;
    }

    public static String translate(String trname) {
        if (null != trname && trname.contains(".")) {
            trname = StringTools.getSubstringAfterLastString((String)trname, (String)".", (String)trname);
        }
        return trname;
    }

    public static void generateModelEditor(SimplePublish1<TbsLayoutTools.SimpleFormRow> builder, ClassDescriptor cls, WebDbModel model, FrontendFieldEditContext baseCtx) {
        String ns = StringTools.randomString((int)10);
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"generateModelEditor(cls: %s)", (Object)cls);
        for (ClassFieldDescriptor classFieldDescriptor : cls.getAllField()) {
            if (!classFieldDescriptor.isUserAccessible()) continue;
            String fieldName = classFieldDescriptor.getName();
            FieldExtraAttributes fa = classFieldDescriptor.getExtraAttributes();
            if (null != fa && (!fa.userCanModify || !fa.userMaySee)) continue;
            String trname = classFieldDescriptor.getTranslationSymbol();
            trname = WebGsdbTools.translate(trname);
            Object val = null;
            if (null != model) {
                Object o = model.get(classFieldDescriptor.getName());
                val = o instanceof WebDbModel ? String.valueOf(CastTo.Long.cast(((WebDbModel)o).get("do"))) : model.get(fieldName);
            }
            Object ctx = baseCtx.clone();
            ((FrontendFieldEditContext)ctx).field = classFieldDescriptor;
            ((FrontendFieldEditContext)ctx).idLabelFor = ns + fieldName;
            ((FrontendFieldEditContext)ctx).model = model;
            ((FrontendFieldEditContext)ctx).value = val;
            HTMLElement edit = WebGsdbTools.generateEditableOfType((FrontendFieldEditContext<WebDbModel>)ctx, fieldName, classFieldDescriptor.getType(), val);
            builder.publish((Object)new TbsLayoutTools.SimpleFormRow(((FrontendFieldEditContext)ctx).idLabelFor, trname + ": ", edit));
        }
    }
}

