/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassDescriptorTools;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpace;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicClassField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DinamicClassDescriptor
implements ClassDescriptor,
ObjectWithProperty {
    protected ClassSpace classSpace;
    protected String name;
    protected List<ClassFieldDescriptor> fields;
    protected EnumManager enumManager;
    protected ClassDescriptor componentType;
    protected int modifiers;
    protected boolean isInterface;
    protected List<ClassDescriptor> supers = NullList.instance;

    protected DinamicClassDescriptor() {
    }

    public DinamicClassDescriptor(ClassSpace classSpace, String name, List<ClassFieldDescriptor> fields, EnumManager enumManager, ClassDescriptor componentType, int modifiers, boolean isInterface) {
        this.classSpace = classSpace;
        this.name = name;
        this.fields = fields;
        this.enumManager = enumManager;
        this.componentType = componentType;
        this.modifiers = modifiers;
        this.isInterface = isInterface;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getClassName() {
        return this.name;
    }

    @Override
    public List<? extends ClassFieldDescriptor> getAllField() {
        return this.fields;
    }

    @Override
    public boolean isEnum() {
        return null != this.enumManager;
    }

    @Override
    public EnumManager getEnumManager() {
        return this.enumManager;
    }

    @Override
    public boolean isArray() {
        return null != this.componentType;
    }

    @Override
    public ClassDescriptor getComponentType() {
        return this.componentType;
    }

    public static DinamicClassDescriptor createArrayType(ClassDescriptor cd) {
        DinamicClassDescriptor ret = new DinamicClassDescriptor();
        ret.name = cd.getClassName() + "[]";
        ret.componentType = cd;
        ret.fields = NullList.instance;
        return ret;
    }

    public static <E extends EnumLike<E>> DinamicClassDescriptor createEnumeration(String name, E ... values) {
        DinamicClassDescriptor ret = new DinamicClassDescriptor();
        ret.name = name;
        ret.enumManager = EnumTools.createFromEnumLikes(values);
        ret.fields = NullList.instance;
        return ret;
    }

    public static <E extends EnumLike<E>> DinamicClassDescriptor createClass(List<ClassDescriptor> supers, String name, int modifiers, ClassFieldDescriptor ... fields) {
        DinamicClassDescriptor ret = new DinamicClassDescriptor();
        ret.supers = Collections.unmodifiableList(supers);
        ret.name = name;
        ret.modifiers = modifiers;
        ret.fields = Collections.unmodifiableList((List)CollectionTools.inlineAdd(new ArrayList(), (Object[])fields));
        for (ClassFieldDescriptor f : fields) {
            if (!(f instanceof DinamicClassField)) continue;
            ((DinamicClassField)f).ownerClass = ret;
        }
        return ret;
    }

    public String toString() {
        return "DinamicClassDescriptor: name: " + this.name;
    }

    @Override
    public List<ClassDescriptor> getSuperTypes() {
        return this.supers;
    }

    public Object get(String key) {
        return ClassDescriptorTools.classPropGet(this, key);
    }

    public String[] keys() {
        return ClassDescriptorTools.classPropKeys();
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public ClassSpace getClassSpace() {
        return this.classSpace;
    }

    @Override
    public void setClassSpace(ClassSpace classSpace) {
        this.classSpace = classSpace;
    }
}

