/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.classes;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.webgsdb.frontend.modellayer.java.JavaClassField;
import hu.ddsi.java.database.WrappedAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ClassDescriptorTools {
    protected static ObjectWithPropertyStorage<ClassDescriptor> CLASS_PROPS = new ObjectWithPropertyStorage();
    protected static ObjectWithPropertyStorage<ClassFieldDescriptor> FIELD_PROPS = new ObjectWithPropertyStorage();

    public static void collectAllSuperClass(List<ClassDescriptor> sups, ClassDescriptor type) {
        sups.add(type);
        for (ClassDescriptor sup : type.getSuperTypes()) {
            ClassDescriptorTools.collectAllSuperClass(sups, sup);
        }
    }

    protected static Object wrapAnnotations(ClassFieldDescriptor f) {
        if (f instanceof JavaClassField) {
            JavaClassField cfd = (JavaClassField)f;
            return WrappedAnnotation.wrap((Annotation[])cfd.getJavaField().getAnnotations());
        }
        return null;
    }

    protected static Object wrapEnums(EnumManager enumManager) {
        if (null == enumManager) {
            return null;
        }
        Object[] vs = enumManager.getValues();
        for (int i = 0; i < vs.length; ++i) {
            EnumLike el = (EnumLike)vs[i];
            SmallMap add = new SmallMap();
            add.put((Object)"oridnal", (Object)el.getOrdinal());
            add.put((Object)"name", (Object)el.getName());
            vs[i] = add;
        }
        return vs;
    }

    public static List<ClassDescriptor> getSuperInterfaces(ClassDescriptor cls) {
        ArrayList<ClassDescriptor> ret = new ArrayList<ClassDescriptor>();
        for (ClassDescriptor t : cls.getSuperTypes()) {
            if (!t.isInterface()) continue;
            ret.add(t);
        }
        return ret;
    }

    public static ClassDescriptor getSuperClass(ClassDescriptor cls) {
        for (ClassDescriptor t : cls.getSuperTypes()) {
            if (t.isInterface()) continue;
            return t;
        }
        return null;
    }

    public static String[] classPropKeys() {
        return CLASS_PROPS.keys();
    }

    public static Object classPropGet(ClassDescriptor cd, String key) {
        return CLASS_PROPS.get((Object)cd, key);
    }

    public static String[] fieldPropKeys() {
        return FIELD_PROPS.keys();
    }

    public static Object fieldPropGet(ClassFieldDescriptor cfd, String key) {
        return FIELD_PROPS.get((Object)cfd, key);
    }

    static {
        CLASS_PROPS.addExaminer("name", e -> StringTools.getSubstringAfterLastString((String)e.getClassName(), (String)"."));
        CLASS_PROPS.addExaminer("fullName", e -> e.getClassName());
        CLASS_PROPS.addExaminer("superClass", e -> ClassDescriptorTools.getSuperClass(e));
        CLASS_PROPS.addExaminer("superInterfaces", e -> ClassDescriptorTools.getSuperInterfaces(e));
        CLASS_PROPS.addExaminer("isArray", e -> e.isArray());
        CLASS_PROPS.addExaminer("isEnum", e -> e.isEnum());
        CLASS_PROPS.addExaminer("arrayComponent", e -> e.getComponentType());
        CLASS_PROPS.addExaminer("enums", e -> ClassDescriptorTools.wrapEnums(e.getEnumManager()));
        CLASS_PROPS.addExaminer("isInterface", e -> e.isInterface());
        CLASS_PROPS.addExaminer("isAbstract", e -> Modifier.isAbstract(e.getModifiers()));
        CLASS_PROPS.addExaminer("modifiers", e -> e.getModifiers());
        CLASS_PROPS.addExaminer("fields", e -> e.getAllField());
        FIELD_PROPS.addExaminer("name", f -> f.getName());
        FIELD_PROPS.addExaminer("declaringClass", f -> f.getOwnerModel().getClassName());
        FIELD_PROPS.addExaminer("type", f -> f.getType().getClassName());
        FIELD_PROPS.addExaminer("modifiers", f -> f.getModifiers());
        FIELD_PROPS.addExaminer("annotations", f -> ClassDescriptorTools.wrapAnnotations(f));
    }
}

