/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend.modellayer.java;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassDescriptorTools;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.enumerations.EnumManager;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpace;
import eu.javaexperience.webgsdb.frontend.modellayer.java.JavaClassField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JavaClassDescriptor
implements ClassDescriptor,
ObjectWithProperty {
    protected ClassSpace classSpace;
    protected Class cls;
    protected EnumManager enums;
    protected List<JavaClassField> fields;
    protected ClassDescriptor componentType;
    protected static final ConcurrentMap<Class, JavaClassDescriptor> CLS_DESCRIPTORS = new ConcurrentHashMap<Class, JavaClassDescriptor>();
    protected static final GetBy1<JavaClassDescriptor, Class> WRAP_CLASS = new GetBy1<JavaClassDescriptor, Class>(){

        public JavaClassDescriptor getBy(Class a) {
            if (a == null) {
                return null;
            }
            JavaClassDescriptor ret = new JavaClassDescriptor();
            ret.cls = a;
            ret.fields = JavaClassField.wrapAll(Mirror.getClassData((Class)a).selectFields(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD));
            return ret;
        }
    };
    public static final GetBy2<ClassDescriptor, ClassSpace, String> JAVA_CLASS_LOADER = new GetBy2<ClassDescriptor, ClassSpace, String>(){

        public ClassDescriptor getBy(ClassSpace a, String b) {
            try {
                return (ClassDescriptor)WRAP_CLASS.getBy(Class.forName(b));
            }
            catch (ClassNotFoundException e) {
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        }
    };
    protected List<ClassDescriptor> supers;

    protected JavaClassDescriptor() {
    }

    public JavaClassDescriptor(Class cls, List<JavaClassField> fields) {
        this.cls = cls;
        this.fields = fields;
    }

    @Override
    public String getClassName() {
        return this.cls.getName();
    }

    @Override
    public List<? extends ClassFieldDescriptor> getAllField() {
        return this.fields;
    }

    @Override
    public boolean isEnum() {
        return this.cls.isEnum();
    }

    @Override
    public EnumManager getEnumManager() {
        if (null == this.enums) {
            this.enums = null == this.cls.getEnumConstants() ? null : EnumTools.createFromEnumClass((Class)this.cls);
        }
        return this.enums;
    }

    @Override
    public boolean isArray() {
        return this.cls.isArray();
    }

    @Override
    public ClassDescriptor getComponentType() {
        if (null == this.componentType) {
            if (null == this.cls.getComponentType()) {
                return null;
            }
            this.componentType = JavaClassDescriptor.getOfJavaClass(this.cls.getComponentType());
        }
        return this.componentType;
    }

    public static JavaClassDescriptor getOfJavaClass(Class javaClass) {
        return (JavaClassDescriptor)MapTools.getOrCreate(CLS_DESCRIPTORS, (Object)javaClass, WRAP_CLASS);
    }

    @Override
    public int getModifiers() {
        return this.cls.getModifiers();
    }

    @Override
    public List<ClassDescriptor> getSuperTypes() {
        if (null == this.supers) {
            ArrayList<JavaClassDescriptor> add = new ArrayList<JavaClassDescriptor>();
            Class c = this.cls.getSuperclass();
            if (null != c) {
                add.add(JavaClassDescriptor.getOfJavaClass(c));
            }
            for (Class<?> cl : this.cls.getInterfaces()) {
                add.add(JavaClassDescriptor.getOfJavaClass(cl));
            }
            this.supers = Collections.unmodifiableList(add);
        }
        return this.supers;
    }

    @Override
    public boolean isInterface() {
        return this.cls.isInterface();
    }

    public Object get(String key) {
        return ClassDescriptorTools.classPropGet(this, key);
    }

    public String[] keys() {
        return ClassDescriptorTools.classPropKeys();
    }

    @Override
    public ClassSpace getClassSpace() {
        return this.classSpace;
    }

    @Override
    public void setClassSpace(ClassSpace classSpace) {
        this.classSpace = classSpace;
    }
}

