package eu.javaexperience.webgsdb;

import java.util.List;

import eu.javaexperience.interfaces.simple.SimpleGet;
import hu.ddsi.java.database.GenericStoreDatabase;

public abstract class MultiDbGenericModelManagementApi extends GenericModelManagementApi
{
	public MultiDbGenericModelManagementApi()
	{
		super(null, null, null);
		this.srcGdb = new SimpleGet<GenericStoreDatabase>()
		{
			@Override
			public GenericStoreDatabase get()
			{
				return getDatabase();
			}
		};
	}
	
	protected String currentDb;
	
	protected abstract GenericStoreDatabase getDbByName(String db);
	
	public GenericStoreDatabase getDatabase()
	{
		if(null == currentDb)
		{
			throw new RuntimeException("No database selected");
		}
		
		return getDbByName(currentDb);
	}
	
	public abstract List<String> listDatabases();
	
	public void selectDatabase(String db)
	{
		List<String> available = listDatabases();
		if(!available.contains(db))
		{
			throw new RuntimeException("Database `"+db+"` doesn't exists.");
		}
		currentDb = db;
	}
	
	public String getSelectedDatabase()
	{
		return currentDb;
	}
}