package eu.javaexperience.webgsdb;

import java.util.List;
import java.util.Set;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.rpc.RpcSessionTools;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.GenericModelManagementApi.ModelMetadata;
import hu.ddsi.java.database.WrappedClassData;

public abstract class ProxyGenericModelManagementApi implements MultiDbModelManagementApi
{
	protected String sessionKey;
	
	public ProxyGenericModelManagementApi(String sessionKey)
	{
		this.sessionKey = sessionKey;
	}
	
	protected void setRpcSessionDatabaseSelection(String sel)
	{
		RpcSessionTools.ensureGetCurrentRpcSession().getExtraDataMap().put(sessionKey, sel);
	}
	
	protected String getRpcSessionDatabaseSelection()
	{
		return (String) RpcSessionTools.ensureGetCurrentRpcSession().getExtraDataMap().get(sessionKey);
	}
	
	protected abstract ModelManagementApi getDbByName(String db);
	
	protected ModelManagementApi getDatabase()
	{
		String currentDb = getRpcSessionDatabaseSelection();
		if(null == currentDb)
		{
			throw new RuntimeException("No database selected");
		}
		
		return getDbByName(currentDb);
	}
	
	public void selectDatabase(String db)
	{
		List<String> available = listDatabases();
		if(!available.contains(db))
		{
			throw new RuntimeException("Database `"+db+"` doesn't exists.");
		}
		setRpcSessionDatabaseSelection(db);
	}
	
	public String getSelectedDatabase()
	{
		return getRpcSessionDatabaseSelection();
	}

	@Override
	public String[] getManagedModels()
	{
		return getDatabase().getManagedModels();
	}

	@Override
	public ModelMetadata getModelMetadata(String cls) throws Exception
	{
		return getDatabase().getModelMetadata(cls);
	}

	@Override
	public List<ClassDescriptor> getAllAccessableClass()
	{
		return getDatabase().getAllAccessableClass();
	}

	@Override
	public WebDbModel getById(String cls, long id) throws Throwable
	{
		return getDatabase().getById(cls, id);
	}

	@Override
	public List<WebDbModel> select(String cls, DataObject criteria, DataArray selectionExtra) throws Exception
	{
		return getDatabase().select(cls, criteria, selectionExtra);
	}

	@Override
	public ValidationResult<LanguageTranslatableValidationEntry> update(String cls, DataObject obj) throws Exception
	{
		return getDatabase().update(cls, obj);
	}

	@Override
	public ValidationResult<LanguageTranslatableValidationEntry> create(String cls, DataObject obj) throws Exception
	{
		return getDatabase().create(cls, obj);
	}

	@Override
	public ValidationResult<LanguageTranslatableValidationEntry> delete(String cls, long id, DataObject deleteInstruction) throws Exception
	{
		return getDatabase().delete(cls, id, deleteInstruction);
	}
	
	@Override
	public Set<String> getPermissions()
	{
		return getDatabase().getPermissions();
	}

	@Override
	public void fork(String name)
	{
		throw new RuntimeException("Fork not supported");
	}
}
