package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.webgsdb.frontend.modellayer.java.JavaClassDescriptor;

public class ClassSpaceTools
{
	public static void injectJavaTypes(ClassSpace cs, Class... clss)
	{
		for(Class cls :clss)
		{
			cs.registerClass(cls.getName(), JavaClassDescriptor.getOfJavaClass(cls));
		}
	}
	
	public static void injectBasicJavaClasses(ClassSpace cs)
	{
		injectJavaTypes
		(
			cs,
			void.class,
			Void.class,
			boolean.class,
			Boolean.class,
			byte.class,
			Byte.class,
			char.class,
			Character.class,
			short.class,
			Short.class,
			int.class,
			Integer.class,
			long.class,
			Long.class,
			float.class,
			Float.class,
			double.class,
			Double.class,
			
			BigDecimal.class,
			BigInteger.class,
			
			String.class,
			
			Date.class
		);
	}
	
	/**
	 * Creates a ClassSpace with:
	 * 	- array type fetch mechanism (fetches type automatically: "[LMyType;" => MyType[]) 
	 * 	- basic java classes void-Void-boolean-...-int-...-double-...-BigDecimal-...-String-Date
	 * 	- classLoader callback
	 * */
	public static ClassSpace createUsualClassSpace(GetBy2<ClassDescriptor, ClassSpace, String> classLoader)
	{
		ClassSpace ret = createMinimalClassSpace(classLoader);
		injectBasicJavaClasses(ret);
		return ret;
	}
	
	/**
	 * Creates a ClassSpace with:
	 * 	- array type fetch mechanism (fetches type automatically: "[LMyType;" => MyType[]) 
	 * 	- classLoader callback
	 * */
	public static ClassSpace createMinimalClassSpace(GetBy2<ClassDescriptor, ClassSpace, String> classLoader)
	{
		return new ClassSpace(DinamicClassTools.addArrayFetch(classLoader));
	}

	public static ClassSpace createStandaloneClassSpaceWithArraySupport(@MayNull DataArray classDescriptors)
	{
		ClassSpace ret = new ClassSpace(DinamicClassTools.addArrayFetch(null));
		if(null != ret)
		{
			for(int i=0;i<classDescriptors.size();++i)
			{
				ret.parseDescriptor(classDescriptors.getObject(i));
			}
		}
		return ret;
	}
}
