package eu.javaexperience.webgsdb.commons;

import java.util.Map;

import hu.ddsi.java.database.GenericStoreDatabase;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.frontend.modellayer.ModelManager;
import eu.teasite.frontend.api.ApiClient;

public class FrontendFieldEditContext<T extends WebDbModel> implements ExternalDataAttached
{
	public ApiClient api;
	public ModelManager<T> acc;
	public GenericStoreDatabase gdb;
	public T model;
	public @MayNull String idLabelFor;
	public ClassFieldDescriptor field;
	public Object value;
	
	protected Map<String, Object> extraData;
	
	@Override
	public Map<String, Object> getExtraDataMap()
	{
		if(null == extraData)
		{
			extraData = new SmallMap<>();
		}
		return extraData;
	}
	
	@Override
	public FrontendFieldEditContext<T> clone()
	{
		FrontendFieldEditContext ret = new FrontendFieldEditContext<>();
		ret.api = api;
		ret.acc = acc;
		ret.gdb = gdb;
		ret.model = model;
		ret.idLabelFor = idLabelFor;
		ret.field = field;
		ret.value = value;
		ret.extraData = null == extraData?null:new SmallMap(extraData);
		return ret;
	}
}
