package eu.javaexperience.webgsdb.commons;

import java.util.Map;

import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.interfaces.simple.SimpleGetFactory;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.webgsdb.WebDbModel;

public class ModelData implements ExternalDataAttached, ObjectWithProperty
{
	public final Class<? extends WebDbModel> cls;
	
	public ModelData(Class<? extends WebDbModel> cls)
	{
		this.cls = cls;
	}
	
	protected Map<String, Object> extraData;
	
	@Override
	public Map<String, Object> getExtraDataMap()
	{
		if(null == extraData)
		{
			extraData = new SmallMap<>();
		}
		return extraData;
	}

	public Map<String, FieldExtraAttributes> getFieldExtraAttributes()
	{
		return MapTools.ensureMapInMap(getExtraDataMap(), "field_extra_attributes", SimpleGetFactory.getSmallMapFactory());
	}
	
	@Override
	public Object get(String key)
	{
		return PROPS.get(this, key);
	}

	@Override
	public String[] keys()
	{
		return PROPS.keys();
	}
	
	protected static ObjectWithPropertyStorage<ModelData> PROPS = new ObjectWithPropertyStorage<>();
	
	static
	{
		PROPS.addExaminer("cls", (e)-> (StringTools.toStringOrNull(e.cls)));
		PROPS.addExaminer("extra", (e)-> e.extraData);
	}
	
	public static ModelData parse(DataObject obj)
	{
		if(null == obj)
		{
			return null;
		}
		
		ModelData ret = new ModelData(null);
		
		DataObject extra = obj.optObject("extra");
		ret.extraData = extra.asJavaMap();
		
		return ret;
	}
}