/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.SimpleEnumLike;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.webgsdb.commons.FieldExtraAttributes;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicClassDescriptor;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicClassField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClassSpace {
    protected final ConcurrentMap<String, ClassDescriptor> knowClasses = new ConcurrentHashMap<String, ClassDescriptor>();
    protected final GetBy2<ClassDescriptor, ClassSpace, String> classLoader;

    public ClassSpace(GetBy1<ClassDescriptor, String> classLoader) {
        this.classLoader = (c, e) -> (ClassDescriptor)classLoader.getBy(e);
    }

    public ClassSpace(GetBy2<ClassDescriptor, ClassSpace, String> classLoader) {
        this.classLoader = classLoader;
    }

    public ClassDescriptor getClassByName(String name) {
        return (ClassDescriptor)MapTools.getOrCreate(this.knowClasses, (Object)name, e -> (ClassDescriptor)this.classLoader.getBy((Object)this, e));
    }

    public void registerClass(String className, ClassDescriptor classDescriptor) {
        classDescriptor.setClassSpace(this);
        this.knowClasses.putIfAbsent(className, classDescriptor);
    }

    public ClassDescriptor tryGetClass(String key) {
        return (ClassDescriptor)this.knowClasses.get(key);
    }

    public ClassDescriptor parseDescriptor(DataObject obj) {
        String key = obj.getString("fullName");
        AssertArgument.assertNotNull((Object)key, (String)"fullName");
        ClassDescriptor ret = this.tryGetClass(key);
        if (null != ret) {
            this.registerClass(key, ret);
            return ret;
        }
        ret = this.parseDescriptorUnit(obj);
        this.registerClass(key, ret);
        return ret;
    }

    public static GetBy2<ClassDescriptor, ClassSpace, String> createJavaNativeClassLoader(final GetBy1<ClassDescriptor, Class> wrapper) {
        return new GetBy2<ClassDescriptor, ClassSpace, String>(){

            public ClassDescriptor getBy(ClassSpace a, String b) {
                try {
                    return (ClassDescriptor)wrapper.getBy(Class.forName(b));
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            }
        };
    }

    protected ClassDescriptor parseDescriptorUnit(DataObject obj) {
        String key = obj.getString("fullName");
        boolean isArray = obj.getBoolean("isArray");
        boolean isEnum = obj.getBoolean("isEnum");
        if (isArray) {
            ClassDescriptor cd = this.fetchOrParseClass(obj.get("arrayComponent"));
            if (null == cd) {
                return null;
            }
            DinamicClassDescriptor ret = DinamicClassDescriptor.createArrayType(cd);
            this.registerClass(key, ret);
            return ret;
        }
        if (isEnum) {
            DataArray raw = obj.getArray("enums");
            EnumLike[] vals = new EnumLike[raw.size()];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = new SimpleEnumLike(raw.getObject(i).getString("name"));
            }
            DinamicClassDescriptor ret = DinamicClassDescriptor.createEnumeration((String)key, (EnumLike[])vals);
            this.registerClass(key, ret);
            return ret;
        }
        DataArray fields = obj.getArray("fields");
        ClassFieldDescriptor[] dcf = new DinamicClassField[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            DataObject field = fields.getObject(i);
            String dc = field.getString("declaringClass");
            String type = field.getString("type");
            String name = field.getString("name");
            DataArray annotations = field.optArray("annotations");
            dcf[i] = DinamicClassField.create(field.getInt("modifiers"), this, type, name, dc + "." + name, true, null == annotations ? null : FieldExtraAttributes.parse(annotations));
        }
        ArrayList<ClassDescriptor> supers = new ArrayList<ClassDescriptor>();
        Object sc = obj.opt("superClass");
        if (null != sc) {
            supers.add(this.fetchOrParseClass(sc));
        }
        DataArray arr = obj.getArray("superInterfaces");
        for (int i = 0; i < arr.size(); ++i) {
            supers.add(this.fetchOrParseClass(arr.getObject(i)));
        }
        DinamicClassDescriptor ret = DinamicClassDescriptor.createClass(supers, key, obj.getInt("modifiers"), dcf);
        for (ClassFieldDescriptor f : dcf) {
            ((DinamicClassField)f).ownerClass = ret;
        }
        this.registerClass(key, ret);
        return ret;
    }

    public void discoverAll() {
        HashSet<ClassDescriptor> discoveredClasses = new HashSet<ClassDescriptor>();
        for (ClassDescriptor c : this.knowClasses.values()) {
            this.discoverType(discoveredClasses, c);
        }
    }

    protected void discoverType(Set<ClassDescriptor> discoveredClasses, ClassDescriptor c) {
        if (discoveredClasses.contains(c)) {
            return;
        }
        discoveredClasses.add(c);
        c.getSuperTypes();
        c.getComponentType();
        for (ClassFieldDescriptor classFieldDescriptor : c.getAllField()) {
            this.discoverType(discoveredClasses, classFieldDescriptor.getType());
        }
    }

    protected ClassDescriptor fetchOrParseClass(Object o) {
        if (o instanceof String) {
            return this.getClassByName((String)o);
        }
        return this.parseDescriptor((DataObject)o);
    }

    public Set<String> listClasses() {
        return this.knowClasses.keySet();
    }

    public List<ClassDescriptor> getLoadedClasses() {
        return (List)CollectionTools.inlineAdd(new ArrayList(), this.knowClasses.values());
    }
}

