/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.DataLike;
import eu.javaexperience.datareprez.convertFrom.ModifiableObject;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.patterns.creational.builder.PublisherBuilder;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.teasite.frontend.table.GeneratedResultTable;
import eu.javaexperience.teasite.frontend.table.ResultTableGenerator;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.WebGsdbTools;
import eu.javaexperience.webgsdb.commons.FieldExtraAttributes;
import eu.javaexperience.webgsdb.commons.FrontendFieldEditContext;
import eu.javaexperience.webgsdb.frontend.ModelTableGeneratorTools;
import eu.javaexperience.webgsdb.frontend.modellayer.ModelManager;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.TeaVmTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.StyleDecoratorSource;
import eu.jvx.js.lib.style.StyleTools;
import eu.jvx.js.lib.style.TbsStyle;
import eu.jvx.js.lib.ui.FrontendTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainerTools;
import eu.jvx.js.lib.ui.component.table.TableCell;
import eu.jvx.js.lib.ui.component.table.TableRow;
import eu.jvx.js.tbs.TbsGlyph;
import eu.jvx.js.tbs.ui.TbsLayoutTools;
import eu.jvx.js.tbs.ui.TbsTools;
import eu.teasite.frontend.api.ApiClient;
import hu.ddsi.java.database.F;
import hu.ddsi.java.database.GenericStorage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;

public class BasicModelManagerUnit<B extends WebDbModel, D extends B>
implements ImpersonalisedHtml {
    public ClassDescriptor cls;
    public ModelManager<B> acc;
    public ApiClient api;
    protected Set<String> perms = null;
    public HTMLElement container = null;
    public HTMLElement filterBox = new H("div").getHtml();
    public HTMLElement resultTableBox = new H("div").getHtml();
    protected HTMLElement addNewModelButton = new H("span").attrs(new String[]{"class", "jvx-create-new-model"}).style(new StyleDecoratorSource[]{TbsGlyph.PLUS_SIGN, TbsStyle.BTN_SUCCESS}).onClick(e -> this.popupAddNewModel()).getHtml();
    protected static GetBy1 CUSTOM_FIELD_NAME;
    public GetBy1<ResultTableGenerator<D>, ResultTableGenerator<D>> customizeResultTable = new GetBy1<ResultTableGenerator<D>, ResultTableGenerator<D>>(){

        public ResultTableGenerator<D> getBy(ResultTableGenerator<D> a) {
            a.getFields = new SimplePublish1<List<ResultTableGenerator.TableField<D>>>(){

                public void publish(List<ResultTableGenerator.TableField<D>> a) {
                    ResultTableGenerator.TableField f = new ResultTableGenerator.TableField();
                    f.renderLabel = new GetBy1<HTMLElement, ResultTableGenerator.TableField<D>>(){

                        public HTMLElement getBy(ResultTableGenerator.TableField<D> a) {
                            if (BasicModelManagerUnit.this.hasPermission("create")) {
                                return BasicModelManagerUnit.this.addNewModelButton;
                            }
                            return null;
                        }
                    };
                    f.renderField = new GetBy3<HTMLElement, ResultTableGenerator.TableField<D>, TableRow, D>(){

                        public HTMLElement getBy(ResultTableGenerator.TableField<D> a, TableRow b, D c) {
                            return BasicModelManagerUnit.this.generateOptionsButtonFor(BasicModelManagerUnit.this.getPermissions(), c, b);
                        }
                    };
                    a.add(f);
                    f = new ResultTableGenerator.TableField();
                    f.renderLabel = new GetBy1<HTMLElement, ResultTableGenerator.TableField<D>>(){

                        public HTMLElement getBy(ResultTableGenerator.TableField<D> a) {
                            return new H("div").attrs(new String[]{"#text", "id"}).getHtml();
                        }
                    };
                    f.renderField = new GetBy3<HTMLElement, ResultTableGenerator.TableField<D>, TableRow, D>(){

                        public HTMLElement getBy(ResultTableGenerator.TableField<D> a, TableRow b, D c) {
                            String id = String.valueOf(((WebDbModel)c).get("do"));
                            return new H("div").attrs(new String[]{"#text", id, "data-name", "do", "data-value", id}).getHtml();
                        }
                    };
                    a.add(f);
                    List<? extends ClassFieldDescriptor> fds = BasicModelManagerUnit.this.cls.getAllField();
                    for (ClassFieldDescriptor classFieldDescriptor : fds) {
                        FieldExtraAttributes mfd;
                        if (!classFieldDescriptor.isUserAccessible() || null != (mfd = classFieldDescriptor.getExtraAttributes()) && !mfd.userMaySee) continue;
                        ResultTableGenerator.TableField add = new ResultTableGenerator.TableField();
                        add.fieldName = classFieldDescriptor.getName();
                        add.getExtraDataMap().put("fd", classFieldDescriptor);
                        add.renderLabel = CUSTOM_FIELD_NAME;
                        add.renderField = ModelTableGeneratorTools.DEFAULT_MODEL_FIELD_RENDERER;
                        a.add(add);
                    }
                }
            };
            return a;
        }
    };
    protected GeneratedResultTable<D> lastResultTable = null;
    protected SimplePublish1<List<D>> reRenderTable = new SimplePublish1<List<D>>(){

        public void publish(List<D> a) {
            try {
                BasicModelManagerUnit.this.lastResultTable = ModelTableGeneratorTools.generateResultTable(BasicModelManagerUnit.this.cls, a, BasicModelManagerUnit.this.customizeResultTable);
                BasicModelManagerUnit.this.resultTableBox.clear();
                BasicModelManagerUnit.this.resultTableBox.appendChild((Node)BasicModelManagerUnit.this.lastResultTable.html);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    };

    public BasicModelManagerUnit(ClassDescriptor cls, ModelManager<B> acc, ApiClient api) {
        this.cls = cls;
        this.acc = acc;
        this.api = api;
    }

    public boolean hasPermission(String perm) {
        return this.getPermissions().contains(perm);
    }

    public Set<String> getPermissions() {
        if (null == this.perms) {
            this.perms = this.acc.getPermissions();
        }
        return this.perms;
    }

    protected D createNewModel() {
        try {
            return (D)this.acc.createModel(this.cls);
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    protected void popupAddNewModel() {
        this.popupWithDataAndTrigger("jvx-new-model-form", null, this.createNewModel(), "Create new " + this.cls.getClassName(), new SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>>(){

            public void publish(DataObject data, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>> b) {
                ValidationResult<LanguageTranslatableValidationEntry> ret = BasicModelManagerUnit.this.acc.create(BasicModelManagerUnit.this.cls, data);
                b.publish(ret);
            }
        });
    }

    protected void popupConfirmDelete(final D model, final TableRow row) {
        final H content = H.H((String)"div");
        content.addChilds(new H[]{new H("div").attrs(new String[]{"#text", "Do you really want to delete this: " + model.toString()})});
        H header = H.H((String)"h4");
        header.attrs(new String[]{"#text", "Confirm deletion"});
        H footer = H.H((String)"div");
        footer.addChilds(new HTMLElement[]{TbsTools.createModalCloseButton((String)"Cancel")});
        footer.addChilds(new H[]{H.H((String)"button").attrs(new String[]{"class", "op_delete", "#text", "Delete"}).style(new StyleDecoratorSource[]{TbsStyle.BTN_DANGER})});
        VanillaTools.bindListenerToArea((HTMLElement)footer.getHtml(), (String)"click", (String)".op_delete", (EventListener)FrontendTools.wrapProcessEventWithThread((EventListener)new EventListener<Event>(){

            public void handleEvent(Event a) {
                ValidationResult<LanguageTranslatableValidationEntry> ret = BasicModelManagerUnit.this.acc.delete(BasicModelManagerUnit.this.cls, (Long)CastTo.Long.cast(model.get("do")), null);
                if (ret.valid) {
                    TbsTools.closeModal((HTMLElement)content.getHtml());
                    VanillaTools.remove((Element)row.getHtml());
                } else {
                    TbsTools.modalMessage((String)"Deletion failed", (String)FrontendTools.renderMessages((Collection)ret.reportEntries));
                }
            }
        }));
        TbsTools.modal((HTMLElement)header.getHtml(), (HTMLElement)content.getHtml(), (HTMLElement)footer.getHtml());
    }

    protected void popupEdit(final D model, final TableRow row) {
        this.popupWithDataAndTrigger("jvx-edit-model-form", (Map<String, String>)new OneShotMap((Object)"do", (Object)((WebDbModel)model).get("do").toString()), model, "Modify " + this.cls.getClassName(), new SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>>(){

            public void publish(DataObject data, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>> b) {
                ValidationResult<LanguageTranslatableValidationEntry> a = BasicModelManagerUnit.this.acc.update(BasicModelManagerUnit.this.cls, data);
                if (a.valid) {
                    DataReprezTools.copyInto((ModifiableObject)model, (ObjectWithProperty)data);
                    model.set("lastModify", System.currentTimeMillis());
                    BasicModelManagerUnit.this.updateRowBy(row, (DataLike)model);
                }
                b.publish(a);
            }
        });
    }

    public void updateRowBy(TableRow row, DataLike obj) {
        for (ResultTableGenerator.TableField k : this.lastResultTable.fields) {
            TableCell cell = row.getCellByName(k.fieldName);
            HTMLElement h = cell.getHtml();
            h.clear();
            HTMLElement el = (HTMLElement)k.renderField.getBy((Object)k, (Object)row, (Object)((WebDbModel)obj));
            if (null == el) continue;
            h.appendChild((Node)el);
        }
    }

    protected void popupWithDataAndTrigger(String extraCss, Map<String, String> extraAttributes, D model, String title, final SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>> onSave) {
        final H content = H.H((String)"div");
        if (null != extraCss) {
            content.attrs(new String[]{"class", extraCss});
        }
        PublisherBuilder builder = TbsLayoutTools.buildForm();
        builder.initialize(null);
        if (null != extraAttributes) {
            for (Map.Entry<String, String> kv : extraAttributes.entrySet()) {
                builder.publish((Object)new TbsLayoutTools.SimpleFormRow(null, null, H.H((String)"input").attrs(new String[]{"type", "hidden", "name", kv.getKey(), "value", kv.getValue()}).getHtml()));
            }
        }
        FrontendFieldEditContext ctx = new FrontendFieldEditContext();
        ctx.acc = this.acc;
        ctx.api = this.api;
        ctx.gdb = GenericStorage.getOwnerDatabase(model);
        ctx.model = model;
        WebGsdbTools.generateModelEditor((SimplePublish1<TbsLayoutTools.SimpleFormRow>)builder, this.cls, model, ctx);
        content.addChilds(new HTMLElement[]{(HTMLElement)builder.getResult()});
        H header = H.H((String)"h4");
        header.attrs(new String[]{"#text", title});
        H footer = H.H((String)"div");
        footer.addChilds(new HTMLElement[]{TbsTools.createModalCloseButton((String)"Close")});
        footer.addChilds(new H[]{H.H((String)"button").attrs(new String[]{"class", "op_save", "#text", "Save"}).style(new StyleDecoratorSource[]{TbsStyle.BTN_SUCCESS})});
        VanillaTools.bindListenerToArea((HTMLElement)footer.getHtml(), (String)"click", (String)".op_save", (EventListener)FrontendTools.wrapProcessEventWithThread((EventListener)new EventListener<Event>(){

            public void handleEvent(Event a) {
                DataObject data = FrontendTools.serializeInputsInArea((HTMLElement)content.getHtml());
                onSave.publish((Object)data, (Object)new SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>(){

                    public void publish(ValidationResult<LanguageTranslatableValidationEntry> a) {
                        if (a.valid) {
                            TbsTools.closeModal((HTMLElement)content.getHtml());
                        } else {
                            Window.alert((String)"error");
                        }
                    }
                });
            }
        }));
        TbsTools.modal((HTMLElement)header.getHtml(), (HTMLElement)content.getHtml(), (HTMLElement)footer.getHtml());
    }

    protected HTMLElement generateOptionsButtonFor(Set<String> permissions, D model, TableRow row) {
        return new H("div").addChilds(new H[]{!permissions.contains("update") ? null : new H("span").style(new StyleDecoratorSource[]{TbsGlyph.PENCIL, TbsStyle.BTN_DEFAULT, StyleTools.StyleAlaCarte.FS_1, StyleTools.StyleAlaCarte.MARGIN_1}).onClick(e -> this.popupEdit(model, row)), !permissions.contains("delete") ? null : new H("span").style(new StyleDecoratorSource[]{TbsGlyph.TRASH, TbsStyle.BTN_DEFAULT, StyleTools.StyleAlaCarte.FS_1, StyleTools.StyleAlaCarte.MARGIN_1}).onClick(e -> this.popupConfirmDelete(model, row))}).getHtml();
    }

    public void refresh() {
        this.loadAll();
    }

    @Deprecated
    public void loadAll() {
        FrontendTools.runOnThread((SimpleCall)new SimpleCall(){

            public void call() {
                BasicModelManagerUnit.this.init();
                try {
                    BasicModelManagerUnit.this.reRenderTable.publish(BasicModelManagerUnit.this.acc.select(BasicModelManagerUnit.this.cls, F.gt.is("do", (Object)-1)));
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
            }
        });
    }

    public void reset() {
        this.container = null;
    }

    public void init() {
        if (null != this.container) {
            return;
        }
        this.filterBox = new H("div").addChilds(new HTMLElement[]{new H("button").style(new StyleDecoratorSource[]{TbsGlyph.REFRESH, TbsStyle.BTN_DEFAULT, StyleTools.StyleAlaCarte.FS_1, StyleTools.StyleAlaCarte.MARGIN_1}).onClick(e -> this.refresh()).getHtml()}).getHtml();
        this.container = null;
        this.container = new H("div").addChilds(new HTMLElement[]{this.filterBox, this.resultTableBox}).getHtml();
    }

    public Object getImpersonator() {
        return this;
    }

    public Element getHtml() {
        if (null == this.container) {
            this.init();
        }
        return this.container;
    }

    static {
        if (!TeaVmTools.IS_FRONTEND) {
            HtmlDataContainer c = HtmlDataContainerTools.browserDatetimeLocal(null);
            c.setData((Object)"");
        }
        CUSTOM_FIELD_NAME = new GetBy1<HTMLElement, ResultTableGenerator.TableField>(){

            public HTMLElement getBy(ResultTableGenerator.TableField a) {
                ClassFieldDescriptor fd = (ClassFieldDescriptor)a.getExtraDataMap().get("fd");
                String text = "-";
                if (null != fd) {
                    text = fd.getTranslationSymbol();
                    text = WebGsdbTools.translate(text);
                }
                return new H("span").attrs(new String[]{"#text", text}).getHtml();
            }
        };
    }
}

