package eu.javaexperience.webgsdb.frontend;

import static eu.jvx.js.lib.bindings.H.H;
import hu.ddsi.java.database.F;
import hu.ddsi.java.database.GenericStorage;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.DataLike;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.patterns.creational.builder.PublisherBuilder;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.teasite.frontend.table.GeneratedResultTable;
import eu.javaexperience.teasite.frontend.table.ResultTableGenerator;
import eu.javaexperience.teasite.frontend.table.ResultTableGenerator.TableField;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.WebGsdbTools;
import eu.javaexperience.webgsdb.commons.FieldExtraAttributes;
import eu.javaexperience.webgsdb.commons.FrontendFieldEditContext;
import eu.javaexperience.webgsdb.frontend.modellayer.ModelManager;
import eu.javaexperience.webgsdb.test.WebGsdbFrontendTestTools;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.TeaVmTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.StyleTools.StyleAlaCarte;
import eu.jvx.js.lib.style.TbsStyle;
import eu.jvx.js.lib.ui.FrontendTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainerTools;
import eu.jvx.js.lib.ui.component.table.TableCell;
import eu.jvx.js.lib.ui.component.table.TableRow;
import eu.jvx.js.tbs.TbsGlyph;
import eu.jvx.js.tbs.ui.TbsLayoutTools;
import eu.jvx.js.tbs.ui.TbsTools;
import eu.jvx.js.tbs.ui.TbsLayoutTools.SimpleFormRow;
import eu.teasite.frontend.api.ApiClient;

public class BasicModelManagerUnit<B extends WebDbModel, D extends B> implements ImpersonalisedHtml
{
	public ClassDescriptor cls;
	public ModelManager<B> acc;
	public ApiClient api;
	
	public BasicModelManagerUnit(ClassDescriptor cls, ModelManager<B> acc, ApiClient api)
	{
		this.cls = cls;
		this.acc = acc;
		this.api = api;
	}
	
	public boolean hasPermission(String perm)
	{
		return getPermissions().contains(perm);
	}
	
	protected Set<String> perms = null;
	
	public Set<String> getPermissions()
	{
		if(null == perms)
		{
			perms = acc.getPermissions();
		}
		return perms;
	}

	public HTMLElement container = null;
	
	public HTMLElement filterBox = new H("div").getHtml();
	public HTMLElement resultTableBox = new H("div").getHtml();
	
	protected HTMLElement addNewModelButton = new H("span").attrs("class", WebGsdbFrontendTestTools.CSS_BTN_NEW_MODEL).style
	(
		TbsGlyph.PLUS_SIGN,
		TbsStyle.BTN_SUCCESS
	)
	.onClick((e)->popupAddNewModel()).getHtml();
	
	protected D createNewModel()
	{
		try
		{
			return acc.createModel(cls);
		}
		catch(Exception e)
		{
			Mirror.propagateAnyway(e);
			return null;
		}
	}
	
	protected void popupAddNewModel()
	{
		popupWithDataAndTrigger
		(
			WebGsdbFrontendTestTools.CSS_CREATE_NEW_MODEL_FORM,
			null,
			createNewModel(),
			"Create new "+cls.getClassName(),
			new SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>>()
			{
				@Override
				public void publish(DataObject data, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>> b)
				{
					ValidationResult<LanguageTranslatableValidationEntry> ret = acc.create(cls, data);
					b.publish(ret);
				}
			}
		);
	}
	
	protected void popupConfirmDelete(D model, TableRow row)
	{
		H content = H("div"); 
		
		content.addChilds(new H("div").attrs("#text", "Do you really want to delete this: "+model.toString()));
		
		H header = H("h4");
		header.attrs("#text", "Confirm deletion");
		
		H footer = H("div");
		
		footer.addChilds(TbsTools.createModalCloseButton("Cancel"));
		footer.addChilds(H("button").attrs("class", "op_delete", "#text", "Delete").style(TbsStyle.BTN_DANGER));
		
		VanillaTools.bindListenerToArea
		(
			footer.getHtml(),
			"click",
			".op_delete",
			FrontendTools.wrapProcessEventWithThread
			(
				new EventListener<Event>()
				{
					@Override
					public void handleEvent(Event a)
					{
						ValidationResult<LanguageTranslatableValidationEntry> ret = acc.delete
						(
							cls,
							(Long) CastTo.Long.cast(model.get("do")),
							null
						);
						
						if(ret.valid)
						{
							TbsTools.closeModal(content.getHtml());
							VanillaTools.remove(row.getHtml());
						}
						else
						{
							TbsTools.modalMessage("Deletion failed", FrontendTools.renderMessages(ret.reportEntries));
						}
					}
				}
			)
		);
		
		TbsTools.modal
		(
			header.getHtml(),
			content.getHtml(),
			footer.getHtml()
		);
	}
	
	protected void popupEdit(D model, TableRow row)
	{
		popupWithDataAndTrigger
		(
			WebGsdbFrontendTestTools.CSS_MODEL_EDIT_FORM,
			new OneShotMap<String, String>("do", model.get("do").toString()),
			model,
			//(GetBy2<String, D, String>) BudgetFrontendTools.DEFAULT_MODEL_FIELD_FORMATTER,
			"Modify "+cls.getClassName(),
			new SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>>()
			{
				@Override
				public void publish(DataObject data, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>> b)
				{
					ValidationResult<LanguageTranslatableValidationEntry> a = acc.update(cls, data);
					if(a.valid)
					{
						DataReprezTools.copyInto(model, data);
						model.set("lastModify", System.currentTimeMillis());
						updateRowBy(row, model);
					}
					
					b.publish(a);
				}
			}
		);
	}
	
	static
	{
		//urchin: never runs on frontend but the TeaVm optimizer don't know about that, and so it keep the related fields/methods
		if(!TeaVmTools.IS_FRONTEND)
		{
			HtmlDataContainer<String> c = HtmlDataContainerTools.browserDatetimeLocal(null);
			c.setData("");
		}
	}
	
	public void updateRowBy(TableRow row, DataLike obj)
	{
		for(TableField<D> k:lastResultTable.fields)
		{
			TableCell cell = row.getCellByName(k.fieldName);
			HTMLElement h = cell.getHtml();
			h.clear();
			HTMLElement el = k.renderField.getBy(k, row, (D) obj);
			if(null != el)
			{
				h.appendChild(el);
			}
		}
	}
	
	/**
	 * 
	 * TODO extra fileds (id),
	 * TODO custom value setting.
	 * TODO add validation error 
	 * 
	 * 
	 * TODO externalize to customizable class
	 */
	protected void popupWithDataAndTrigger
	(
		String extraCss,
		Map<String, String> extraAttributes,
		D model,
		//GetBy2<String, D, String> getModelField,
		String title,
		SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>> onSave
	)
	{
		H content = H("div");
		if(null != extraCss)
		{
			content.attrs("class", extraCss);
		}
		
		PublisherBuilder<SimpleFormRow, HTMLElement, Void> builder = TbsLayoutTools.buildForm();
		builder.initialize(null);
		
		if(null != extraAttributes)
		{
			for(Entry<String, String> kv:extraAttributes.entrySet())
			{
				builder.publish(new SimpleFormRow(null, null, H("input").attrs("type", "hidden", "name", kv.getKey(), "value", kv.getValue()).getHtml()));
			}
		}
		
		FrontendFieldEditContext ctx = new FrontendFieldEditContext<>();
		ctx.acc = acc;
		ctx.api = api;
		ctx.gdb = GenericStorage.getOwnerDatabase(model);
		ctx.model = model;
		
		WebGsdbTools.generateModelEditor(builder, cls, model, ctx);
		
		content.addChilds(builder.getResult());
		
		H header = H("h4");
		
		header.attrs("#text", title);
		
		H footer = H("div");
		
		footer.addChilds(TbsTools.createModalCloseButton("Close"));
		footer.addChilds(H("button").attrs("class", "op_save", "#text", "Save").style(TbsStyle.BTN_SUCCESS));
		
		VanillaTools.bindListenerToArea
		(
			footer.getHtml(),
			"click",
			".op_save",
			FrontendTools.wrapProcessEventWithThread
			(
				new EventListener<Event>()
				{
					@Override
					public void handleEvent(Event a)
					{
						DataObject data = FrontendTools.serializeInputsInArea(content.getHtml());
						onSave.publish(data, new SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>()
						{
							@Override
							public void publish(ValidationResult<LanguageTranslatableValidationEntry> a)
							{
								if(a.valid)
								{
									TbsTools.closeModal(content.getHtml());
								}
								else
								{
									Window.alert("error");
									//TODO show valdation entries
								}
							}
						});
					}
				}
			)
		);
		
		TbsTools.modal
		(
			header.getHtml(),
			content.getHtml(),
			footer.getHtml()
		);
	}
	
	protected HTMLElement generateOptionsButtonFor(Set<String> permissions, D model, TableRow row)
	{
		return new H("div").addChilds
		(
			!permissions.contains("update")?null:new H("span").style(TbsGlyph.PENCIL, TbsStyle.BTN_DEFAULT, StyleAlaCarte.FS_1, StyleAlaCarte.MARGIN_1).onClick((e)->popupEdit(model, row)),
			!permissions.contains("delete")?null:new H("span").style(TbsGlyph.TRASH, TbsStyle.BTN_DEFAULT, StyleAlaCarte.FS_1, StyleAlaCarte.MARGIN_1).onClick((e)->popupConfirmDelete(model, row))
		).getHtml();
	}
	
	protected static GetBy1 CUSTOM_FIELD_NAME = new GetBy1<HTMLElement, TableField>()
	{
		@Override
		public HTMLElement getBy(TableField a)
		{
			ClassFieldDescriptor fd = (ClassFieldDescriptor) a.getExtraDataMap().get("fd");
			String text = "-";
			if(null != fd)
			{
				text = fd.getTranslationSymbol();
				text = WebGsdbTools.translate(text);
			}
			
			return new H("span").attrs("#text", text).getHtml();
		}
	};
	
	public GetBy1<ResultTableGenerator<D>, ResultTableGenerator<D>> customizeResultTable = new GetBy1<ResultTableGenerator<D>, ResultTableGenerator<D>>()
	{
		@Override
		public ResultTableGenerator<D> getBy(ResultTableGenerator<D> a)
		{
			a.getFields = new SimplePublish1<List<TableField<D>>>()
			{
				@Override
				public void publish(List<TableField<D>> a)
				{
					{
						TableField<D> f = new TableField<D>();
						
						f.renderLabel = new GetBy1<HTMLElement, TableField<D>>()
						{
							@Override
							public HTMLElement getBy(TableField<D> a)
							{
								if(hasPermission("create"))
								{
									return addNewModelButton;
								}
								return null;
							}
						};
						
						f.renderField = new GetBy3<HTMLElement, ResultTableGenerator.TableField<D>, TableRow, D>()
						{
							@Override
							public HTMLElement getBy(TableField<D> a, TableRow b, D c)
							{
								return generateOptionsButtonFor(getPermissions(), c, b);
							}
						};
						
						a.add(f);
					}
					
					{
						TableField<D> f = new TableField<D>();
						
						f.renderLabel = new GetBy1<HTMLElement, TableField<D>>()
						{
							@Override
							public HTMLElement getBy(TableField<D> a)
							{
								return new H("div").attrs("#text", "id").getHtml();
							}
						};
						
						f.renderField = new GetBy3<HTMLElement, ResultTableGenerator.TableField<D>, TableRow, D>()
						{
							@Override
							public HTMLElement getBy(TableField<D> a, TableRow b, D c)
							{
								String id = String.valueOf(c.get("do"));
								return new H("div").attrs("#text", id, "data-name", "do", "data-value", id).getHtml();
							}
						};
						
						a.add(f);
					}
					
					List<? extends ClassFieldDescriptor> fds = cls.getAllField();
					
					for(ClassFieldDescriptor fd:fds)
					{
						if(!fd.isUserAccessible())
						{
							continue;
						}
						
						FieldExtraAttributes mfd = fd.getExtraAttributes();
						if(null == mfd || mfd.userMaySee)
						{
							TableField<D> add = new TableField<D>();
							add.fieldName = fd.getName();
							add.getExtraDataMap().put("fd", fd);
							add.renderLabel = CUSTOM_FIELD_NAME;
							add.renderField = (GetBy3) ModelTableGeneratorTools.DEFAULT_MODEL_FIELD_RENDERER;
							a.add(add);
						}
					}
				}
			};
			
			return a;
		}
	};
	
	protected GeneratedResultTable<D> lastResultTable = null;
	
	protected SimplePublish1<List<D>> reRenderTable = new SimplePublish1<List<D>>()
	{
		@Override
		public void publish(List<D> a)
		{
			try
			{
				lastResultTable = ModelTableGeneratorTools.generateResultTable(cls, a, customizeResultTable);
				resultTableBox.clear();
				resultTableBox.appendChild(lastResultTable.html);
			}
			catch (Throwable e)
			{
				e.printStackTrace();
			}
		}
	};
	
	public void refresh()
	{
		//TODO post filter again
		loadAll();
	}
	
	@Deprecated
	public void loadAll()
	{
		FrontendTools.runOnThread(new SimpleCall()
		{
			@Override
			public void call()
			{
				init();
				try
				{
					reRenderTable.publish(acc.select(cls, F.gt.is("do", -1)));
				}
				catch (Exception e)
				{
					Mirror.propagateAnyway(e);
				}
			}
		});
	}
	
	public void reset()
	{
		container = null;
	}
	
	public void init()
	{
		if(null != container)
		{
			return;
		}
		//TODO filter
		filterBox = new H("div").addChilds
		(
			new H("button").style(TbsGlyph.REFRESH, TbsStyle.BTN_DEFAULT, StyleAlaCarte.FS_1, StyleAlaCarte.MARGIN_1).onClick((e)->refresh()).getHtml()
		).getHtml();
		
		container = null;
		container = new H("div").addChilds
		(
			filterBox,
			resultTableBox
		).getHtml();
	}
	
	@Override
	public Object getImpersonator()
	{
		return this;
	}

	@Override
	public Element getHtml()
	{
		if(null == container)
		{
			init();
		}
		return container;
	}
}
