/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpace;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicClassTools;
import eu.javaexperience.webgsdb.frontend.modellayer.java.JavaClassDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class ClassSpaceTools {
    public static void injectJavaTypes(ClassSpace cs, Class ... clss) {
        for (Class cls : clss) {
            cs.registerClass(cls.getName(), JavaClassDescriptor.getOfJavaClass(cls));
        }
    }

    public static void injectBasicJavaClasses(ClassSpace cs) {
        ClassSpaceTools.injectJavaTypes(cs, Void.TYPE, Void.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class, String.class, Date.class);
    }

    public static ClassSpace createUsualClassSpace(GetBy2<ClassDescriptor, ClassSpace, String> classLoader) {
        ClassSpace ret = ClassSpaceTools.createMinimalClassSpace(classLoader);
        ClassSpaceTools.injectBasicJavaClasses(ret);
        return ret;
    }

    public static ClassSpace createMinimalClassSpace(GetBy2<ClassDescriptor, ClassSpace, String> classLoader) {
        return new ClassSpace(DinamicClassTools.addArrayFetch(classLoader));
    }

    public static ClassSpace createStandaloneClassSpaceWithArraySupport(@MayNull DataArray classDescriptors) {
        ClassSpace ret = new ClassSpace(DinamicClassTools.addArrayFetch(null));
        if (null != ret) {
            for (int i = 0; i < classDescriptors.size(); ++i) {
                ret.parseDescriptor(classDescriptors.getObject(i));
            }
        }
        return ret;
    }
}

