/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.ConcurrentMapTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.generic.annotations.Ignore;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.ModelManagementApi;
import eu.javaexperience.webgsdb.RemoteGsdbTools;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.annotations.FrontendStructureType;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpace;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpaceTools;
import eu.javaexperience.webgsdb.frontend.modellayer.java.JavaClassDescriptor;
import eu.javaexperience.webgsdb.frontend.modellayer.java.JavaClassField;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStorageMappingData;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreQueryBuilder;
import hu.ddsi.java.database.GsdbExtraCaluse;
import hu.ddsi.java.database.WrappedClassData;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GenericModelManagementApi
implements ModelManagementApi {
    protected SimpleGet<GenericStoreDatabase> srcGdb;
    protected Map<String, Class<? extends WebDbModel>> fetch = new HashMap<String, Class<? extends WebDbModel>>();
    protected List<String> managedClasses = new ArrayList<String>();
    protected SimpleGet<Set<String>> permissions;
    protected List<ClassDescriptor> accessibleClasses;
    protected ClassSpace classSpace = ClassSpaceTools.createUsualClassSpace(ClassSpace.createJavaNativeClassLoader(new GetBy1<ClassDescriptor, Class>(){

        public ClassDescriptor getBy(Class cls) {
            if (cls == null) {
                return null;
            }
            ArrayList<Field> fs = new ArrayList<Field>();
            for (Field f : Mirror.getClassData((Class)cls).selectFields(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD)) {
                if (!Modifier.isPublic(f.getModifiers())) continue;
                fs.add(f);
            }
            return new JavaClassDescriptor(cls, JavaClassField.wrapAll(fs.toArray(Mirror.emptyFieldArray)));
        }
    }));

    public GenericModelManagementApi(SimpleGet<GenericStoreDatabase> srcGdb, SimpleGet<Set<String>> permissions, Class<? extends WebDbModel> ... classes) {
        this.srcGdb = srcGdb;
        this.permissions = permissions;
        for (Class<? extends WebDbModel> c : classes) {
            this.fetch.put(c.getSimpleName(), c);
            this.fetch.put(c.getName(), c);
            this.managedClasses.add(c.getName());
        }
    }

    public GenericStoreDatabase getDatabase() {
        return (GenericStoreDatabase)this.srcGdb.get();
    }

    @Override
    public String[] getManagedModels() {
        return this.managedClasses.toArray(Mirror.emptyStringArray);
    }

    @Override
    @Deprecated
    public ModelMetadata getModelMetadata(String cls) throws Exception {
        return ModelMetadata.collect(this.fetchClass(cls));
    }

    protected void discoverAndWrapShallow(Map<Class, ClassDescriptor> map, Class c) {
        if (null == c) {
            return;
        }
        if (!map.containsKey(c)) {
            map.put(c, this.classSpace.getClassByName(c.getName()));
            this.discoverAndWrapShallow(map, c.getComponentType());
            this.discoverAndWrapShallow(map, c.getSuperclass());
            for (Class<?> clazz : c.getInterfaces()) {
                this.discoverAndWrapShallow(map, clazz);
            }
            for (AnnotatedElement annotatedElement : Mirror.getClassData((Class)c).select(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD)) {
                if (!Modifier.isPublic(((Field)annotatedElement).getModifiers())) continue;
                this.discoverAndWrapShallow(map, ((Field)annotatedElement).getType());
                FrontendStructureType ann = ((Field)annotatedElement).getAnnotation(FrontendStructureType.class);
                if (null == ann) continue;
                this.discoverAndWrapShallow(map, ann.structClass());
            }
        }
    }

    @Override
    public List<ClassDescriptor> getAllAccessableClass() {
        if (null == this.accessibleClasses) {
            HashMap<Class, ClassDescriptor> map = new HashMap<Class, ClassDescriptor>();
            for (Class<? extends WebDbModel> c : this.fetch.values()) {
                this.discoverAndWrapShallow(map, c);
            }
            this.accessibleClasses = Collections.unmodifiableList((List)CollectionTools.inlineAdd(new ArrayList(), map.values()));
        }
        return this.accessibleClasses;
    }

    protected Class<? extends WebDbModel> fetchClass(String name) {
        Class<? extends WebDbModel> ret = this.fetch.get(name);
        if (null == ret) {
            throw new RuntimeException("Unknown model class: " + name);
        }
        return ret;
    }

    protected long fetchId(DataObject obj) {
        Object o = obj.get("do");
        if (null == (o = CastTo.Long.cast(o))) {
            throw new RuntimeException("id not specified.");
        }
        return (Long)o;
    }

    @Override
    public WebDbModel getById(String cls, long id) throws Throwable {
        return (WebDbModel)GenericStorage.getObjectByIDDescendantOf((long)id, this.fetchClass(cls), (GenericStoreDatabase)((GenericStoreDatabase)this.srcGdb.get()));
    }

    @Override
    public ValidationResult<LanguageTranslatableValidationEntry> update(String cls, DataObject obj) throws Exception {
        return RemoteGsdbTools.tryUpdateFrom((GenericStoreDatabase)this.srcGdb.get(), this.fetchClass(cls), this.fetchId(obj), obj, "err_requested_element_not_exitst");
    }

    @Override
    public ValidationResult<LanguageTranslatableValidationEntry> create(String cls, DataObject obj) throws Exception {
        return RemoteGsdbTools.createNewFrom((GenericStoreDatabase)this.srcGdb.get(), this.fetchClass(cls), obj);
    }

    @Override
    public ValidationResult<LanguageTranslatableValidationEntry> delete(String cls, long id, DataObject deleteInstruction) throws Exception {
        return RemoteGsdbTools.delete((GenericStoreDatabase)this.srcGdb.get(), this.fetchClass(cls), id, deleteInstruction);
    }

    @Override
    public List<WebDbModel> select(String cls, DataObject criteria, DataArray selectionExtra) throws Exception {
        GenericStoreQueryBuilder.LogicalGroup lg = RemoteGsdbTools.parseCriteria(criteria);
        ArrayList<WebDbModel> ret = new ArrayList<WebDbModel>();
        GenericStorage.getAllObjectsByQuery(this.fetchClass(cls), (GenericStoreQueryBuilder.LogicalGroup)lg, ret, (GenericStoreDatabase)((GenericStoreDatabase)this.srcGdb.get()), (GsdbExtraCaluse[])new GsdbExtraCaluse[0]);
        return ret;
    }

    @Override
    public Set<String> getPermissions() {
        return (Set)this.permissions.get();
    }

    @Override
    public void fork(String name) {
        throw new RuntimeException("Forking database not supported");
    }

    @Override
    @Ignore
    public GenericStoreDatabase getBackendDatabase() {
        return (GenericStoreDatabase)this.srcGdb.get();
    }

    @Deprecated
    public static class ModelMetadata {
        public WrappedClassData modelClass;
        public FieldData[] fields;
        protected static GetBy1<Boolean, Field> FIELD_SELECTOR = new GetBy1<Boolean, Field>(){

            public Boolean getBy(Field a) {
                int mod = a.getModifiers();
                if (!Modifier.isPublic(mod)) {
                    return false;
                }
                if (Modifier.isStatic(mod)) {
                    return false;
                }
                return true;
            }
        };
        protected static ConcurrentMap<Class, ModelMetadata> CACHE = new ConcurrentHashMap<Class, ModelMetadata>();

        public static ModelMetadata collect(Class c) throws InstantiationException, IllegalAccessException {
            return (ModelMetadata)ConcurrentMapTools.getOrCreate(CACHE, (Object)c, cls -> {
                ModelMetadata ret = new ModelMetadata();
                ret.modelClass = WrappedClassData.wrap((Class)cls, FIELD_SELECTOR);
                ret.fields = GenericStorageMappingData.getOrCollectAllClassData((Class)cls).storedFd;
                return ret;
            });
        }
    }
}

