/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpace;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicClassDescriptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DinamicClassTools {
    protected static Pattern ONE_LEVEL_ARRAY = Pattern.compile("^\\[L(.*);$");
    protected static Pattern MULTI_LEVEL_ARRAY = Pattern.compile("^\\[(.*)$");

    public static GetBy2<ClassDescriptor, ClassSpace, String> addArrayFetch(final GetBy2<ClassDescriptor, ClassSpace, String> classLoader) {
        return new GetBy2<ClassDescriptor, ClassSpace, String>(){

            public ClassDescriptor getBy(ClassSpace cs, String a) {
                Matcher m = ONE_LEVEL_ARRAY.matcher(a);
                if (m.find()) {
                    ClassDescriptor cd = cs.getClassByName(m.group(1));
                    if (null == cd) {
                        return null;
                    }
                    return DinamicClassDescriptor.createArrayType(cd);
                }
                m = MULTI_LEVEL_ARRAY.matcher(a);
                if (m.find()) {
                    ClassDescriptor cd = cs.getClassByName(m.group(1));
                    if (null == cd) {
                        return null;
                    }
                    return DinamicClassDescriptor.createArrayType(cd);
                }
                return (ClassDescriptor)classLoader.getBy((Object)cs, (Object)a);
            }
        };
    }
}

