package eu.javaexperience.webgsdb;

import java.util.List;
import java.util.Set;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.generic.annotations.Ignore;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.GenericModelManagementApi.ModelMetadata;
import hu.ddsi.java.database.GenericStoreDatabase;

public interface ModelManagementApi
{
	public String[] getManagedModels();
	public ModelMetadata getModelMetadata(String cls) throws Exception;
	public List<ClassDescriptor> getAllAccessableClass();

	public WebDbModel getById(String cls, long id) throws Throwable;
	public List<WebDbModel> select(String cls, DataObject criteria, DataArray selectionExtra) throws Exception;
	
	public ValidationResult<TranslationFriendlyValidationEntry> update(String cls, DataObject obj) throws Exception;
	public ValidationResult<TranslationFriendlyValidationEntry> create(String cls, DataObject obj) throws Exception;
	public ValidationResult<TranslationFriendlyValidationEntry> delete(String cls, long id, DataObject deleteInstruction) throws Exception;
	
	public Set<String> getPermissions();
	public void fork(String name);
	
	@Ignore
	public GenericStoreDatabase getBackendDatabase();
}
