package eu.javaexperience.webgsdb.activity;

import java.lang.reflect.Modifier;
import java.util.List;

import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.MouseEvent;
import org.teavm.jso.dom.html.HTMLElement;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.frontend.BasicModelManagerUnit;
import eu.javaexperience.webgsdb.frontend.GenericModelManagementApi;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicModelManager;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicWebDbModel;
import eu.javaexperience.webgsdb.test.WebGsdbFrontendTestTools;
import eu.jvx.js.lib.activity.AbstractActivity;
import eu.jvx.js.lib.activity.AbstractPageStarter;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.TbsStyle;
import eu.jvx.js.lib.ui.FrontendTools;
import eu.teasite.frontend.api.ApiClient;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreData;

public class ModelEditPage extends AbstractActivity
{
	protected final ApiClient api;
	protected final DinamicModelManager modelAccess;
	protected String modelNamespace;
	public ModelEditPage(AbstractPageStarter ps, ApiClient client, String modelNamespace)
	{
		super(ps);
		api = client;
		this.modelNamespace = modelNamespace;
		
		//TODO load the models using the All method
		modelAccess = new DinamicModelManager<WebDbModel>
		(
			api.getApiClass(GenericModelManagementApi.class, modelNamespace),
			new DataObjectTeaVMImpl()
		)
		{
			@Override
			public DinamicWebDbModel createModelInstance()
			{
				return new DinamicWebDbModel()
				{
					@Override
					public String toString()
					{
						String cls = (String) getExtraDataMap().get("class");
						if(null != cls)
						{
							StringTools.getSubstringAfterLastString(cls, ".", cls);
						}
						
						return cls+": "+get("label");
					}
					
					@Override
					public boolean set(String key, Object src)
					{
						if("do".equals(key))
						{
							GenericStoreData data = GenericStorage.getOrCreateGenericStoreData(this);
							data.setId((Long) CastTo.Long.cast(src));
						}
						return super.set(key, src);
					}
				};
			}
		};
	}

	@Override
	public void initAfterInsert()
	{
		FrontendTools.runOnThread(new SimpleCall()
		{
			@Override
			public void call()
			{
				H add = new H("div");
				
				List<ClassDescriptor> models = modelAccess.getManagedModels();
				
				for(ClassDescriptor cd:models)
				{
					System.out.println("TABLE: "+cd.getClassName()+" "+cd.getModifiers());
					if(!Modifier.isAbstract(cd.getModifiers()))
					{
						add.addChilds
						(
							createModelEditorButton(cd),
							new H("br").getHtml()
						);
					}
				}
				
				add.addChilds(new H("div").attrs("id", "current_model_editor").getHtml());
				
				VanillaTools.getDom().getElementById("model_editor_target").appendChild(add.getHtml());
			}
		});
	}
	
	public HTMLElement createModelEditorButton(final ClassDescriptor cls)
	{
		H ret = new H("div");
		ret.attrs("#text", cls.getClassName(), "class", WebGsdbFrontendTestTools.CSS_BTN_SELECT_TABLE);
		ret.style(TbsStyle.BTN_SUCCESS);
		ret.onClick(new EventListener<MouseEvent>()
		{
			@Override
			public void handleEvent(MouseEvent arg0)
			{
				HTMLElement tar = VanillaTools.getDom().getElementById("current_model_editor");
				VanillaTools.removeAllChild(tar);
				
				BasicModelManagerUnit add = createModelManagerUnit(cls);
				tar.appendChild(new H("h4").attrs("#text", "Model: "+cls.getClassName()).getHtml());
				tar.appendChild(add.getHtml());
				add.refresh();
			}
		});
		return ret.getHtml();
	}
	
	protected BasicModelManagerUnit createModelManagerUnit(ClassDescriptor cls)
	{
		return new BasicModelManagerUnit(cls, modelAccess, api);
	}
	
	@Override
	protected HTMLElement createRootElement()
	{
		return new H("div").attrs("id", "model_editor_target").getHtml();
	}
}
