/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb;

import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.MirrorFunctions;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.WebDbModel;
import hu.ddsi.java.database.F;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreException;
import hu.ddsi.java.database.GenericStoreQueryBuilder;
import hu.ddsi.java.database.GsdbExtraCaluse;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class RemoteGsdbTools {
    public static GenericStoreQueryBuilder.AtomicCondition parseAtomicCondition(DataObject ac) {
        F op = F.valueOf((String)ac.getString("o").toLowerCase());
        boolean neg = ac.getBoolean("n");
        String f = ac.getString("f");
        Object[] val = ac.opt("v");
        if (val instanceof DataArray) {
            val = ((DataArray)val).asJavaArray();
        }
        return new GenericStoreQueryBuilder.AtomicCondition(op, neg, f, (Object)val);
    }

    public static GenericStoreQueryBuilder.LogicalGroup parseCriteria(DataObject criteria) {
        String relation = criteria.optString("r");
        DataObject atomicCondidition = criteria.optObject("a");
        DataArray comp = criteria.optArray("c");
        if (null == relation) {
            return new GenericStoreQueryBuilder.LogicalGroup(RemoteGsdbTools.parseAtomicCondition(criteria));
        }
        if (null != atomicCondidition) {
            return new GenericStoreQueryBuilder.LogicalGroup(RemoteGsdbTools.parseAtomicCondition(atomicCondidition));
        }
        GenericStoreQueryBuilder.LogicalGroup[] lrs = new GenericStoreQueryBuilder.LogicalGroup[comp.size()];
        for (int i = 0; i < lrs.length; ++i) {
            lrs[i] = RemoteGsdbTools.parseCriteria(comp.getObject(i));
        }
        return new GenericStoreQueryBuilder.LogicalGroup(GenericStoreQueryBuilder.LogicalRelation.valueOf((String)relation.toLowerCase()), lrs);
    }

    public static DataObject serialize(GenericStoreQueryBuilder.AtomicCondition ac, DataCommon proto) {
        DataObject ret = proto.newObjectInstance();
        ret.putString("o", ac.getOperator().name());
        ret.putBoolean("n", ac.isNegated());
        ret.putString("f", ac.getFieldName());
        DataReprezTools.put((DataObject)ret, (String)"v", (Object)ac.getValue());
        return ret;
    }

    public static DataObject serialize(GenericStoreQueryBuilder.LogicalGroup lg, DataCommon proto) {
        GenericStoreQueryBuilder.LogicalGroup[] g;
        DataObject ret = proto.newObjectInstance();
        ret.putString("r", lg.getLogicalRelation().name());
        GenericStoreQueryBuilder.AtomicCondition ac = lg.getAtomicCondition();
        if (null != ac) {
            ret.putObject("a", RemoteGsdbTools.serialize(ac, proto));
        }
        if (null != (g = lg.getLogicalGroups())) {
            DataArray add = proto.newArrayInstance();
            for (int i = 0; i < g.length; ++i) {
                add.putObject(RemoteGsdbTools.serialize(g[i], proto));
            }
            ret.putArray("g", add);
        }
        return ret;
    }

    public static DataArray serialize(GsdbExtraCaluse[] extraClause, DataCommon instance) {
        DataArray ret = instance.newArrayInstance();
        if (null != ret) {
            for (int i = 0; i < extraClause.length; ++i) {
                GsdbExtraCaluse c = extraClause[i];
                if (null == c) continue;
                ret.putObject(instance.fromObjectLike((ObjectWithProperty)new GsdbExtraClauseWrapper(c)));
            }
        }
        return ret;
    }

    public static boolean isWebgsdbUseField(Field f) {
        return Modifier.isPublic(f.getModifiers());
    }

    public static <T extends WebDbModel> ValidationResult<TranslationFriendlyValidationEntry> createNewFrom(GenericStoreDatabase gdb, Class<T> cls, DataObject data) throws Exception {
        WebDbModel modify = (WebDbModel)cls.newInstance();
        GenericStoreData gd = GenericStorage.getOrCreateGenericStoreData((GenericStorable)modify);
        gd.setOwnerDatabase(gdb);
        modify.loadFromUser((ObjectLike)data);
        ValidationResult ret = new ValidationResult();
        ret.valid = modify.validate(ret.reportEntries);
        if (ret.valid) {
            GenericStorage.post((GenericStoreDatabase)gdb, (GenericStorable)modify);
        }
        return ret;
    }

    public static ValidationResult<TranslationFriendlyValidationEntry> delete(GenericStoreDatabase userDatabase, Class<? extends WebDbModel> cls, long id, DataObject deleteInstruction) throws GenericStoreException {
        WebDbModel elem = (WebDbModel)GenericStorage.getObjectByIDDescendantOf((long)id, cls, (GenericStoreDatabase)userDatabase);
        ValidationResult ret = new ValidationResult();
        if (null == elem) {
            ret.valid = false;
            ret.reportEntries.add(new TranslationFriendlyValidationEntry("id", "db_object_by_id_not_found", (Map)new OneShotMap((Object)"id", (Object)String.valueOf(id))));
            return ret;
        }
        ret.valid = elem.delete(ret.reportEntries);
        if (ret.valid) {
            GenericStorage.removeObject((GenericStorable)elem, (GenericStoreDatabase)userDatabase);
        }
        return ret;
    }

    public static <T extends WebDbModel> ValidationResult<TranslationFriendlyValidationEntry> tryUpdateFrom(GenericStoreDatabase gdb, Class<T> cls, long id, DataObject data, String err_idNotExtist) throws GenericStoreException {
        WebDbModel elem = (WebDbModel)GenericStorage.getObjectByIDDescendantOf((long)id, cls, (GenericStoreDatabase)gdb);
        if (null == elem) {
            throw new RuntimeException(err_idNotExtist);
        }
        ValidationResult ret = new ValidationResult();
        WebDbModel modify = elem.clone();
        modify.loadFromUser((ObjectLike)data);
        ret.valid = modify.validate(ret.reportEntries);
        if (ret.valid) {
            elem.loadFromUser((ObjectLike)data);
            GenericStorage.update((GenericStorable)elem);
        }
        return ret;
    }

    public static class GsdbExtraClauseWrapper
    implements ObjectWithProperty {
        protected GsdbExtraCaluse clause;
        protected static Map<Class, ObjectWithPropertyStorage<GsdbExtraCaluse>> CLS_PROP = new HashMap<Class, ObjectWithPropertyStorage<GsdbExtraCaluse>>();

        public GsdbExtraClauseWrapper(GsdbExtraCaluse c) {
            this.clause = c;
        }

        public Object get(String key) {
            return this.getManager().get((Object)this.clause, key);
        }

        protected ObjectWithPropertyStorage<GsdbExtraCaluse> getManager() {
            ObjectWithPropertyStorage ret = CLS_PROP.get(this.clause.getClass());
            if (null == ret) {
                ret = new ObjectWithPropertyStorage();
                ret.addExaminer("type", e -> e.getType().name());
                Mirror.ClassData cds = Mirror.getClassData(this.clause.getClass());
                for (Field f : cds.select(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD)) {
                    ret.addExaminer(f.getName(), MirrorFunctions.createGetter((Field)f));
                }
            }
            return ret;
        }

        public String[] keys() {
            return this.getManager().keys();
        }
    }
}

