/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.javaclient.JavaRpcClientTools;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.RemoteGsdbDatabase;
import eu.javaexperience.webgsdb.RemoteGsdbTools;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.api.RemoteGsdbApi;
import eu.jvx.js.lib.JvxClientException;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreQueryBuilder;
import hu.ddsi.java.database.GsdbExtraCaluse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SynchronServerModelAccess {
    protected final RemoteGsdbApi api;
    protected final DataCommon dataReprez;
    protected final RemoteGsdbDatabase sma;

    public SynchronServerModelAccess(RemoteGsdbApi api, DataCommon dataReprez) {
        this.api = api;
        this.dataReprez = dataReprez;
        this.sma = new RemoteGsdbDatabase(){

            @Override
            public <D extends WebDbModel> List<D> select(Class<D> cls, GenericStoreQueryBuilder.LogicalGroup criteria, GsdbExtraCaluse ... extraClause) throws JvxClientException {
                return SynchronServerModelAccess.this.select(cls, criteria, extraClause);
            }
        };
    }

    public GenericStoreDatabase getRemoteDatabase() {
        return this.sma;
    }

    public <D extends WebDbModel> GetBy1<List<D>, DataArray> createModelsWrapper(Class<D> cls) {
        final GetBy1<D, DataObject> wrap = this.createModelWrapper(cls);
        return new GetBy1<List<D>, DataArray>(){

            public List<D> getBy(DataArray a) {
                ArrayList<Object> ret = new ArrayList<Object>();
                for (int i = 0; i < a.size(); ++i) {
                    DataObject obj = a.getObject(i);
                    if (null == obj) continue;
                    ret.add(wrap.getBy((Object)obj));
                }
                return ret;
            }
        };
    }

    public <D extends WebDbModel> GetBy1<D, DataObject> createModelWrapper(final Class<D> cls) {
        return new GetBy1<D, DataObject>(){

            public D getBy(DataObject a) {
                try {
                    String cs = a.optString("class");
                    Class ic = null;
                    if (null != cs) {
                        try {
                            ic = Class.forName(cs);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (null == ic) {
                        ic = cls;
                    }
                    WebDbModel ret = (WebDbModel)ic.newInstance();
                    GenericStoreData data = SynchronServerModelAccess.this.setOwnerDatabase(ret);
                    data.setId(Long.valueOf(a.getLong("do")));
                    ret.loadFrom((ObjectLike)a);
                    return ret;
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            }
        };
    }

    public static ValidationResult<LanguageTranslatableValidationEntry> parseValidationResult(DataObject obj) {
        ValidationResult vr = new ValidationResult();
        vr.valid = obj.getBoolean("valid");
        return vr;
    }

    public <D extends WebDbModel> List<D> select(Class<D> cls, GenericStoreQueryBuilder.LogicalGroup criteria, GsdbExtraCaluse ... extraClause) throws JvxClientException {
        DataArray ret = this.api.select(cls.getSimpleName(), RemoteGsdbTools.serialize(criteria, this.dataReprez), RemoteGsdbTools.serialize(extraClause, this.dataReprez));
        GetBy1<List<D>, DataArray> mcv = this.createModelsWrapper(cls);
        return (List)mcv.getBy((Object)ret);
    }

    public String[] getTopModels() throws JvxClientException {
        try {
            return (String[])JavaRpcClientTools.extractToJavaObject((Object)this.api.getManagedModels(), String[].class);
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public RemoteGsdbApi getApi() {
        return this.api;
    }

    public Set<String> getPermissions() {
        DataArray da = this.api.getPermissions();
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < da.size(); ++i) {
            ret.add(da.getString(i));
        }
        return ret;
    }

    public GenericStoreData setOwnerDatabase(WebDbModel model) {
        GenericStoreData data = GenericStorage.getOrCreateGenericStoreData((GenericStorable)model);
        data.setOwnerDatabase((GenericStoreDatabase)this.sma);
        return data;
    }
}

