package eu.javaexperience.webgsdb;

import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.collection.map.MultiMap;
import eu.javaexperience.reflect.Mirror;
import eu.jvx.js.lib.JvxClientException;
import eu.javaexperience.query.F;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorageTools;
import hu.ddsi.java.database.GenericStoreDataReader;
import hu.ddsi.java.database.GenericStoreDataWriter;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GenericStoreQueryResult;
import hu.ddsi.java.database.GsdbExtraCaluse;
import eu.javaexperience.query.LogicalGroup;

public abstract class RemoteGsdbDatabase extends GenericStoreDatabase
{
	@Override
	protected void storeAll(Map<Class<? extends GenericStorable>, List<? extends GenericStorable>> map)throws Exception {}
	
	@Override
	protected List<Long> reserveNextIDRangeAtomic(int size) throws Exception {return null;}
	
	@Override
	public String[] listStoredClasses() throws Exception
	{
		return Mirror.emptyStringArray;
	}
	
	public List<java.lang.Class<? extends GenericStorable>> getDescendantClassesFor(java.lang.Class<? extends GenericStorable> cls) throws Exception
	{
		return NullList.instance;
	}
	
	@Override
	public GenericStoreDataWriter getWriter(String cls) throws Exception {return null;}
	
	@Override
	public GenericStoreDataReader getReader(String clas) throws Exception {return null;}
	
	@Override
	public GenericStoreQueryResult getIDListByQuery(Class<? extends GenericStorable> cls, LogicalGroup lg, boolean all_field) throws Exception {return null;}
	
	protected <T extends GenericStorable> void getAllObjectsByQuery(Class<? extends T> cls, LogicalGroup lg, Collection<T> coll, GsdbExtraCaluse... extra) throws Exception
	{
		CollectionTools.copyInto((Collection) select((Class) cls, lg, extra), (Collection) coll);
	}
	
	@Override
	protected GenericStorable getSingleObjectByID(long id, List<Class<? extends GenericStorable>> clss) throws Exception
	{
		{
			Reference<GenericStorable> ref = cache.get(id);
			if(null != ref)
			{
				GenericStorable c = ref.get();
				if(null != c)
				{
					if(NULL_VALUE == c)
					{
						return null;
					}
					return c;
				}
			}
		}
		
		Object ret = null;
		try
		{
			ret = GenericStorageTools.getSingle(GenericStorable.class, F.eq.is("do", id), this);
			//getById(JavaClassDescriptor.getOfJavaClass(GenericStorable.class), id);
		}
		catch (Throwable e){}
		
		if(null != ret)
		{
			GenericStorable m = (GenericStorable) ret;
			//GenericStorable m = (GenericStorable) createModelWrapper((Class) Class.forName((String) ret.get("class"))).getBy(ret);
			cache.put(id, refObject(m));
			return m;
		}
		else
		{
			cache.put(id, refObject(NULL_VALUE));
			return null;
		}
	}
	
	@Override
	public String getDatabaseName()
	{
		return "";
	}
	
	@Override
	protected long getCurrentId() throws Exception
	{
		return -1;
	}
	
	@Override
	protected void dropClassStorageImpl(Class<? extends GenericStorable> cls) throws Exception {}
	
	@Override
	public void deleteObjectByIDSByClass(long[] id, Class<? extends GenericStorable>[] cls) throws Exception {}
	
	@Override
	public void createStorageForClass(Class<? extends GenericStorable> cls, FieldData[] data) throws Exception {}
	
	@Override
	public void close() {}
	
	public abstract <D extends WebDbModel> List<D> select(Class<D> cls, LogicalGroup criteria, GsdbExtraCaluse... extraClause) throws JvxClientException;
	
	{
		try
		{
			storedClasses = new MultiMap<>();//mustCallAfterConnectionEstablishedBeforeUse();
		}
		catch(Exception e)
		{
			Mirror.propagateAnyway(e);
		}
	}
}
