package eu.javaexperience.webgsdb;

import hu.ddsi.java.database.GenericStorage;
import hu.ddsi.java.database.GenericStoreData;
import hu.ddsi.java.database.GenericStoreDatabase;
import hu.ddsi.java.database.GsdbExtraCaluse;
import eu.javaexperience.query.LogicalGroup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.javaclient.JavaRpcClientTools;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.api.RemoteGsdbApi;
import eu.jvx.js.lib.JvxClientException;

public class SynchronServerModelAccess
{
	protected final RemoteGsdbApi api;
	protected final DataCommon dataReprez;
	protected final RemoteGsdbDatabase sma;
	
	public SynchronServerModelAccess(RemoteGsdbApi api, DataCommon dataReprez)
	{
		this.api = api;
		this.dataReprez = dataReprez;
		sma = new RemoteGsdbDatabase()
		{
			@Override
			public <D extends WebDbModel> List<D> select(Class<D> cls, LogicalGroup criteria, GsdbExtraCaluse... extraClause) throws JvxClientException
			{
				return SynchronServerModelAccess.this.select(cls, criteria, extraClause);
			}
		};
	}
	
	public GenericStoreDatabase getRemoteDatabase()
	{
		return sma;
	}
	
	public <D extends WebDbModel> GetBy1<List<D>, DataArray> createModelsWrapper(Class<D> cls)
	{
		final GetBy1<D, DataObject> wrap = createModelWrapper(cls);
		return new GetBy1<List<D>, DataArray>()
		{
			@Override
			public List<D> getBy(DataArray a)
			{
				ArrayList<D> ret = new ArrayList<>();
				for(int i=0;i<a.size();++i)
				{
					DataObject obj = a.getObject(i);
					if(null != obj)
					{
						ret.add(wrap.getBy(obj));
					}
				}
				return ret;
			}
		};
	}
	
	public <D extends WebDbModel> GetBy1<D, DataObject> createModelWrapper(final Class<D> cls)
	{
		return new GetBy1<D, DataObject>()
		{
			@Override
			public D getBy(DataObject a)
			{
				try
				{
					String cs = a.optString("class");
					Class ic = null;
					if(null != cs)
					{
						try
						{
							ic = Class.forName(cs);
						}
						catch(Exception e){}
					}
					
					if(null == ic)
					{
						ic = cls;
					}
					
					D ret = (D) ic.newInstance();
					GenericStoreData data = setOwnerDatabase(ret);
					data.setId(a.getLong("do"));
					ret.loadFrom(a);
					return ret;
				}
				catch(Exception e)
				{
					Mirror.propagateAnyway(e);
					return null;
				}
			}
		};
	}

	public static ValidationResult<LanguageTranslatableValidationEntry> parseValidationResult(DataObject obj)
	{
		//TODO
		ValidationResult<LanguageTranslatableValidationEntry> vr = new ValidationResult<>();
		vr.valid = obj.getBoolean("valid");
		return vr;
	}
	
	public <D extends WebDbModel> List<D> select(Class<D> cls, LogicalGroup criteria, GsdbExtraCaluse... extraClause) throws JvxClientException
	{
		DataArray ret = api.select
		(
			cls.getSimpleName(),
			RemoteGsdbTools.serialize(criteria, dataReprez),
			RemoteGsdbTools.serialize(extraClause, dataReprez)
		);
		GetBy1<List<D>, DataArray> mcv = createModelsWrapper(cls);
		return mcv.getBy(ret);
	}
	
	public String[] getTopModels() throws JvxClientException
	{
		try
		{
			return (String[]) JavaRpcClientTools.extractToJavaObject(api.getManagedModels(), String[].class);
		}
		catch(Exception e)
		{
			Mirror.propagateAnyway(e);
			return null;
		}
	}

	public RemoteGsdbApi getApi()
	{
		return api;
	}

	public Set<String> getPermissions()
	{
		DataArray da = api.getPermissions();
		Set<String> ret = new HashSet<>();
		for(int i=0;i<da.size();++i)
		{
			ret.add(da.getString(i));
		}
		return ret;
	}

	public GenericStoreData setOwnerDatabase(WebDbModel model)
	{
		GenericStoreData data = GenericStorage.getOrCreateGenericStoreData(model);
		data.setOwnerDatabase(sma);
		return data;
	}
}
