/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.RemoteGsdbTools;
import eu.javaexperience.webgsdb.SynchronServerModelAccess;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.api.RemoteGsdbApi;
import eu.javaexperience.webgsdb.frontend.modellayer.ModelManager;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpace;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.ClassSpaceTools;
import eu.javaexperience.webgsdb.frontend.modellayer.dinamic.DinamicWebDbModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DinamicModelManager<M extends WebDbModel>
extends SynchronServerModelAccess
implements ModelManager<M> {
    protected ClassSpace classSpace;
    protected List<ClassDescriptor> managedModels;

    public DinamicModelManager(RemoteGsdbApi api, DataCommon dataReprez) {
        super(api, dataReprez);
    }

    public ClassDescriptor getClassByName(String name) {
        return this.classSpace.getClassByName(name);
    }

    public M wrap(DataObject obj) {
        DinamicWebDbModel ret = this.createModelInstance();
        ret.loadFrom((ObjectLike)obj);
        return (M)ret;
    }

    public List<M> wrap(DataArray arr) {
        ArrayList<M> ret = new ArrayList<M>();
        for (int i = 0; i < arr.size(); ++i) {
            DataObject o = arr.getObject(i);
            ret.add(this.wrap(o));
        }
        return ret;
    }

    @Override
    public <B extends M> B getById(ClassDescriptor cls, long id) throws Throwable {
        return (B)((WebDbModel)this.api.getById(cls.getClassName(), id));
    }

    @Override
    public ValidationResult<LanguageTranslatableValidationEntry> update(ClassDescriptor cls, DataObject obj) {
        return SynchronServerModelAccess.parseValidationResult(this.api.update(cls.getClassName(), obj));
    }

    @Override
    public <B extends M> ValidationResult<LanguageTranslatableValidationEntry> create(ClassDescriptor cls, DataObject obj) {
        return SynchronServerModelAccess.parseValidationResult(this.api.create(cls.getClassName(), obj));
    }

    @Override
    public <B extends M> List<B> select(ClassDescriptor cls, LogicalGroup criteria) {
        return this.wrap(this.api.select(cls.getClassName(), RemoteGsdbTools.serialize(criteria, this.dataReprez), null));
    }

    @Override
    public <B extends M> ValidationResult<LanguageTranslatableValidationEntry> delete(ClassDescriptor cls, long id, DataObject deleteInstruction) {
        return SynchronServerModelAccess.parseValidationResult(this.api.delete(cls.getClassName(), id, deleteInstruction));
    }

    @Override
    public List<ClassDescriptor> getManagedModels() {
        if (null == this.managedModels) {
            this.managedModels = new ArrayList<ClassDescriptor>();
            String[] tops = this.api.getManagedModels();
            DataArray all = this.api.getAllAccessableClass();
            final HashMap<String, DataObject> classes = new HashMap<String, DataObject>();
            for (int i = 0; i < all.size(); ++i) {
                DataObject obj = all.getObject(i);
                classes.put((String)obj.get("fullName"), obj);
            }
            this.classSpace = ClassSpaceTools.createUsualClassSpace(new GetBy2<ClassDescriptor, ClassSpace, String>(){

                public ClassDescriptor getBy(ClassSpace cs, String a) {
                    DataObject cls = (DataObject)classes.get(a);
                    if (null != cls) {
                        return cs.parseDescriptor(cls);
                    }
                    return null;
                }
            });
            for (String c : classes.keySet()) {
                ClassDescriptor classDescriptor = this.classSpace.getClassByName(c);
            }
            for (String s : tops) {
                ClassDescriptor add = this.classSpace.getClassByName(s);
                if (null == add) continue;
                this.managedModels.add(add);
            }
            this.managedModels = Collections.unmodifiableList(this.managedModels);
        }
        return this.managedModels;
    }

    public DinamicWebDbModel createModelInstance() {
        DinamicWebDbModel ret = new DinamicWebDbModel();
        this.setOwnerDatabase(ret);
        return ret;
    }

    @Override
    public <B extends M> B createModel(ClassDescriptor cls) throws Exception {
        return (B)this.createModelInstance();
    }

    @Override
    public Set<String> getPermissions() {
        DataArray da = this.api.getPermissions();
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < da.size(); ++i) {
            ret.add(da.getString(i));
        }
        return ret;
    }
}

