package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassDescriptorTools;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.interfaces.ObjectWithProperty;

public class DinamicClassDescriptor implements ClassDescriptor, ObjectWithProperty
{
	protected ClassSpace classSpace;
	protected String name;
	protected List<ClassFieldDescriptor> fields;
	protected EnumManager enumManager;
	protected ClassDescriptor componentType;
	protected int modifiers;
	protected boolean isInterface;
	
	protected DinamicClassDescriptor()
	{}
	
	public DinamicClassDescriptor
	(
		ClassSpace classSpace,
		String name,
		List<ClassFieldDescriptor> fields,
		EnumManager enumManager,
		ClassDescriptor componentType,
		int modifiers,
		boolean isInterface
	)
	{
		this.classSpace = classSpace;
		this.name = name;
		this.fields = fields;
		this.enumManager = enumManager;
		this.componentType = componentType;
		this.modifiers = modifiers;
		this.isInterface = isInterface;
	}
	
	@Override
	public int getModifiers()
	{
		return modifiers;
	}
	
	@Override
	public String getClassName()
	{
		return name;
	}

	@Override
	public List<? extends ClassFieldDescriptor> getAllField()
	{
		return fields;
	}

	@Override
	public boolean isEnum()
	{
		return null != enumManager;
	}

	@Override
	public EnumManager getEnumManager()
	{
		return enumManager;
	}

	@Override
	public boolean isArray()
	{
		return null != componentType;
	}

	@Override
	public ClassDescriptor getComponentType()
	{
		return componentType;
	}
	
	public static DinamicClassDescriptor createArrayType(ClassDescriptor cd)
	{
		DinamicClassDescriptor ret = new DinamicClassDescriptor();
		ret.name = cd.getClassName()+"[]";
		ret.componentType = cd;
		ret.fields = NullList.instance;
		return ret;
	}
	
	public static <E extends EnumLike<E>> DinamicClassDescriptor createEnumeration(String name, E... values)
	{
		DinamicClassDescriptor ret = new DinamicClassDescriptor();
		ret.name = name;
		ret.enumManager = EnumTools.createFromEnumLikes(values);
		ret.fields = NullList.instance;
		return ret;
	}
	
	public static <E extends EnumLike<E>> DinamicClassDescriptor createClass(List<ClassDescriptor> supers, String name, int modifiers, ClassFieldDescriptor... fields)
	{
		DinamicClassDescriptor ret = new DinamicClassDescriptor();
		ret.supers = Collections.unmodifiableList(supers);
		ret.name = name;
		ret.modifiers = modifiers;
		ret.fields = Collections.unmodifiableList(CollectionTools.inlineAdd(new ArrayList<>(), fields));
		for(ClassFieldDescriptor f:fields)
		{
			if(f instanceof DinamicClassField)
			{
				((DinamicClassField)f).ownerClass = ret;
			}
		}
		return ret;
	}
	
	@Override
	public String toString()
	{
		return "DinamicClassDescriptor: name: "+name;
	}
	
	protected List<ClassDescriptor> supers = NullList.instance;

	@Override
	public List<ClassDescriptor> getSuperTypes()
	{
		return supers;
	}

	@Override
	public Object get(String key)
	{
		return ClassDescriptorTools.classPropGet(this, key);
	}

	@Override
	public String[] keys()
	{
		return ClassDescriptorTools.classPropKeys();
	}

	@Override
	public boolean isInterface()
	{
		return isInterface;
	}

	@Override
	public ClassSpace getClassSpace()
	{
		return classSpace;
	}

	@Override
	public void setClassSpace(ClassSpace classSpace)
	{
		this.classSpace = classSpace;
	}
}
