package eu.javaexperience.webgsdb.frontend.modellayer.dinamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.RemoteGsdbTools;
import eu.javaexperience.webgsdb.SynchronServerModelAccess;
import eu.javaexperience.webgsdb.WebDbModel;
import eu.javaexperience.webgsdb.api.RemoteGsdbApi;
import eu.javaexperience.webgsdb.frontend.modellayer.ModelManager;
import eu.javaexperience.query.LogicalGroup;

public class DinamicModelManager<M extends WebDbModel> extends SynchronServerModelAccess implements ModelManager<M>
{
	protected ClassSpace classSpace;
	protected List<ClassDescriptor> managedModels;
	
	public DinamicModelManager(RemoteGsdbApi api, DataCommon dataReprez)
	{
		super(api, dataReprez);
	}
	
	public ClassDescriptor getClassByName(String name)
	{
		return classSpace.getClassByName(name);
	}
	
	public M wrap(DataObject obj)
	{
		DinamicWebDbModel ret = createModelInstance();
		ret.loadFrom(obj);
		return (M)ret;
	}
	
	public List<M> wrap(DataArray arr)
	{
		List<M> ret = new ArrayList<>();
		for(int i=0;i<arr.size();++i)
		{
			DataObject o = arr.getObject(i);
			ret.add(wrap(o));
		}
		return ret;
	}
	
	@Override
	public <B extends M> B getById(ClassDescriptor cls, long id) throws Throwable
	{
		return (B) api.getById(cls.getClassName(), id);
	}

	@Override
	public ValidationResult<LanguageTranslatableValidationEntry> update(ClassDescriptor cls, DataObject obj)
	{
		return SynchronServerModelAccess.parseValidationResult(api.update(cls.getClassName(), obj));
	}

	@Override
	public <B extends M> ValidationResult<LanguageTranslatableValidationEntry> create(ClassDescriptor cls, DataObject obj)
	{
		return SynchronServerModelAccess.parseValidationResult(api.create(cls.getClassName(), obj));
	}

	@Override
	public <B extends M> List<B> select(ClassDescriptor cls, LogicalGroup criteria)
	{
		return (List<B>) wrap
		(
			api.select
			(
				cls.getClassName(),
				RemoteGsdbTools.serialize(criteria, dataReprez),
				null
			)
		);
	}

	/*@Override
	public <B extends M> List<B> select(ClassDescriptor cls, LogicalGroup criteria, GsdbExtraCaluse... extraClause)
	{
		return (List<B>) wrap
		(
			api.select
			(
				cls.getClassName(),
				WebGsdbTools.serialize(criteria, dataReprez),
				null
			)
		);
	}*/
	
	@Override
	public <B extends M> ValidationResult<LanguageTranslatableValidationEntry> delete(ClassDescriptor cls, long id, DataObject deleteInstruction)
	{
		return SynchronServerModelAccess.parseValidationResult(api.delete(cls.getClassName(), id, deleteInstruction));
	}

	@Override
	public List<ClassDescriptor> getManagedModels()
	{
		if(null == managedModels)
		{
			managedModels = new ArrayList<>();
			
			String[] tops = api.getManagedModels();
			
			//two different class discover mode
			if(true)
			{
				DataArray all = api.getAllAccessableClass();
				Map<String, DataObject> classes = new HashMap<>();
				for(int i=0;i<all.size();++i)
				{
					DataObject obj = all.getObject(i);
					classes.put((String) obj.get("fullName"), obj);
				}
				
				classSpace = ClassSpaceTools.createUsualClassSpace
				(
					new GetBy2<ClassDescriptor, ClassSpace, String>()
					{
						@Override
						public ClassDescriptor getBy(ClassSpace cs, String a)
						{
							DataObject cls = classes.get(a);
							if(null != cls)
							{
								return cs.parseDescriptor(cls);
							}
							return null;
						}
					}
				);
				
				for(String c:classes.keySet())
				{
					ClassDescriptor cd = classSpace.getClassByName(c);
				}
			}
			else
			{
				classSpace = ClassSpaceTools.createUsualClassSpace
				(
					new GetBy2<ClassDescriptor, ClassSpace, String>()
					{
						@Override
						public ClassDescriptor getBy(ClassSpace cs, String a)
						{
							DataObject data = api.getModelMetadata(a);
							DataArray fields = data.getArray("fields");
							for(int i=0;i<fields.size();++i)
							{
								classSpace.parseDescriptor(fields.getObject(i).getObject("type"));
							}
							
							return classSpace.parseDescriptor(data.getObject("modelClass"));
						}
					}
				);
			}
			
			for(String s:tops)
			{
				ClassDescriptor add = classSpace.getClassByName(s);
				if(null != add)
				{
					managedModels.add(add);
				}
			}
			managedModels = Collections.unmodifiableList(managedModels);
		}
		
		return managedModels;
	}

	public DinamicWebDbModel createModelInstance()
	{
		DinamicWebDbModel ret = new DinamicWebDbModel();
		setOwnerDatabase(ret);
		return ret;
	}
	
	@Override
	public <B extends M> B createModel(ClassDescriptor cls) throws Exception
	{
		return (B) (Object) createModelInstance();
	}

	public Set<String> getPermissions()
	{
		DataArray da = api.getPermissions();
		Set<String> ret = new HashSet<>();
		for(int i=0;i<da.size();++i)
		{
			ret.add(da.getString(i));
		}
		return ret;
	}
}
