package eu.javaexperience.webgsdb.commons;

import hu.ddsi.java.database.fieldAnnotations.GenericStoreIgnore;

import java.util.Map;

import eu.javaexperience.classes.ClassAnnotationDescriptor;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;

@Deprecated
public class FieldExtraAttributes implements ExternalDataAttached, ObjectWithProperty
{
	public FieldExtraAttributes(){}
	
	public FieldExtraAttributes(String trans)
	{
		this.transaltionLabel = trans;
	}
	
	public String transaltionLabel;
	
	public FieldExtraAttributes inputClass(String cls)
	{
		inputClass = cls;
		return this;
	}
	
	public FieldExtraAttributes inputType(String type)
	{
		this.inputType = type;
		return this;
	}
	
	public FieldExtraAttributes userCantModify()
	{
		userCanModify = false;
		return this;
	}
	
	public FieldExtraAttributes userMayNotSee()
	{
		userMaySee = false;
		return this;
	}
	
	public FieldExtraAttributes customFieldManager(Class<? extends FrontendFieldManager> ffm)
	{
		this.frontendFieldManager = null == ffm?null:ffm.getName();
		return this;
	}
	
	public ModelData owner;
	
	public String inputClass;
	public String inputType;
	
	public boolean userCanModify = true;
	public boolean userMaySee = true;

	public /*Class<? extends FrontendFieldManager>*/ String frontendFieldManager;
	
	public FieldExtraAttributes attr(String key, Object value)
	{
		getExtraDataMap().put(key, value);
		return this;
	}
	
	@GenericStoreIgnore
	protected transient Map<String, Object> extraData;
	
	@Override
	public Map<String, Object> getExtraDataMap()
	{
		if(null == extraData)
		{
			extraData = new SmallMap<>();
		}
		return extraData;
	}
	
	@Override
	public Object get(String key)
	{
		return PROPS.get(this, key);
	}

	@Override
	public String[] keys()
	{
		return PROPS.keys();
	}
	
	protected static ObjectWithPropertyStorage<FieldExtraAttributes> PROPS = new ObjectWithPropertyStorage<>();
	
	static
	{
		PROPS.addExaminer("extra", (e)-> e.extraData);
		PROPS.addExaminer("owner", (e)-> e.owner);
		PROPS.addExaminer("inputClass", (e)-> e.inputClass);
		PROPS.addExaminer("inputType", (e)-> e.inputType);
		PROPS.addExaminer("userCanModify", (e)-> e.userCanModify);
		PROPS.addExaminer("userMaySee", (e)-> e.userMaySee);
		PROPS.addExaminer("transaltionLabel", (e)-> e.transaltionLabel);
		PROPS.addExaminer("frontendFieldManager", (e)-> e.frontendFieldManager);
	}
	
	public static FieldExtraAttributes parse(DataObject obj)
	{
		FieldExtraAttributes ret = new FieldExtraAttributes(obj.getString("transaltionLabel"));

		ret.owner = ModelData.parse(obj.optObject("owner"));
		
		{
			DataObject extra = obj.optObject("extra");
			if(null != extra)
			{
				ret.extraData = extra.asJavaMap();
			}
		}
		
		ret.inputClass = obj.optString("inputClass");
		ret.inputType = obj.optString("inputType");
		ret.userCanModify = obj.optBoolean("userCanModify");
		ret.userMaySee = obj.optBoolean("userMaySee");
		ret.frontendFieldManager = obj.optString("frontendFieldManager");
		
		return ret;
	}
	
	protected void addAttribute(DataObject obj)
	{
		getExtraDataMap().put(obj.getString("key"), obj.getString("value"));
	}

	public static FieldExtraAttributes parse(DataArray annotations)
	{
		FieldExtraAttributes ret = new FieldExtraAttributes();
		
		ret.userCanModify = true;
		ret.userMaySee = true;
		
		for(int i=0;i<annotations.size();++i)
		{
			DataObject o = annotations.getObject(i);
			String type = o.getString("annotationType");
			switch(type)
			{
			case "eu.javaexperience.webgsdb.annotations.FrontendAttributes":
			{
				DataArray attrs = o.getArray("attributes");
				for(int a=0;a<attrs.size();a++)
				{
					ret.addAttribute(attrs.getObject(a));
				}
				
				break;
			}
			
			case "eu.javaexperience.webgsdb.annotations.FrontendStructureType":
				ret.getExtraDataMap().put("structClass", o.getString("structClass"));
				break;
			
			case "eu.javaexperience.webgsdb.annotations.FrontendAttribute":
				ret.addAttribute(o);
				break;
			
			case "eu.javaexperience.webgsdb.annotations.CustomFieldManager":
				ret.frontendFieldManager = o.getString("managerClass");
				break;
				
			case "eu.javaexperience.semantic.references.MayNotModified":
				ret.userCanModify = false;
				break;
				
			case "eu.javaexperience.webgsdb.annotations.InputType":
				ret.inputType = o.getString("type");
				break;
			}
		}
		
		return ret;
	}
	
	public static FieldExtraAttributes parse(ClassFieldDescriptor descr)
	{
		FieldExtraAttributes ret = new FieldExtraAttributes();
		ClassAnnotationDescriptor[] anns = descr.getAnnotations();
		if(null != anns)
		{
			for(ClassAnnotationDescriptor ann:anns)
			{
				String type = ann.getType();
				Map<String, Object> o = ann.getExtraDataMap();
				switch(type)
				{
				case "eu.javaexperience.gsdbrpc.annotations.RpcAttributes":
				case "eu.javaexperience.gsdbrpc.annotations.RcpStructureType":
				case "eu.javaexperience.gsdbrpc.annotations.RpcAttribute":
					ret.getExtraDataMap().putAll(o);
					break;
				
				case "eu.javaexperience.gsdbrpc.annotations.CustomFieldManager":
					ret.frontendFieldManager = (String) o.get("managerClass");
					break;
					
				case "eu.javaexperience.gsdbrpc.references.MayNotModified":
					ret.userCanModify = false;
					break;
					
				case "eu.javaexperience.gsdbrpc.annotations.InputType":
					ret.inputType = (String) o.get("type");
					break;
				}
			}
		}
		return ret;
	}
}