package eu.javaexperience.webgsdb.frontend;

import java.util.Date;
import java.util.List;

import org.teavm.jso.JSObject;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.json.JSON;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.convertFrom.ObjectLike;
import eu.javaexperience.gsdbrpc.WebDbModel;
import eu.javaexperience.gsdbrpc.WebGsdbTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.teasite.frontend.table.GeneratedResultTable;
import eu.javaexperience.teasite.frontend.table.ResultTableGenerator;
import eu.javaexperience.teasite.frontend.table.ResultTableGenerator.TableField;
import eu.javaexperience.text.Format;
import eu.javaexperience.webgsdb.commons.FieldExtraAttributes;
import eu.javaexperience.webgsdb.commons.FrontendFieldManager;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.bindings.VanillaTools.ClassList;
import eu.jvx.js.lib.ui.component.table.SimpleTableStructureManager;
import eu.jvx.js.lib.ui.component.table.TableRow;

public class ModelTableGeneratorTools
{
	protected static String getFieldLabelName(ClassFieldDescriptor fd)
	{
		FieldExtraAttributes extra = FieldExtraAttributes.parse(fd);
		if(null != extra)
		{
			if(null != extra.transaltionLabel)
			{
				return extra.transaltionLabel;
			}
		}
		
		return fd.getName();
	}
	
	public static <S, D extends WebDbModel> GeneratedResultTable<S> generateResultTable
	(
		ClassDescriptor cls,
		final GetBy3<HTMLElement, ResultTableGenerator.TableField<S>, TableRow, S> fieldRender,
		Iterable<S> arr,
		GetBy1<ResultTableGenerator<S>, ResultTableGenerator<S>> generatorModifier
	)
		throws Throwable
	{
		ResultTableGenerator<S> gen = new ResultTableGenerator<S>();
		final List<? extends ClassFieldDescriptor> fds = cls.getAllField();
		gen.getFields = new SimplePublish1<List<TableField<S>>>()
		{
			@Override
			public void publish(List<TableField<S>> a)
			{
				for(ClassFieldDescriptor fd:fds)
				{
					if(!fd.isUserAccessible())
					{
						continue;
					}
					
					FieldExtraAttributes mfd = FieldExtraAttributes.parse(fd);
					if(null == mfd || mfd.userMaySee)
					{
						TableField<S> tf = new TableField<>();
						tf.getExtraDataMap().put("fd", fd);
						tf.fieldName = fd.getName();
						tf.renderLabel = new GetBy1<HTMLElement, ResultTableGenerator.TableField<S>>()
						{
							@Override
							public HTMLElement getBy(TableField<S> a)
							{
								return new H("span").attrs("#text", getFieldLabelName(fd)).getHtml();
							}
						};
						
						tf.renderField = fieldRender;
						
						a.add(tf);
					}
				}
			}
		};
		
		if(null != generatorModifier)
		{
			gen = generatorModifier.getBy(gen);
		}
		
		
		GeneratedResultTable<S> ret = gen.generate(SimpleTableStructureManager.INSTANCE, arr);
		ClassList cl = VanillaTools.getClassList(ret.html);
		cl.add("table");
		cl.add("table-hover");
		cl.add("table-striped");
		cl.add("table-responsive");
		return ret;
	}
	
	public static <S extends ObjectLike, D extends WebDbModel> GeneratedResultTable<S> generateResultTable
	(
		ClassDescriptor cls,
		Iterable<S> arr,
		GetBy1<ResultTableGenerator<S>, ResultTableGenerator<S>> generatorModifier
	)
		throws Throwable
	{
		return generateResultTable
		(
			cls,
			(GetBy3)DEFAULT_MODEL_FIELD_RENDERER,
			(Iterable<S>)(Iterable)arr,
			generatorModifier
		);
	}
	
	public static GetBy3<HTMLElement, TableField<ObjectLike>, TableRow, ObjectLike> DEFAULT_MODEL_FIELD_RENDERER = new GetBy3<HTMLElement, TableField<ObjectLike>, TableRow, ObjectLike>()
	{
		@Override
		public HTMLElement getBy(TableField<ObjectLike> a, TableRow b, ObjectLike c)
		{
			ClassFieldDescriptor fd = (ClassFieldDescriptor) a.getExtraDataMap().get("fd");
			String val = "";
			FieldExtraAttributes fmd = FieldExtraAttributes.parse(fd);
			FrontendFieldManager ffm = WebGsdbTools.getFrontendFieldManager((WebDbModel) c, fd, fmd);
			val = ffm.toString((WebDbModel) c, fd.getName());
			return new H("span").attrs("#text", val, "data-name", fd.getName(), "data-value", attrToString(c.get(fd.getName()))).getHtml();
		}
	};
	
	protected static String attrToString(Object o)
	{
		if(o instanceof DataCommon)
		{
			return JSON.stringify((JSObject) ((DataCommon)o).getImpl());
		}
		
		if(o instanceof Date)
		{
			return Format.UTC_SQL_TIMESTAMP_MS.format((Date) o);
		}
		
		return String.valueOf(o);
	}
}
