/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.commons;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.gsdbrpc.RemoteGsdbTools;
import eu.javaexperience.gsdbrpc.WebDbModel;
import eu.javaexperience.gsdbrpc.annotations.CustomFieldManager;
import eu.javaexperience.gsdbrpc.annotations.InputType;
import eu.javaexperience.gsdbrpc.annotations.MayNotSee;
import eu.javaexperience.gsdbrpc.annotations.RpcAttribute;
import eu.javaexperience.gsdbrpc.annotations.RpcAttributes;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.PrimitiveTools;
import eu.javaexperience.rpc.JavaClassRpcCollector;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.semantic.references.MayNotModified;
import eu.javaexperience.text.StringTools;
import hu.ddsi.java.database.FieldData;
import hu.ddsi.java.database.GenericStorageMappingData;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FrontendMetadataGenerator {
    protected Appendable out;
    protected Class<? extends WebDbModel>[] models;

    public FrontendMetadataGenerator(Appendable out, Class<? extends WebDbModel> ... models) {
        this.out = out;
        this.models = models;
    }

    protected abstract String examineTranslationName(Field var1);

    protected void appendReflectionMetaData(Appendable sb, Class cls) throws IOException {
        Mirror.ClassData cd = Mirror.getClassData((Class)cls);
        sb.append("\t\tWebGsdbTools.putFieldAttributes");
        sb.append("\n\t\t(");
        sb.append("\n\t\t\t" + cls.getCanonicalName() + ".class,");
        int i = 0;
        HashMap<String, Field> lastField = new HashMap<String, Field>();
        for (Field f : cd.select(FieldSelectTools.SELECT_ALL_INSTANCE_FIELD)) {
            lastField.put(f.getName(), f);
        }
        for (Map.Entry entry : lastField.entrySet()) {
            String add;
            InputType it;
            Field f = (Field)entry.getValue();
            if (!Modifier.isPublic(f.getModifiers())) continue;
            if (++i > 1) {
                sb.append(",");
            }
            sb.append("\n\t\t\t");
            sb.append("\"").append(f.getName()).append("\", new FieldExtraAttributes(");
            sb.append(this.examineTranslationName(f));
            sb.append(")");
            if (null != f.getAnnotation(MayNotModified.class)) {
                sb.append(".userCantModify()");
            }
            if (null != (it = f.getAnnotation(InputType.class))) {
                sb.append(".inputType(\"");
                sb.append(it.type());
                sb.append("\")");
            }
            if (null != (it = f.getAnnotation(MayNotSee.class))) {
                sb.append(".userMayNotSee()");
            }
            if (null == (add = this.renderCallAddExtraAddributes(f))) continue;
            sb.append(add);
        }
        sb.append("\n\t\t);\n");
    }

    protected void appendModelFieldUrchin(Appendable sb, Class cls) throws InstantiationException, IllegalAccessException, IOException {
        FieldData[] fds;
        String type = cls.getCanonicalName();
        sb.append("\t\tif(TeaVmTools.isUrchin())\n\t\t{\n\t\t\t");
        sb.append(type);
        sb.append(" m = new ");
        sb.append(type);
        sb.append("();\n\t\t");
        for (FieldData fd : fds = GenericStorageMappingData.getOrCollectAllClassData((Class)cls).allFd) {
            if (!RemoteGsdbTools.isWebgsdbUseField((Field)fd.f)) continue;
            sb.append("\tm.");
            sb.append(fd.f.getName());
            sb.append(" = ");
            Class c = fd.f.getType();
            c = PrimitiveTools.toObjectClassType(c, c);
            if (c == Boolean.class) {
                sb.append("true");
            } else if (c == Byte.class) {
                sb.append("(byte) 1");
            } else if (c == Character.class) {
                sb.append("'c'");
            } else if (c == Short.class) {
                sb.append("(short) 1");
            } else if (c == Integer.class) {
                sb.append("1");
            } else if (c == Long.class) {
                sb.append("1l");
            } else if (c == Float.class) {
                sb.append("1.0f");
            } else if (c == Double.class) {
                sb.append("1.0d");
            } else {
                sb.append("null");
            }
            sb.append(";\n\t\t");
        }
        sb.append("}\n");
    }

    public void exportReflection() throws Throwable {
        this.out.append("import eu.jvx.js.lib.TeaVmTools;\nimport eu.javaexperience.webgsdb.WebGsdbTools;\nimport eu.javaexperience.webgsdb.commons.FieldExtraAttributes;\n\n\n");
        this.out.append("public class TeaVmMetadata\n{\n\tprotected static boolean init = false;\n\n\tpublic static void initTeaVmMetadata()\n\t{\n");
        this.out.append("\t\tif(init){return;} init = true;\n");
        for (Class<? extends WebDbModel> cls : this.models) {
            if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) continue;
            this.appendReflectionMetaData(this.out, cls);
            this.out.append("\n");
            this.appendModelFieldUrchin(this.out, cls);
            this.out.append("\n\n");
        }
        this.out.append("\n\t}");
        this.out.append("\n}");
    }

    protected String renderCallAddExtraAddributes(Field f) {
        RpcAttributes fes;
        RpcAttribute fe;
        Class cls;
        StringBuilder sb = new StringBuilder();
        CustomFieldManager cfm = f.getAnnotation(CustomFieldManager.class);
        if (null != cfm && null != (cls = cfm.managerClass())) {
            sb.append(".customFieldManager(");
            sb.append(cls.getCanonicalName());
            sb.append(".class)");
        }
        if (null != (fe = f.getAnnotation(RpcAttribute.class))) {
            FrontendMetadataGenerator.appendAttribute(sb, fe);
        }
        if (null != (fes = f.getAnnotation(RpcAttributes.class))) {
            for (RpcAttribute fe2 : fes.attributes()) {
                if (null == fe2) continue;
                FrontendMetadataGenerator.appendAttribute(sb, fe2);
            }
        }
        if (0 == sb.length()) {
            return null;
        }
        return sb.toString();
    }

    public static Class<? extends WebDbModel>[] getClasses(List<RpcFacility> apis) {
        return (Class[])CollectionTools.convert(Class.class, apis, e -> ((JavaClassRpcCollector)e).getWrappedClass());
    }

    public static String wrapString(String s) {
        if (null == s) {
            return null;
        }
        return "\"" + StringTools.escapeToJavaString((String)s) + "\"";
    }

    public static void appendAttribute(StringBuilder sb, RpcAttribute fa) {
        sb.append(".attr(");
        sb.append(FrontendMetadataGenerator.wrapString(fa.key()));
        sb.append(", ");
        sb.append(FrontendMetadataGenerator.wrapString(fa.value()));
        sb.append(")");
    }
}

