package eu.javaexperience.webgsdb.activity;

import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.MouseEvent;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.webgsdb.frontend.MultiGenericModelManagementApi;
import eu.javaexperience.webgsdb.test.WebGsdbFrontendTestTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.TbsStyle;
import eu.jvx.js.lib.style.StyleTools.StyleAlaCarte;
import eu.jvx.js.lib.ui.FrontendTools;
import eu.jvx.js.lib.ui.form.FormBuilder;
import eu.jvx.js.tbs.ui.TbsTools;
import eu.teasite.frontend.api.ApiClient;

public class MultiDatabaseModelEditorPage
{
	protected final ApiClient api;
	
	protected MultiGenericModelManagementApi databaseApis;
	
	protected String namespace;
	
	protected H targetContainer;
	public MultiDatabaseModelEditorPage(H targetContainer, ApiClient client, String modelNamespace)
	{
		api = client;
		
		databaseApis = client.getApiClass(MultiGenericModelManagementApi.class, modelNamespace);
		namespace = modelNamespace;
		this.targetContainer = targetContainer;
	}

	public void showDatabases()
	{
		FrontendTools.runOnThread(new SimpleCall()
		{
			@Override
			public void call()
			{
				DataArray dbs = databaseApis.listDatabases();
				
				setHeader(new H("div").attrs("#text", "Select a database").style(StyleAlaCarte.TEXT_CENTER).getHtml());

				H add = new H("div");
				for(int i=0;i<dbs.size();++i)
				{
					String db = dbs.getString(i);
					add.addChilds(new H("div").addChilds(createDatabaseSelectButton(db)));
				}
				
				setBody(add.getHtml());
			}
		});
	}
	
	protected void selectDatabase(String db)
	{
		try
		{
			databaseApis.selectDatabase(db);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
		//todo select database, place title, show permissions and operations
		setHeader
		(
			new H("div").style(TbsStyle.ALERT_INFO).addChilds
			(
				new H("div").addChilds
				(
					new H("div").attrs("#text", "Back").style(StyleAlaCarte.DISPLAY_INLINE_BLOCK, TbsStyle.BTN_SUCCESS).onClick((e)->showDatabases()),		
					generatePermissionLabels()
				),
				new H("div").attrs("#text", db, "id", "current_database_name").style(TbsStyle.ALERT_WARNING, StyleAlaCarte.TEXT_CENTER).getHtml()
			).getHtml()
		);
		
		ModelEditPage editor = createModelEditor(db);
		
		editor.initAfterInsert();
	}
	
	protected ModelEditPage createModelEditor(String db)
	{
		return new ModelEditPage(targetContainer, api, namespace);
	}
	
	public HTMLElement createDatabaseSelectButton(final String db)
	{
		H ret = new H("div");
		ret.attrs("#text", db, "class", WebGsdbFrontendTestTools.CSS_BTN_SELECT_DATABASE);
		ret.style(TbsStyle.BTN_SUCCESS);
		ret.onClick(new EventListener<MouseEvent>()
		{
			@Override
			public void handleEvent(MouseEvent arg0)
			{
				selectDatabase(db);
			}
		});
		return ret.getHtml();
	}
	
	protected HTMLElement generatePermissionLabels()
	{
		H ret = new H("div").style(StyleAlaCarte.DISPLAY_INLINE_BLOCK, StyleAlaCarte.FLOAT_RIGHT);
		
		DataArray arr = databaseApis.getPermissions();
		for(int i=0;i<arr.size();++i)
		{
			String s = arr.getString(i);
			
			H elem = null;
			
			if(s.equals("fork"))
			{
				elem = generateForkButton();
			}
			else
			{
				elem = new H("span").style(TbsStyle.LABEL_INFO).attrs("#text", s);
			}
			
			ret.addChilds
			(
				elem,
				new H("span").attrs("#text", " ").getHtml()
			);
		}
		
		return ret.getHtml();
	}
	
	protected H generateForkButton()
	{
		return new H("span").style(TbsStyle.LABEL_SUCCESS).attrs("#text", "fork").onClick(new EventListener<MouseEvent>()
		{
			@Override
			public void handleEvent(MouseEvent arg0)
			{
				//BODY:
				TbsTools.modal
				(
					new H("span").attrs("#text", "Fork database: "+VanillaTools.getDom().querySelector("#current_database_name").getInnerHTML()).getHtml(), 
					new FormBuilder().addSm(4, 6, "New Database name:", new H("input").attrs("id", "database_fork_name").getHtml()).nerf().getHtml(),
					new H("div").addChilds
					(
						new H("div").attrs("#text", "fork").style(TbsStyle.BTN_SUCCESS).onClick(new EventListener<MouseEvent>()
						{
							@Override
							public void handleEvent(MouseEvent arg0)
							{
								String val = ((HTMLInputElement)VanillaTools.getDom().querySelector("#database_fork_name")).getValue();
								
								try
								{
									databaseApis.fork(val);
									TbsTools.closeModal(arg0.getTarget().cast());
								}
								catch(Exception e)
								{
									e.printStackTrace();
								}
							}
						}),
						TbsTools.createModalCloseButton("Cancel")
					).getHtml()
				);
			}
		});
	}
	
	protected void setBody(HTMLElement html)
	{
		HTMLElement el = VanillaTools.getDom().getElementById("model_editor_target");
		VanillaTools.removeAllChild(el);
		if(null != html)
		{
			el.appendChild(html);
		}
	}
	
	protected void setHeader(HTMLElement html)
	{
		HTMLElement el = VanillaTools.getDom().getElementById("model_editor_header");
		VanillaTools.removeAllChild(el);
		if(null != html)
		{
			el.appendChild(html);
		}
	}
	
	protected HTMLElement createRootElement()
	{
		return new H("div").attrs("id", "multi_model_editor_target").addChilds
		(
			new H("div").attrs("id", "model_editor_header"),
			new H("div").attrs("id", "model_editor_target")
		).getHtml();
	}
}
