package eu.javaexperience.gsdbrpc;

import java.lang.reflect.Field;

import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNotModified;
import eu.jvx.js.lib.TeaVmTools;
import eu.jvx.js.lib.reflect.TeaVmMockedReflection;
import hu.ddsi.java.database.GenericStorable;
import hu.ddsi.java.database.GenericStorage;

public abstract class WebDbModel extends RpcDbModel
{
	@Override
	public Object get(String key)
	{
		if("do".equals(key))
		{
			return GenericStorage.getID(this);
		}
		
		if("class".equals(key))
		{
			return this.getClass().getName();
		}
		
		GsdbModelMappingData mapping = null;
		
		try
		{
			mapping = getMappingData(getClass());
		}
		catch(Exception e)
		{
			Mirror.propagateAnyway(e);
		}
		
		Field f = mapping.getFieldValue.get(key);
		
		if(null == f)
		{
			return getExtraDataMap().get(key);
		}
		
		try
		{
			Object ret = null;
			if(TeaVmTools.IS_FRONTEND)
			{
				return TeaVmMockedReflection.getObjectField(this, key);
			}
			else
			{
				ret = f.get(this);
			}
			
			if(null != ret)
			{
				if(ret.getClass().isEnum())
				{
					return ((Enum)ret).name();
				}
				else if(ret.getClass().isArray())
				{
					Class<?> comp = ret.getClass().getComponentType();
					if(GenericStorable.class.isAssignableFrom(comp))
					{
						Long[] r = new Long[((Object[])ret).length];
						for(int i=0;i<r.length;++i)
						{
							GenericStorable elem = ((GenericStorable[])ret)[i];
							if(null == elem)
							{
								r[i] = -1l;
							}
							else
							{
								r[i] = GenericStorage.getID(elem);
							}
						}
						return r;
					}
					
					return ret;
				}
				if(ret instanceof GenericStorable)
				{
					return GenericStorage.getID(((GenericStorable)ret));
				}
			}
			return ret;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return null;
		}
	}

	public boolean set(String key, Object src, boolean filter)
	{
		try
		{
			GsdbModelMappingData mapping = getMappingData(this.getClass());
			Field f = mapping.getFieldValue.get(key);
			
			if(null != f)
			{
				if(filter && null != f.getAnnotation(MayNotModified.class))
				{
					return false;
				}
				
				if(null != src)
				{
					src = tryCast(this, f.getType(), src);

					if(TeaVmTools.IS_FRONTEND)
					{
						return TeaVmMockedReflection.setObjectField(this, key, src);
					}
					else
					{
						f.set(this, src);
						return true;
					}
				}
				else
				{
					f.set(this, null);
				}
			}
			else
			{
				getExtraDataMap().put(key, src);
			}
		}
		catch(Exception e)
		{
			//Mirror.propagateAnyway(e);
		}
		return false;
	}
}
