/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.activity;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.webgsdb.activity.ModelEditPage;
import eu.javaexperience.webgsdb.frontend.MultiGenericModelManagementApi;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.StyleDecoratorSource;
import eu.jvx.js.lib.style.StyleTools;
import eu.jvx.js.lib.style.TbsStyle;
import eu.jvx.js.lib.ui.FrontendTools;
import eu.jvx.js.lib.ui.form.FormBuilder;
import eu.jvx.js.tbs.ui.TbsTools;
import eu.teasite.frontend.api.ApiClient;
import org.teavm.jso.JSObject;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.events.MouseEvent;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.xml.Node;

public class MultiDatabaseModelEditorPage {
    protected final ApiClient api;
    protected MultiGenericModelManagementApi databaseApis;
    protected String namespace;
    protected H targetContainer;

    public MultiDatabaseModelEditorPage(H targetContainer, ApiClient client, String modelNamespace) {
        this.api = client;
        this.databaseApis = (MultiGenericModelManagementApi)client.getApiClass(MultiGenericModelManagementApi.class, modelNamespace);
        this.namespace = modelNamespace;
        this.targetContainer = targetContainer;
    }

    public void showDatabases() {
        FrontendTools.runOnThread((SimpleCall)new SimpleCall(){

            public void call() {
                DataArray dbs = MultiDatabaseModelEditorPage.this.databaseApis.listDatabases();
                MultiDatabaseModelEditorPage.this.setHeader(new H("div").attrs(new String[]{"#text", "Select a database"}).style(new StyleDecoratorSource[]{StyleTools.StyleAlaCarte.TEXT_CENTER}).getHtml());
                H add = new H("div");
                for (int i = 0; i < dbs.size(); ++i) {
                    String db = dbs.getString(i);
                    add.addChilds(new H[]{new H("div").addChilds(new HTMLElement[]{MultiDatabaseModelEditorPage.this.createDatabaseSelectButton(db)})});
                }
                MultiDatabaseModelEditorPage.this.setBody(add.getHtml());
            }
        });
    }

    protected void selectDatabase(String db) {
        try {
            this.databaseApis.selectDatabase(db);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setHeader(new H("div").style(new StyleDecoratorSource[]{TbsStyle.ALERT_INFO}).addChilds(new JSObject[]{new H("div").addChilds(new JSObject[]{new H("div").attrs(new String[]{"#text", "Back"}).style(new StyleDecoratorSource[]{StyleTools.StyleAlaCarte.DISPLAY_INLINE_BLOCK, TbsStyle.BTN_SUCCESS}).onClick(e -> this.showDatabases()), this.generatePermissionLabels()}), new H("div").attrs(new String[]{"#text", db, "id", "current_database_name"}).style(new StyleDecoratorSource[]{TbsStyle.ALERT_WARNING, StyleTools.StyleAlaCarte.TEXT_CENTER}).getHtml()}).getHtml());
        ModelEditPage editor = this.createModelEditor(db);
        editor.initAfterInsert();
    }

    protected ModelEditPage createModelEditor(String db) {
        return new ModelEditPage(this.targetContainer, this.api, this.namespace);
    }

    public HTMLElement createDatabaseSelectButton(final String db) {
        H ret = new H("div");
        ret.attrs(new String[]{"#text", db, "class", "jvx-selectable-database"});
        ret.style(new StyleDecoratorSource[]{TbsStyle.BTN_SUCCESS});
        ret.onClick((EventListener)new EventListener<MouseEvent>(){

            public void handleEvent(MouseEvent arg0) {
                MultiDatabaseModelEditorPage.this.selectDatabase(db);
            }
        });
        return ret.getHtml();
    }

    protected HTMLElement generatePermissionLabels() {
        H ret = new H("div").style(new StyleDecoratorSource[]{StyleTools.StyleAlaCarte.DISPLAY_INLINE_BLOCK, StyleTools.StyleAlaCarte.FLOAT_RIGHT});
        DataArray arr = this.databaseApis.getPermissions();
        for (int i = 0; i < arr.size(); ++i) {
            String s = arr.getString(i);
            H elem = null;
            elem = s.equals("fork") ? this.generateForkButton() : new H("span").style(new StyleDecoratorSource[]{TbsStyle.LABEL_INFO}).attrs(new String[]{"#text", s});
            ret.addChilds(new JSObject[]{elem, new H("span").attrs(new String[]{"#text", " "}).getHtml()});
        }
        return ret.getHtml();
    }

    protected H generateForkButton() {
        return new H("span").style(new StyleDecoratorSource[]{TbsStyle.LABEL_SUCCESS}).attrs(new String[]{"#text", "fork"}).onClick((EventListener)new EventListener<MouseEvent>(){

            public void handleEvent(MouseEvent arg0) {
                TbsTools.modal((HTMLElement)new H("span").attrs(new String[]{"#text", "Fork database: " + VanillaTools.getDom().querySelector("#current_database_name").getInnerHTML()}).getHtml(), (HTMLElement)new FormBuilder().addSm(4, 6, "New Database name:", new H("input").attrs(new String[]{"id", "database_fork_name"}).getHtml()).nerf().getHtml(), (HTMLElement)new H("div").addChilds(new JSObject[]{new H("div").attrs(new String[]{"#text", "fork"}).style(new StyleDecoratorSource[]{TbsStyle.BTN_SUCCESS}).onClick((EventListener)new EventListener<MouseEvent>(){

                    public void handleEvent(MouseEvent arg0) {
                        String val = ((HTMLInputElement)VanillaTools.getDom().querySelector("#database_fork_name")).getValue();
                        try {
                            MultiDatabaseModelEditorPage.this.databaseApis.fork(val);
                            TbsTools.closeModal((HTMLElement)((HTMLElement)arg0.getTarget().cast()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }), TbsTools.createModalCloseButton((String)"Cancel")}).getHtml());
            }
        });
    }

    protected void setBody(HTMLElement html) {
        HTMLElement el = VanillaTools.getDom().getElementById("model_editor_target");
        VanillaTools.removeAllChild((HTMLElement)el);
        if (null != html) {
            el.appendChild((Node)html);
        }
    }

    protected void setHeader(HTMLElement html) {
        HTMLElement el = VanillaTools.getDom().getElementById("model_editor_header");
        VanillaTools.removeAllChild((HTMLElement)el);
        if (null != html) {
            el.appendChild((Node)html);
        }
    }

    protected HTMLElement createRootElement() {
        return new H("div").attrs(new String[]{"id", "multi_model_editor_target"}).addChilds(new H[]{new H("div").attrs(new String[]{"id", "model_editor_header"}), new H("div").attrs(new String[]{"id", "model_editor_target"})}).getHtml();
    }
}

