/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.webgsdb.frontend;

import eu.javaexperience.classes.ClassDescriptor;
import eu.javaexperience.classes.ClassFieldDescriptor;
import eu.javaexperience.classes.dinamic.DinamicModelManager;
import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.ModifiableObject;
import eu.javaexperience.gsdbrpc.WebDbModel;
import eu.javaexperience.gsdbrpc.WebGsdbTools;
import eu.javaexperience.gsdbrpc.api.ModelManager;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.interfaces.simple.getBy.GetBy4;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.patterns.creational.builder.PublisherBuilder;
import eu.javaexperience.query.F;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.teasite.frontend.table.GeneratedResultTable;
import eu.javaexperience.teasite.frontend.table.ResultTableGenerator;
import eu.javaexperience.verify.LanguageTranslatableValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.javaexperience.webgsdb.activity.ModelEditPage;
import eu.javaexperience.webgsdb.commons.FieldExtraAttributes;
import eu.javaexperience.webgsdb.commons.FrontendFieldEditContext;
import eu.javaexperience.webgsdb.frontend.ModelTableGeneratorTools;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.TeaVmTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.style.StyleDecoratorSource;
import eu.jvx.js.lib.style.StyleTools;
import eu.jvx.js.lib.style.TbsStyle;
import eu.jvx.js.lib.ui.FrontendTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainerTools;
import eu.jvx.js.lib.ui.component.table.SimpleTableStructureManager;
import eu.jvx.js.lib.ui.component.table.TableRow;
import eu.jvx.js.lib.ui.component.table.TableStructureManager;
import eu.jvx.js.tbs.TbsGlyph;
import eu.jvx.js.tbs.ui.TbsLayoutTools;
import eu.jvx.js.tbs.ui.TbsTools;
import eu.teasite.frontend.api.ApiClient;
import hu.ddsi.java.database.GenericStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;

public class BasicModelManagerUnit<B extends WebDbModel, D extends B>
implements ImpersonalisedHtml {
    public ClassDescriptor cls;
    public ModelManager<B> acc;
    public ApiClient api;
    public GetBy2<Boolean, String, ClassFieldDescriptor> selectField = (a, b) -> true;
    protected Set<String> perms = null;
    public HTMLElement container = null;
    public HTMLElement filterBox = new H("div").getHtml();
    public HTMLElement resultTableBox = new H("div").getHtml();
    protected HTMLElement addNewModelButton = new H("span").attrs(new String[]{"class", "jvx-create-new-model"}).style(new StyleDecoratorSource[]{TbsGlyph.PLUS_SIGN, TbsStyle.BTN_SUCCESS}).onClick(e -> this.popupAddNewModel()).getHtml();
    public GetBy1<String, String> txtCreateNew = s -> "Create new " + s;
    public GetBy2<String, String, D> txtOp = (op, model) -> {
        switch (op) {
            case "delete": {
                return "Do you really want to delete: " + ((Object)model).toString();
            }
            case "modify": {
                return "Modifying " + ((Object)model).toString();
            }
        }
        return "translate(op: " + op + ", model: " + (Object)model + ")";
    };
    public GetBy1<String, String> translate = s -> {
        if (null != s) {
            switch (s) {
                case "btn_cancel": {
                    return "Cancel";
                }
                case "btn_close": {
                    return "Close";
                }
                case "btn_save": {
                    return "Save";
                }
                case "btn_delete": {
                    return "Delete";
                }
                case "op_deletion_failed": {
                    return "Deletion failed";
                }
                case "title_confirm_deletion": {
                    return "Confirm deletion";
                }
            }
        }
        return "translate(" + s + ")";
    };
    public GetBy4<HTMLElement, BasicModelManagerUnit<B, D>, Set<String>, D, TableRow> generateOperations = (table, permissions, model, row) -> new H("div").addChilds(new H[]{!permissions.contains("update") ? null : new H("span").style(new StyleDecoratorSource[]{TbsGlyph.PENCIL, TbsStyle.BTN_DEFAULT, StyleTools.StyleAlaCarte.FS_1, StyleTools.StyleAlaCarte.MARGIN_1}).onClick(e -> this.popupEdit((D)model, (TableRow)row)), !permissions.contains("delete") ? null : new H("span").style(new StyleDecoratorSource[]{TbsGlyph.TRASH, TbsStyle.BTN_DEFAULT, StyleTools.StyleAlaCarte.FS_1, StyleTools.StyleAlaCarte.MARGIN_1}).onClick(e -> this.popupConfirmDelete((D)model, (TableRow)row))}).getHtml();
    protected static GetBy1 CUSTOM_FIELD_NAME;
    public boolean showId = true;
    public ResultTableGenerator<D> tableGenerator;
    protected GeneratedResultTable<D> lastResultTable = null;
    protected SimplePublish1<List<D>> reRenderTable = new SimplePublish1<List<D>>(){

        public void publish(List<D> a) {
            try {
                BasicModelManagerUnit.this.lastResultTable = BasicModelManagerUnit.this.renderTable(a);
                BasicModelManagerUnit.this.setContent(new H(BasicModelManagerUnit.this.lastResultTable.html));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    };
    public boolean showFilter = true;
    protected LogicalGroup filterCriteria = F.gt.is("do", (Object)-1);
    public boolean showAdd = true;
    public SimplePublish2<BasicModelManagerUnit<B, D>, List<D>> afterResultRendered = null;
    public GetBy1<String, String> translateFieldName;

    public BasicModelManagerUnit(final ClassDescriptor cls, ModelManager<B> acc, ApiClient api) {
        this.cls = cls;
        this.acc = acc;
        this.api = api;
        this.tableGenerator = new ResultTableGenerator();
        this.tableGenerator.getFields = new SimplePublish1<List<ResultTableGenerator.TableField<D>>>(){

            public void publish(List<ResultTableGenerator.TableField<D>> a) {
                ResultTableGenerator.TableField f2 = new ResultTableGenerator.TableField();
                f2.fieldName = "available_operations_column";
                f2.renderLabel = new GetBy1<HTMLElement, ResultTableGenerator.TableField<D>>(){

                    public HTMLElement getBy(ResultTableGenerator.TableField<D> a) {
                        if (BasicModelManagerUnit.this.hasPermission("create") && BasicModelManagerUnit.this.showAdd) {
                            return BasicModelManagerUnit.this.addNewModelButton;
                        }
                        return null;
                    }
                };
                f2.renderField = (x, b, c) -> (HTMLElement)BasicModelManagerUnit.this.generateOperations.getBy((Object)BasicModelManagerUnit.this, BasicModelManagerUnit.this.getPermissions(), (Object)c, b);
                a.add(f2);
                f2 = new ResultTableGenerator.TableField();
                f2.fieldName = "do";
                f2.renderLabel = new GetBy1<HTMLElement, ResultTableGenerator.TableField<D>>(){

                    public HTMLElement getBy(ResultTableGenerator.TableField<D> a) {
                        H ret = new H("div");
                        if (BasicModelManagerUnit.this.showId) {
                            ret.attrs(new String[]{"#text", "id"});
                        }
                        return ret.getHtml();
                    }
                };
                f2.renderField = new GetBy3<HTMLElement, ResultTableGenerator.TableField<D>, TableRow, D>(){

                    public HTMLElement getBy(ResultTableGenerator.TableField<D> a, TableRow b, D c) {
                        String id = String.valueOf(((WebDbModel)((Object)c)).get("do"));
                        H ret = new H("div").attrs(new String[]{"data-name", "do", "data-value", id});
                        if (BasicModelManagerUnit.this.showId) {
                            ret.attrs(new String[]{"#text", id});
                        }
                        return ret.getHtml();
                    }
                };
                a.add(f2);
                List fds = cls.getAllField();
                for (ClassFieldDescriptor fd : fds) {
                    FieldExtraAttributes mfd;
                    if (Boolean.TRUE != BasicModelManagerUnit.this.selectField.getBy((Object)"show", (Object)fd) || !fd.isUserAccessible() || null != (mfd = FieldExtraAttributes.parse(fd)) && !mfd.userMaySee) continue;
                    ResultTableGenerator.TableField add = new ResultTableGenerator.TableField();
                    add.fieldName = fd.getName();
                    add.getExtraDataMap().put("fd", fd);
                    add.renderLabel = f -> {
                        String name = f.fieldName;
                        if (null != BasicModelManagerUnit.this.translateFieldName) {
                            name = (String)BasicModelManagerUnit.this.translateFieldName.getBy((Object)name);
                        }
                        return new H("span").attrs(new String[]{"#text", name}).getHtml();
                    };
                    add.renderField = ModelTableGeneratorTools.DEFAULT_MODEL_FIELD_RENDERER;
                    a.add(add);
                }
            }
        };
    }

    public boolean hasPermission(String perm) {
        return this.getPermissions().contains(perm);
    }

    public Set<String> getPermissions() {
        if (null == this.perms) {
            this.perms = this.acc.getPermissions();
        }
        return this.perms;
    }

    protected D createNewModel() {
        try {
            return (D)((Object)((WebDbModel)this.acc.createModel(this.cls)));
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public void popupAddNewModel() {
        this.popupWithDataAndTrigger("jvx-new-model-form", null, this.createNewModel(), (String)this.txtCreateNew.getBy((Object)this.cls.getClassName()), new SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>>(){

            public void publish(DataObject data, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>> b) {
                ValidationResult ret = BasicModelManagerUnit.this.acc.create(BasicModelManagerUnit.this.cls, data);
                b.publish((Object)ret);
            }
        });
    }

    public void popupConfirmDelete(final D model, final TableRow row) {
        final H content = H.H((String)"div");
        content.addChilds(new H[]{new H("div").attrs(new String[]{"#text", (String)this.txtOp.getBy((Object)"delete", model)})});
        H header = H.H((String)"h4");
        header.attrs(new String[]{"#text", (String)this.translate.getBy((Object)"title_confirm_deletion")});
        H footer = H.H((String)"div");
        footer.addChilds(new HTMLElement[]{TbsTools.createModalCloseButton((String)((String)this.translate.getBy((Object)"btn_cancel")))});
        footer.addChilds(new H[]{H.H((String)"button").attrs(new String[]{"class", "op_delete", "#text", (String)this.translate.getBy((Object)"btn_delete")}).style(new StyleDecoratorSource[]{TbsStyle.BTN_DANGER})});
        VanillaTools.bindListenerToArea((HTMLElement)footer.getHtml(), (String)"click", (String)".op_delete", (EventListener)FrontendTools.wrapProcessEventWithThread((EventListener)new EventListener<Event>(){

            public void handleEvent(Event a) {
                ValidationResult ret = BasicModelManagerUnit.this.acc.delete(BasicModelManagerUnit.this.cls, ((Long)CastTo.Long.cast(model.get("do"))).longValue(), null);
                if (ret.valid) {
                    TbsTools.closeModal((HTMLElement)content.getHtml());
                    VanillaTools.remove((Element)row.getHtml());
                } else {
                    TbsTools.modalMessage((String)((String)BasicModelManagerUnit.this.translate.getBy((Object)"op_deletion_failed")), (String)FrontendTools.renderMessages((Collection)ret.reportEntries));
                }
            }
        }));
        TbsTools.modal((HTMLElement)header.getHtml(), (HTMLElement)content.getHtml(), (HTMLElement)footer.getHtml());
    }

    public void popupEdit(final D model, final TableRow row) {
        this.popupWithDataAndTrigger("jvx-edit-model-form", (Map<String, String>)new OneShotMap((Object)"do", (Object)((WebDbModel)((Object)model)).get("do").toString()), model, (String)this.txtOp.getBy((Object)"modify", model), new SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>>(){

            public void publish(DataObject data, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>> b) {
                ValidationResult a = BasicModelManagerUnit.this.acc.update(BasicModelManagerUnit.this.cls, data);
                if (a.valid) {
                    DataReprezTools.copyInto((ModifiableObject)model, (ObjectWithProperty)data);
                    model.set("lastModify", System.currentTimeMillis());
                    ResultTableGenerator.updateRow((List)BasicModelManagerUnit.this.lastResultTable.fields, (TableRow)row, (Object)((Object)model));
                }
                b.publish((Object)a);
            }
        });
    }

    protected void popupWithDataAndTrigger(String extraCss, Map<String, String> extraAttributes, D model, String title, final SimplePublish2<DataObject, SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>> onSave) {
        final H content = H.H((String)"div");
        if (null != extraCss) {
            content.attrs(new String[]{"class", extraCss});
        }
        PublisherBuilder builder = TbsLayoutTools.buildForm();
        builder.initialize(null);
        if (null != extraAttributes) {
            for (Map.Entry<String, String> kv : extraAttributes.entrySet()) {
                builder.publish((Object)new TbsLayoutTools.SimpleFormRow(null, null, H.H((String)"input").attrs(new String[]{"type", "hidden", "name", kv.getKey(), "value", kv.getValue()}).getHtml()));
            }
        }
        FrontendFieldEditContext ctx = new FrontendFieldEditContext();
        ctx.acc = this.acc;
        ctx.api = this.api;
        ctx.gdb = GenericStorage.getOwnerDatabase(model);
        ctx.model = model;
        ArrayList<ClassFieldDescriptor> fields = new ArrayList<ClassFieldDescriptor>();
        for (ClassFieldDescriptor f : this.cls.getAllField()) {
            if (Boolean.TRUE != this.selectField.getBy((Object)"update", (Object)f)) continue;
            fields.add(f);
        }
        WebGsdbTools.generateModelEditor((SimplePublish1<TbsLayoutTools.SimpleFormRow>)builder, fields, (GetBy1<String, ClassFieldDescriptor>)(null == this.translateFieldName ? fd -> fd.getTranslationSymbol() : fd -> (String)this.translateFieldName.getBy((Object)fd.getName())), model, ctx);
        content.addChilds(new HTMLElement[]{(HTMLElement)builder.getResult()});
        H header = H.H((String)"h4");
        header.attrs(new String[]{"#text", title});
        H footer = H.H((String)"div");
        footer.addChilds(new HTMLElement[]{TbsTools.createModalCloseButton((String)((String)this.translate.getBy((Object)"btn_close")))});
        footer.addChilds(new H[]{H.H((String)"button").attrs(new String[]{"class", "op_save", "#text", (String)this.translate.getBy((Object)"btn_save")}).style(new StyleDecoratorSource[]{TbsStyle.BTN_SUCCESS})});
        VanillaTools.bindListenerToArea((HTMLElement)footer.getHtml(), (String)"click", (String)".op_save", (EventListener)FrontendTools.wrapProcessEventWithThread((EventListener)new EventListener<Event>(){

            public void handleEvent(Event a) {
                DataObject data = FrontendTools.serializeInputsInArea((HTMLElement)content.getHtml());
                onSave.publish((Object)data, (Object)new SimplePublish1<ValidationResult<LanguageTranslatableValidationEntry>>(){

                    public void publish(ValidationResult<LanguageTranslatableValidationEntry> a) {
                        if (a.valid) {
                            TbsTools.closeModal((HTMLElement)content.getHtml());
                        } else {
                            Window.alert((String)"error");
                        }
                    }
                });
            }
        }));
        TbsTools.modal((HTMLElement)header.getHtml(), (HTMLElement)content.getHtml(), (HTMLElement)footer.getHtml());
    }

    protected GeneratedResultTable<D> renderTable(Iterable<D> arr) {
        GeneratedResultTable ret = this.tableGenerator.generate((TableStructureManager)SimpleTableStructureManager.INSTANCE, arr);
        VanillaTools.ClassList cl = VanillaTools.getClassList((HTMLElement)ret.html);
        cl.add("table");
        cl.add("table-hover");
        cl.add("table-striped");
        cl.add("table-responsive");
        return ret;
    }

    public void resetFilterCriteria(boolean apply) {
        this.setFilterCriteria(F.gt.is("do", (Object)-1), apply);
    }

    public void setFilterCriteria(LogicalGroup lg, boolean apply) {
        this.filterCriteria = lg;
        if (apply) {
            this.refresh();
        }
    }

    public LogicalGroup getFilterCriteria() {
        return this.filterCriteria;
    }

    public void refresh() {
        this.loadWithFilters(this.filterCriteria);
    }

    protected void loadWithFilters(LogicalGroup lg) {
        FrontendTools.runOnThread(() -> {
            this.init();
            try {
                List res = this.acc.select(this.cls, lg);
                this.reRenderTable.publish((Object)res);
                if (null != this.afterResultRendered) {
                    this.afterResultRendered.publish((Object)this, (Object)res);
                }
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        });
    }

    public void reset() {
        this.container = null;
    }

    public void init() {
        if (null != this.container) {
            return;
        }
        this.filterBox = new H("div").addChilds(new HTMLElement[]{!this.showFilter ? null : new H("button").style(new StyleDecoratorSource[]{TbsGlyph.REFRESH, TbsStyle.BTN_DEFAULT, StyleTools.StyleAlaCarte.FS_1, StyleTools.StyleAlaCarte.MARGIN_1}).onClick(e -> this.refresh()).getHtml()}).getHtml();
        this.container = null;
        this.container = new H("div").addChilds(new HTMLElement[]{this.filterBox, this.resultTableBox}).getHtml();
    }

    public Object getImpersonator() {
        return this;
    }

    public Element getHtml() {
        if (null == this.container) {
            this.init();
        }
        return this.container;
    }

    public static BasicModelManagerUnit createEditorForClass(ApiClient api, String namespace, String cls) {
        return BasicModelManagerUnit.createEditorForClass(ModelEditPage.createModelManager(api, namespace), api, cls);
    }

    public static BasicModelManagerUnit createEditorForClass(DinamicModelManager modelManager, ApiClient api, String cls) {
        List models = modelManager.getManagedModels();
        for (ClassDescriptor model : models) {
            if (!model.getClassName().equals(cls)) continue;
            return new BasicModelManagerUnit(model, modelManager, api);
        }
        throw new RuntimeException("No manager class found with name: " + cls);
    }

    public void setContent(H content) {
        this.resultTableBox.clear();
        new H(this.resultTableBox).addChilds(new H[]{content});
    }

    public ModelManager<B> getDatabase() {
        return this.acc;
    }

    static {
        if (!TeaVmTools.IS_FRONTEND) {
            HtmlDataContainer c = HtmlDataContainerTools.browserDatetimeLocal(null);
            c.setData((Object)"");
        }
        CUSTOM_FIELD_NAME = new GetBy1<HTMLElement, ResultTableGenerator.TableField>(){

            public HTMLElement getBy(ResultTableGenerator.TableField a) {
                ClassFieldDescriptor fd = (ClassFieldDescriptor)a.getExtraDataMap().get("fd");
                String text = "-";
                if (null != fd) {
                    text = fd.getTranslationSymbol();
                    text = WebGsdbTools.translate(text);
                }
                return new H("span").attrs(new String[]{"#text", text}).getHtml();
            }
        };
    }
}

