package eu.javaexperience.gsdbrpc;

import eu.javaexperience.query.LogicalGroup;

import java.util.List;

import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.client.JvxClientException;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.ValidationResult;
import eu.jvx.js.lib.TeaVmTools;
import eu.teasite.frontend.api.ApiClient;
import eu.teasite.frontend.api.ApiClientTools;
import eu.javaexperience.webgsdb.frontend.GenericModelManagementApi;

//add result table generator 
public class ServerModellAccess extends SynchronServerModelAccess
{
	protected GenericModelManagementApi api;
	protected String namespace;
	
	public ServerModellAccess(ApiClient cli, String namespace)
	{
		this(cli.getApiClass(GenericModelManagementApi.class, namespace));
	}
	
	protected ServerModellAccess(GenericModelManagementApi api)
	{
		super(api, DataObjectTeaVMImpl.INSTANCE);
		this.api = api;
	}
	
	public GenericModelManagementApi getGmmApi()
	{
		return api;
	}
	
	public static <T> SimplePublish2<T, JvxClientException> wrap(final SimplePublish1<T> callback)
	{
		return new SimplePublish2<T, JvxClientException>()
		{
			@Override
			public void publish(T a, JvxClientException b)
			{
				if(TeaVmTools.tryManageApiError(a, b))
				{
					return;
				}
				callback.publish(a);
			}
		};
	}
	
	public static final GetBy1<ValidationResult<TranslationFriendlyValidationEntry>, DataObject> PARSE_VALIDATION_RESULT = new GetBy1<ValidationResult<TranslationFriendlyValidationEntry>, DataObject>()
	{
		@Override
		public ValidationResult<TranslationFriendlyValidationEntry> getBy(DataObject a)
		{
			return parseValidationResult(a);
		}
	};
	
	public <D extends RpcDbModel> void getById(final SimplePublish2<D, JvxClientException> callback, final Class<D> cls, long id) throws Throwable
	{
		api.getById(ApiClientTools.createWrapperReceiver(callback, createModelWrapper(cls)), cls.getSimpleName(), id);
	}
	
	public <D extends RpcDbModel> void getById(final SimplePublish1<D> callback, final Class<D> cls, long id) throws Throwable
	{
		getById(wrap(callback), cls, id);
	}
	
	public <D extends RpcDbModel> D getById(final Class<D> cls, long id) throws Throwable
	{
		return createModelWrapper(cls).getBy(api.getById(cls.getSimpleName(), id));
	}
	
	public <D extends RpcDbModel> void update(SimplePublish2<ValidationResult<TranslationFriendlyValidationEntry>, JvxClientException> callback, Class<D> cls, DataObject obj)
	{
		api.update(ApiClientTools.createWrapperReceiver(callback, PARSE_VALIDATION_RESULT), cls.getSimpleName(), obj);
	}
	
	public <D extends RpcDbModel> void update(SimplePublish1<ValidationResult<TranslationFriendlyValidationEntry>> callback, Class<D> cls, DataObject obj)
	{
		update(wrap(callback), cls, obj);
	}
	
	public <D extends RpcDbModel> void create(SimplePublish2<ValidationResult<TranslationFriendlyValidationEntry>, JvxClientException> callback, Class<D> cls, DataObject obj)
	{
		api.create(ApiClientTools.createWrapperReceiver(callback, PARSE_VALIDATION_RESULT), cls.getSimpleName(), obj);
	}
	
	public <D extends RpcDbModel> void create(SimplePublish1<ValidationResult<TranslationFriendlyValidationEntry>> callback, Class<D> cls, DataObject obj)
	{
		create(wrap(callback), cls, obj);
	}
	
	//TODO limit offset, order
	public <D extends RpcDbModel> void select(SimplePublish2<List<D>, JvxClientException> callback, Class<D> cls, LogicalGroup criteria)
	{
		api.select(ApiClientTools.createWrapperReceiver(callback, createModelsWrapper(cls)), cls.getSimpleName(), RemoteGsdbTools.serialize(criteria, DataObjectTeaVMImpl.INSTANCE), null);
	}
	
	public <D extends RpcDbModel> void select(SimplePublish1<List<D>> callback, Class<D> cls, LogicalGroup criteria)
	{
		select(wrap(callback), cls, criteria);
	}
	
	public <D extends RpcDbModel> void delete(SimplePublish2<ValidationResult<TranslationFriendlyValidationEntry>, JvxClientException> callback, Class<D> cls, long id, DataObject deleteInstruction)
	{
		api.delete(ApiClientTools.createWrapperReceiver(callback, PARSE_VALIDATION_RESULT), cls.getSimpleName(), id, deleteInstruction);
	}
	
	public <D extends RpcDbModel> void delete(SimplePublish1<ValidationResult<TranslationFriendlyValidationEntry>> callback, Class<D> cls, long id, DataObject deleteInstruction)
	{
		delete(wrap(callback), cls, id, deleteInstruction);
	}
	
	public void getManagedModels(SimplePublish2<String[], JvxClientException> callback)
	{
		api.getManagedModels
		(
			new SimplePublish2<DataArray, JvxClientException>()
			{
				@Override
				public void publish(DataArray a, JvxClientException b)
				{
					try
					{
						DataArray arr = a;
						String[] pub = new String[arr.size()];
						for(int i=0;i<pub.length;++i)
						{
							pub[i] = arr.getString(i);
						}
						
						callback.publish(pub, b);
					}
					catch (Exception e)
					{
						Mirror.propagateAnyway(e);
					}
				}
			}
		);
	}
	
	public void getManagedModels(SimplePublish1<String[]> callback)
	{
		getManagedModels(wrap(callback));
	}
}