/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.saac;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.javaexperience.text.StringTools;
import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.ui.FrontendTools;
import eu.jvx.js.lib.ui.component.func.HtmlDataContainer;
import eu.jvx.saac.SaacApi;
import eu.jvx.saac.SaacEditor;
import org.teavm.jso.JSObject;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.json.JSON;

public class SaacEditorTools {
    public static SaacEditor.SaacConfig createSimpleEmbeddedConfig(SaacApi api, String fixture, Integer fixtureIndex) {
        SaacEditor.SaacConfig config = new SaacEditor.SaacConfig();
        config.api = api;
        config.embedConsole = false;
        if (null != fixture && null != fixtureIndex) {
            config.rootType = new SaacEditor.SaacRootType(fixture, fixtureIndex);
        }
        SaacEditor.SaacMenuVisiblity show = config.show;
        show.browser = false;
        show.console = false;
        show.execute = false;
        show.save = false;
        return config;
    }

    public static HtmlDataContainer<String> createEmbeddedContainer(String fieldName, SaacApi api, String fixture, Integer fixtureIndex, Object value) {
        return (HtmlDataContainer)SaacEditorTools.createEmbeddedContainerKv(fieldName, api, fixture, fixtureIndex, value).getKey();
    }

    public static KeyVal<HtmlDataContainer<String>, SaacEditor> createEmbeddedContainerKv(String fieldName, SaacApi api, String fixture, Integer fixtureIndex, final Object value) {
        final HTMLElement container = new H("div").getHtml();
        final SaacEditor editor = SaacEditor.saac_createEntryPoint(container, SaacEditorTools.createSimpleEmbeddedConfig(api, fixture, fixtureIndex));
        final HtmlDataContainer<String> ret = new HtmlDataContainer<String>(){

            @Override
            protected HTMLElement construct() {
                return container;
            }

            @Override
            public String getData() {
                return JSON.stringify((JSObject)((JSObject)editor.serialize().getImpl()));
            }

            @Override
            public void setData(String data) {
                try {
                    if (StringTools.isNullOrTrimEmpty((String)data)) {
                        return;
                    }
                    editor.saac_restore_function((DataObject)new DataObjectTeaVMImpl(JSON.parse((String)data)));
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormatException((Logger)FrontendTools.LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Error while restore function editor state ine SaacEditorTools");
                }
            }
        };
        editor.ensureInitalized(new SimplePublish1<SaacEditor>(){

            public void publish(SaacEditor a) {
                String val;
                if (null != value && null != (val = (String)value) && val.length() > 0) {
                    try {
                        ret.setData(val);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
        if (null != fieldName) {
            ImpTools.appendImp(FrontendTools.addHiddenSerializer(fieldName, container, ret), ret);
        }
        return new KeyVal((Object)ret, (Object)editor);
    }
}

