/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.teasite.frontend.table;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.ExternalDataAttached;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.teasite.frontend.table.GeneratedResultTable;
import eu.jvx.js.lib.ui.component.table.Table;
import eu.jvx.js.lib.ui.component.table.TableRow;
import eu.jvx.js.lib.ui.component.table.TableStructureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;

public class ResultTableGenerator<E> {
    public SimplePublish1<List<TableField<E>>> getFields;
    public static final GetBy1<GetBy1<HTMLElement, TableField>, TableField> RENDERER_GETTER_BEFORE_HEADER = tf -> tf.renderBeforeHeader;
    public static final GetBy1<GetBy1<HTMLElement, TableField>, TableField> RENDERER_GETTER_LABEL = tf -> tf.renderLabel;
    public static final GetBy1<GetBy1<HTMLElement, TableField>, TableField> RENDERER_GETTER_VERY_FRIST = tf -> tf.renderVeryFirst;
    public static final GetBy1<GetBy1<HTMLElement, TableField>, TableField> RENDERER_GETTER_LAST = tf -> tf.renderLast;

    public GeneratedResultTable<E> generate(TableStructureManager tsm, Iterable<E> elements) {
        Table table = new Table(tsm);
        ArrayList fds = new ArrayList();
        this.getFields.publish(fds);
        ArrayList<String> fields = new ArrayList<String>();
        for (TableField tableField : fds) {
            fields.add(tableField.fieldName);
        }
        table.registerSimpleRowConfig("row", fields.toArray(Mirror.emptyStringArray));
        this.renderRowWithGenerator(table, fds, RENDERER_GETTER_BEFORE_HEADER);
        this.renderRowWithGenerator(table, fds, RENDERER_GETTER_LABEL);
        this.renderRowWithGenerator(table, fds, RENDERER_GETTER_VERY_FRIST);
        for (Object elem : elements) {
            System.out.println("current element: " + elem);
            TableRow tableRow = table.createRow("row");
            for (TableField fd : fds) {
                HTMLElement add;
                if (null == fd.renderField || null == (add = (HTMLElement)fd.renderField.getBy(fd, (Object)tableRow, elem))) continue;
                String key = fd.fieldName;
                tableRow.getCellByName(key).getHtml().appendChild((Node)add);
            }
        }
        this.renderRowWithGenerator(table, fds, RENDERER_GETTER_LAST);
        GeneratedResultTable ret = new GeneratedResultTable();
        ret.fields = fds;
        ret.generator = this;
        ret.dataSet = elements;
        ret.table = table;
        ret.html = table.getHtml();
        return ret;
    }

    protected void renderRowWithGenerator(Table table, List<TableField<E>> fds, GetBy1<GetBy1<HTMLElement, TableField>, TableField> rendererGetter) {
        boolean doRender = false;
        for (TableField<E> s : fds) {
            if (null == rendererGetter.getBy(s)) continue;
            doRender = true;
            break;
        }
        if (doRender) {
            TableRow head = table.createRow("row");
            for (TableField<E> s : fds) {
                HTMLElement add;
                GetBy1 render = (GetBy1)rendererGetter.getBy(s);
                if (null == render || null == (add = (HTMLElement)render.getBy(s))) continue;
                head.getCellByName(s.fieldName).getHtml().appendChild((Node)add);
            }
        }
    }

    public static class TableField<E>
    implements ExternalDataAttached {
        public String fieldName;
        public GetBy1<HTMLElement, TableField<E>> renderBeforeHeader;
        public GetBy1<HTMLElement, TableField<E>> renderLabel;
        public GetBy1<HTMLElement, TableField<E>> renderVeryFirst;
        public GetBy3<HTMLElement, TableField<E>, TableRow, E> renderField;
        public GetBy1<HTMLElement, TableField<E>> renderLast;
        protected Map<String, Object> extraData;

        public Map<String, Object> getExtraDataMap() {
            if (null == this.extraData) {
                this.extraData = new SmallMap();
            }
            return this.extraData;
        }
    }
}

