/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.bindings;

import eu.javaexperience.text.StringTools;
import eu.jvx.js.lib.NativeJsSupport;
import eu.jvx.js.lib.resource.FrontendResourceTools;
import eu.jvx.js.lib.teavm.NativeJsSupportTeaVM;
import eu.jvx.js.lib.ui.style.CssStyleSheet;
import java.util.Collection;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSIndexer;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.browser.Window;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.dom.html.HTMLSelectElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;

public class VanillaTools {
    protected static CssStyleSheet sheet;

    public static HTMLElement inlineCreateElement(String nodeName, String ... attrs) {
        HTMLElement ret = Window.current().getDocument().createElement(nodeName);
        VanillaTools.stringAttrs(ret, attrs);
        return ret;
    }

    public static HTMLElement stringAttrs(HTMLElement ret, String ... attrs) {
        for (int i = 0; i < attrs.length; i += 2) {
            String key = attrs[i];
            String value = attrs[i + 1];
            if (null == key || null == value) continue;
            VanillaTools.stringAttrs(ret, key, value);
        }
        return ret;
    }

    public static HTMLElement stringAttrs(HTMLElement ret, String key, String value) {
        if (null == key || null == value) {
            return ret;
        }
        if ("#text".equals(key)) {
            NativeJsSupport.getSupport().setProp(ret, "innerText", value);
        } else if ("#html".equals(key)) {
            ret.setInnerHTML(value);
        } else if ("style".equals(key)) {
            ret.getStyle().setCssText(value);
        } else {
            ret.setAttribute(key, value);
        }
        return ret;
    }

    public static void setContent(HTMLElement vn, String val) {
        switch (vn.getNodeName()) {
            case "OPTION": 
            case "TEXTAREA": 
            case "INPUT": {
                if ("checkbox".equals(vn.getAttribute("type"))) {
                    return;
                }
                ((HTMLInputElement)vn).setValue(val);
            }
        }
        vn.setInnerHTML(val);
    }

    public static HTMLElement appendChilds(HTMLElement subject, HTMLElement ... elems) {
        for (int i = 0; i < elems.length; ++i) {
            HTMLElement el = elems[i];
            if (null == el) continue;
            subject.appendChild((Node)el);
        }
        return subject;
    }

    public static String getContent(HTMLElement vn) {
        switch (vn.getNodeName()) {
            case "SELECT": {
                HTMLSelectElement sel = (HTMLSelectElement)vn;
                int index = sel.getSelectedIndex();
                if (index < 0) {
                    return null;
                }
                return VanillaTools.getContent((HTMLElement)sel.getOptions().get(index));
            }
            case "OPTION": 
            case "TEXTAREA": 
            case "INPUT": {
                if ("checkbox".equals(vn.getAttribute("type"))) {
                    return ((HTMLInputElement)vn).isChecked() ? "true" : "false";
                }
                return ((HTMLInputElement)vn).getValue();
            }
        }
        return vn.getInnerHTML();
    }

    public static int index(HTMLElement node) {
        Node p = node.getParentNode();
        if (null != p) {
            JSArray<HTMLElement> children = VanillaTools.getChildren((HTMLElement)p);
            int num = 0;
            for (int i = 0; i < children.getLength(); ++i) {
                Node c = (Node)children.get(i);
                if (node == c) {
                    return num;
                }
                if (c.getNodeType() != 1) continue;
                ++num;
            }
        }
        return -1;
    }

    public static void remove(Element elem) {
        Node parent = elem.getParentNode();
        if (null != parent) {
            parent.removeChild((Node)elem);
        }
    }

    public static HTMLDocument getDom() {
        return Window.current().getDocument();
    }

    public static boolean is(HTMLElement elem, String selector) {
        return ((Matches)elem).matches(selector);
    }

    public static HTMLElement whereParent(HTMLElement elem, String selector) {
        for (elem = (HTMLElement)elem.getParentNode(); null != elem; elem = (HTMLElement)elem.getParentNode()) {
            if (!VanillaTools.is(elem, selector)) continue;
            return elem;
        }
        return null;
    }

    public static HTMLElement whereParentOrThis(HTMLElement elem, String selector) {
        while (null != elem) {
            if (VanillaTools.is(elem, selector)) {
                return elem;
            }
            elem = (HTMLElement)elem.getParentNode();
        }
        return null;
    }

    public static HTMLElement getNeightbor(HTMLElement from, String borderSelector, String targetSelector) {
        HTMLElement p = VanillaTools.whereParent(from, borderSelector);
        if (null == p) {
            return p;
        }
        return p.querySelector(targetSelector);
    }

    public static void copyToClipboard(String txt) {
        HTMLDocument document = Window.current().getDocument();
        HTMLElement elem = VanillaTools.inlineCreateElement("textarea", new String[0]);
        ((EtcNodeSupport)elem).setInnerText(txt);
        document.getBody().appendChild((Node)elem);
        ((EtcNodeSupport)elem).select();
        ((EtcNodeSupport)document).execCommand("copy");
        VanillaTools.remove((Element)elem);
    }

    public static HTMLElement alterTag(HTMLElement f_ac, String string) {
        return null;
    }

    public static HTMLElement whereParentWithBoundary(HTMLElement start, String selector, String boundary) {
        for (HTMLElement elem = (HTMLElement)start.getParentNode(); null != elem; elem = (HTMLElement)elem.getParentNode()) {
            if (VanillaTools.is(elem, selector)) {
                return elem;
            }
            if (!VanillaTools.is(elem, boundary)) continue;
            return null;
        }
        return null;
    }

    public static void setInnerText(HTMLElement elem, String content) {
        ((EtcNodeSupport)elem).setInnerText(content);
    }

    public static ClassList getClassList(HTMLElement elem) {
        return (ClassList)NativeJsSupport.getSupport().getProp(elem, "classList");
    }

    public static int getChildElementCount(HTMLElement elem) {
        JSArray<HTMLElement> nodes = VanillaTools.getChildren(elem);
        int count = 0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (1 != ((HTMLElement)nodes.get(i)).getNodeType()) continue;
            ++count;
        }
        return count;
    }

    public static JSArray<HTMLElement> getChildren(HTMLElement elem) {
        return ((EtcNodeSupport)elem).getChildren();
    }

    public static JSArray<HTMLElement> getChildNodes(HTMLElement elem) {
        return ((EtcNodeSupport)elem).getChildNodes();
    }

    public static HTMLElement parseHtml(String txt) {
        HTMLElement wrapper = VanillaTools.inlineCreateElement("div", new String[0]);
        wrapper.setInnerHTML(txt);
        return (HTMLElement)VanillaTools.getChildren(wrapper).get(0);
    }

    public static String getInnerText(HTMLElement elem) {
        return ((EtcNodeSupport)elem).getInnerText();
    }

    public static int getSelectionStart(HTMLElement elem) {
        return ((EtcNodeSupport)elem).getSelectionStart();
    }

    public static int getSelectionEnd(HTMLElement elem) {
        return ((EtcNodeSupport)elem).getSelectionEnd();
    }

    public static void changeClass(HTMLElement elem, String c1, String c2) {
        ClassList clist = VanillaTools.getClassList(elem);
        boolean h1 = clist.contains(c1);
        boolean h2 = clist.contains(c2);
        if (!h1 && !h2) {
            clist.add(c1);
        } else if (h1 && h2) {
            clist.remove(c2);
        } else if (h1) {
            clist.remove(c1);
            clist.add(c2);
        } else {
            clist.remove(c2);
            clist.add(c1);
        }
    }

    public static void copyTo(NodeList<? extends HTMLElement> els, Collection<HTMLElement> dst) {
        for (int i = 0; i < els.getLength(); ++i) {
            dst.add((HTMLElement)els.get(i));
        }
    }

    public static HTMLElement getActiveElement() {
        return ((EtcNodeSupport)Window.current().getDocument()).getActiveElement();
    }

    public static void addToHeader(HTMLElement elem) {
        FrontendResourceTools.getOrCreateHead().appendChild((Node)elem);
    }

    public static void addCssRule(String rule) {
        sheet.insertRule(rule, sheet.getLength());
    }

    public static void addCssRules(String ... rule) {
        for (String s : rule) {
            VanillaTools.addCssRule(s);
        }
    }

    public static void bindListenerToArea(HTMLElement area, String eventType, final String targetElementIs, final EventListener<Event> action) {
        area.addEventListener(eventType, (EventListener)new EventListener<Event>(){

            public void handleEvent(Event event) {
                if (VanillaTools.is((HTMLElement)event.getTarget(), targetElementIs)) {
                    action.handleEvent(event);
                }
            }
        });
    }

    public static boolean isDetached(HTMLElement container) {
        return false;
    }

    public static DataSet getDataSet(HTMLElement root) {
        return (DataSet)((NativeJsSupportTeaVM.Direct)root).rawGet("dataset");
    }

    public static void insertBefore(HTMLElement relativeTo, HTMLElement add) {
        ((EtcNodeSupport)relativeTo.getParentNode()).insertBefore(add, relativeTo);
    }

    public static void replaceTo(HTMLElement e, HTMLElement set) {
        if (e == set) {
            return;
        }
        HTMLElement p = (HTMLElement)e.getParentNode();
        p.replaceChild((Node)set, (Node)e);
    }

    public static void removeAllChild(HTMLElement root) {
        Node ch;
        while (null != (ch = root.getFirstChild())) {
            root.removeChild(ch);
        }
    }

    public static boolean isHtmlElement(HTMLElement elem) {
        return 1 == elem.getNodeType();
    }

    public static String getDomCssReprez(HTMLElement elem) {
        String cls;
        String ret = ((EtcNodeSupport)elem).getTagName();
        ret = ret.toLowerCase();
        String id = elem.getAttribute("id");
        if (null != id) {
            ret = ret + "#" + id;
        }
        if (null != (cls = elem.getClassName()) && cls.length() > 0) {
            ret = ret + "." + StringTools.replaceAllStrings((String)cls, (String)" ", (String)".");
        }
        return ret;
    }

    public static String getDomPath(HTMLElement elem) {
        String cc;
        if (null == elem || elem == VanillaTools.getDom()) {
            return null;
        }
        String ret = VanillaTools.getDomCssReprez(elem);
        HTMLElement par = (HTMLElement)elem.getParentNode();
        if (null != par && null != (cc = VanillaTools.getDomPath(par))) {
            return cc + " > " + ret;
        }
        return ret;
    }

    static {
        HTMLElement style = VanillaTools.inlineCreateElement("style", new String[0]);
        style.appendChild((Node)Window.current().getDocument().createTextNode(""));
        FrontendResourceTools.getOrCreateHead().appendChild((Node)style);
        sheet = ((EtcNodeSupport)style).getSheet();
    }

    public static interface DataSet
    extends JSObject {
        @JSBody(params={"key"}, script="var ret = this[key]; if(undefined == ret) return null; return ret;")
        public String get(String var1);

        @JSIndexer
        public void put(String var1, String var2);
    }

    public static abstract class ClassList
    implements JSObject {
        public abstract boolean contains(String var1);

        public abstract void add(String var1);

        public abstract void remove(String var1);
    }

    public static abstract class EtcNodeSupport
    implements JSObject {
        @JSProperty
        public abstract String getTagName();

        @JSProperty
        public abstract void setInnerText(String var1);

        @JSProperty
        public abstract String getInnerText();

        public abstract void select();

        public abstract void execCommand(String var1);

        @JSProperty
        public abstract JSArray<HTMLElement> getChildren();

        @JSProperty
        public abstract int getSelectionEnd();

        @JSProperty
        public abstract int getSelectionStart();

        @JSProperty
        public abstract HTMLElement getActiveElement();

        @JSProperty
        public abstract JSArray<HTMLElement> getChildNodes();

        @JSProperty
        public abstract CssStyleSheet getSheet();

        @JSProperty
        public abstract JSObject getDetail();

        public abstract void insertBefore(HTMLElement var1, HTMLElement var2);
    }

    protected static abstract class Matches
    implements JSObject {
        protected Matches() {
        }

        @JSBody(params={"selector"}, script="return this.matches(selector);")
        public abstract boolean matches(String var1);
    }
}

