/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.ui;

import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.tbs.TbsWeightEntry;
import java.util.HashMap;
import java.util.Map;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;

public class MultiBar
implements ImpersonalisedHtml {
    protected HTMLElement htmlRoot;
    protected Map<String, HTMLElement> bars = new HashMap<String, HTMLElement>();
    protected Map<String, TbsWeightEntry> extraInfo = new HashMap<String, TbsWeightEntry>();

    public MultiBar(TbsWeightEntry ... arguments) {
        this.htmlRoot = VanillaTools.inlineCreateElement("div", "class", "progress");
        ImpTools.appendImp(this.htmlRoot, this);
        for (int i = 0; i < arguments.length; ++i) {
            TbsWeightEntry a = arguments[i];
            HTMLElement vn = MultiBar.createBar(a.weight.getCssName());
            this.extraInfo.put(a.id, a);
            this.bars.put(a.id, vn);
            this.htmlRoot.appendChild((Node)vn);
        }
    }

    public void updatePercentById(Map<String, Double> vals) {
        for (String id : vals.keySet()) {
            HTMLElement vn = this.bars.get(id);
            if (null == vn) continue;
            double val = vals.get(id) * 100.0;
            vn.getStyle().setProperty("width", val + "%");
        }
    }

    public void updateLabelsById(Map<String, String> vals) {
        for (String id : vals.keySet()) {
            HTMLElement vn = this.bars.get(id);
            if (null == vn) continue;
            VanillaTools.setContent(vn, vals.get(id));
        }
    }

    public void setAnimation() {
    }

    protected static final HTMLElement createBar(String label) {
        return VanillaTools.inlineCreateElement("div", "class", "progress-bar progress-bar-" + label, "role", "progressbar", "aria-valuemin", "0", "aria-valuemax", "100");
    }

    @Override
    public Object getImpersonator() {
        return this;
    }

    public HTMLElement getHtml() {
        return this.htmlRoot;
    }
}

