/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.teavm.templatesite;

import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.fs.os.OsFile;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.patterns.behavioral.cor.CorDispatcher;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.rpc.JavaClassRpcCollector;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcSessionTools;
import eu.javaexperience.rpc.RpcTools;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.web.RpcUrlNode;
import eu.javaexperience.teavm.templatesite.TeaVmTemplateWebsiteBuilder;
import eu.javaexperience.teavm.templatesite.TeaVmUrlNode;
import eu.javaexperience.teavm.templatesite.common.PageId;
import eu.javaexperience.teavm.templatesite.common.PageStorage;
import eu.javaexperience.teavm.templatesite.frontend.PageStarter;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.TemplateWebsiteServer;
import eu.javaexperience.web.dispatch.DefaultDispatchStructure;
import eu.javaexperience.web.dispatch.url.PreparedURL;
import eu.javaexperience.web.dom.build.WebSoftwareBundle;
import eu.javaexperience.web.facility.SiteFacility;
import eu.javaexperience.web.facility.SiteFacilityTools;
import eu.javaexperience.web.service.hooks.ServiceProcessHooks;
import eu.javaexperience.web.template.TemplateManager;
import eu.jvx.js.lib.activity.StartablePageId;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class TeaVmTemplateWebsite
extends TemplateWebsiteServer {
    protected final List<String> lCss;
    protected final List<String> lPreJs;
    protected final List<String> lPostJs;
    protected final TeaVmUrlNode teavm;
    protected final String baseURL;
    protected final PageStorage<? extends StartablePageId> pageProvider;
    protected final boolean production;
    protected HashMap<PageId, String> pageMapping = new HashMap();
    protected RpcUrlNode<SimpleRpcRequest, SimpleRpcSession> api;
    protected GetBy1<SiteFacility.SiteObjectSettings, SiteFacility.SiteObjectSettings> configModifier;
    protected GetBy1<IOStreamServer, Object> serverSocketCreator;
    protected boolean usePathDispatch = false;
    protected GetBy1<String, String> siteScriptUrlProcessor;

    protected SiteFacility.SiteObjectSettings generateConfiguration() {
        if (null != this.configModifier) {
            return (SiteFacility.SiteObjectSettings)this.configModifier.getBy((Object)super.generateConfiguration());
        }
        return super.generateConfiguration();
    }

    public void registerApis(RpcFacility<? extends RpcRequest>[] apis) {
        this.api = RpcUrlNode.createSimple((String)"site_api", (String)"", apis);
    }

    public TeaVmTemplateWebsite(TeaVmTemplateWebsiteBuilder builder) throws IOException {
        this(builder.siteName, builder.production, builder.pageProvider, builder.cls, builder.sws, builder.apis, null != builder.tmpDir ? builder.tmpDir : "/tmp/" + builder.siteName + "/", builder.scriptFile, builder.baseUrl, builder.siteScriptUrlProcessor, builder.configModifier, builder.hookModifier, builder.serverSocketCreator);
    }

    public TeaVmTemplateWebsite(String siteName, boolean production, PageStorage<? extends StartablePageId> pageProvider, Class<? extends PageStarter> cls, WebSoftwareBundle[] sws, RpcFacility<? extends RpcRequest>[] apis) throws IOException {
        this(siteName, production, pageProvider, cls, sws, apis, "/tmp/" + siteName + "/", (AbstractFile)new OsFile(new File("/tmp/" + siteName + "/final_out.js")), null, null, null, null, null);
    }

    public TeaVmTemplateWebsite(String siteName, boolean production, PageStorage<? extends StartablePageId> pageProvider, Class<? extends PageStarter> cls, WebSoftwareBundle[] sws, RpcFacility<? extends RpcRequest>[] apis, String tmpDir, AbstractFile builtScript, String baseUrl, GetBy1<String, String> siteScriptUrlProcessor, GetBy1<SiteFacility.SiteObjectSettings, SiteFacility.SiteObjectSettings> configModifier, GetBy1<ServiceProcessHooks, ServiceProcessHooks> hookModifier, GetBy1<IOStreamServer, Object> serverSocketCreator) throws IOException {
        super((Dispatcher)new DefaultDispatchStructure().getChains());
        this.configModifier = configModifier;
        this.serverSocketCreator = serverSocketCreator;
        this.hookModifier = hookModifier;
        this.getDispatcher().getChainByName("modify").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                if (TeaVmTemplateWebsite.this.usePathDispatch) {
                    PreparedURL url = ctx.getRequestUrl();
                    url.setPathPointer(url.getDomainElements());
                }
                return false;
            }
        });
        this.production = production;
        this.pageProvider = pageProvider;
        if (null == baseUrl) {
            baseUrl = "";
        }
        this.baseURL = baseUrl;
        this.siteScriptUrlProcessor = siteScriptUrlProcessor;
        this.registerApis(apis);
        this.teavm = new TeaVmUrlNode(production, tmpDir, builtScript, cls);
        this.getDispatcher().getChainByName("static").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                PreparedURL url = ctx.getRequestUrl();
                if ("sitescript.js".equals(url.getCurrentURLElement())) {
                    url.jumpNextURLElement();
                    TeaVmTemplateWebsite.this.teavm.getScriptNode().dispatch(ctx);
                    return true;
                }
                return false;
            }
        });
        this.lCss = new ArrayList<String>();
        this.lPreJs = new ArrayList<String>();
        this.lPostJs = new ArrayList<String>();
        for (WebSoftwareBundle sw : sws) {
            for (String s : sw.getCss()) {
                this.lCss.add(s);
            }
            for (String s : sw.getPreJs()) {
                this.lPreJs.add(s);
            }
            for (String s : sw.getPostJs()) {
                this.lPostJs.add(s);
            }
        }
        this.lPostJs.add(this.getSitescriptUrl());
    }

    public boolean isUsePathDispatch() {
        return this.usePathDispatch;
    }

    public void setUsePathDispatch(boolean pd) {
        this.usePathDispatch = pd;
    }

    public void useApiRequestMultiplexer() {
        this.registerApis(RpcTools.addMultiplexer((List)this.api.getApis(), e -> new SimpleRpcRequest(RpcSessionTools.ensureGetCurrentRpcSession(), e)).toArray(JavaClassRpcCollector.emptyRpcFacilityArray));
    }

    public void refreshSiteScriptUrl() {
        for (int i = 0; i < this.lPostJs.size(); ++i) {
            if (!this.lPostJs.get(i).startsWith("/sitescript.js/")) continue;
            this.lPostJs.set(i, this.getSitescriptUrl());
            return;
        }
    }

    public void useSitescript() {
        if (!this.production && this.teavm.getScriptNode().checkModificationRefreshIfNeeded()) {
            this.refreshSiteScriptUrl();
        }
    }

    public RpcUrlNode getApiNode() {
        return this.api;
    }

    protected String getSitescriptUrl() {
        return this.teavm.getScriptNode().getSaltedUrl();
    }

    public void registerPage(final String path, final PageId page) {
        this.pageMapping.put(page, path);
        this.getDispatcher().getChainByName("app").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                if (ctx.getRequestUrl().getPath().equals(path)) {
                    TeaVmTemplateWebsite.this.useSitescript();
                    TeaVmTemplateWebsite.this.generateBootPage(ctx, TeaVmTemplateWebsite.this.lCss, TeaVmTemplateWebsite.this.lPreJs, TeaVmTemplateWebsite.this.lPostJs, page);
                    return true;
                }
                return false;
            }
        });
    }

    public void registerDefaultPage(final PageId def) {
        this.pageMapping.put(def, null);
        this.getDispatcher().getChainByName("last").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                TeaVmTemplateWebsite.this.useSitescript();
                TeaVmTemplateWebsite.this.generateBootPage(ctx, TeaVmTemplateWebsite.this.lCss, TeaVmTemplateWebsite.this.lPreJs, TeaVmTemplateWebsite.this.lPostJs, def);
                return true;
            }
        });
    }

    public CorDispatcher<Context> getDispatcher() {
        return (CorDispatcher)super.getDispatcher();
    }

    public TemplateManager createDefaultTemplateManager() {
        return null;
    }

    public abstract void generateBootPage(Context var1, List<String> var2, List<String> var3, List<String> var4, PageId var5);

    public PageStorage<? extends StartablePageId> getPageStorage() {
        return this.pageProvider;
    }

    public HashMap<PageId, String> getPageMapping() {
        return this.pageMapping;
    }

    public void useBuiltinApi() {
        this.getDispatcher().getChainByName("static").addLink((CorChainLink)new CorChainLink<Context>(){

            public boolean dispatch(Context ctx) {
                PreparedURL req = ctx.getRequestUrl();
                if (req.getPath().startsWith("/site_api/")) {
                    req.setPathPointer(req.getDomainElements() + 1);
                    TeaVmTemplateWebsite.this.api.dispatch(ctx);
                }
                return false;
            }
        });
    }

    public static TeaVmTemplateWebsite createSimpleBootPage(int port, String siteName, boolean production, PageStorage<? extends StartablePageId> pageProvider, Class<? extends PageStarter> cls, WebSoftwareBundle[] sws, RpcFacility<? extends RpcRequest>[] apis) throws IOException {
        TeaVmTemplateWebsiteBuilder builder = new TeaVmTemplateWebsiteBuilder(siteName, production, pageProvider, cls, sws, apis);
        builder.port = port;
        return TeaVmTemplateWebsite.createSimpleBootPage(builder);
    }

    public static void renderBootPage(Context ctx, WebsiteResources res, String page) {
        TeaVmTemplateWebsite.renderBootPage(ctx, res.css, res.preJs, res.postJs, page);
    }

    public static void renderBootPage(Context ctx, List<String> css, List<String> preJs, List<String> postJs, String page) {
        StringBuilder sb = new StringBuilder();
        TeaVmTemplateWebsite.renderBootPage(sb, css, preJs, postJs, page);
        SiteFacilityTools.finishWithElementSend((Context)ctx, (String)sb.toString());
    }

    public static void renderBootPage(StringBuilder sb, List<String> css, List<String> preJs, List<String> postJs, String page) {
        sb.append("<html>\n");
        sb.append("\t<head>\n");
        sb.append("\t\t<meta charset=\"utf-8\">\n");
        if (null != css) {
            for (String c : css) {
                sb.append("\t\t<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                sb.append(c);
                sb.append("\" />\n");
            }
        }
        if (null != preJs) {
            for (String c : preJs) {
                sb.append("\t\t<script type=\"text/javascript\" src=\"");
                sb.append(c);
                sb.append("\"></script>\n");
            }
        }
        sb.append("\t</head>\n");
        sb.append("\t<body>\n");
        if (null != page) {
            sb.append("\t\t<div class=\"page_identifier_data\" data-page_id=\"");
            sb.append(page);
            sb.append("\"></div>\n");
        }
        sb.append("");
        if (null != postJs) {
            for (String c : postJs) {
                sb.append("\t\t<script type=\"text/javascript\" src=\"");
                sb.append(c);
                sb.append("\"></script>\n");
            }
        }
        sb.append("\t\t<script type=\"text/javascript\">main();</script>\n");
        sb.append("\t</body>\n");
        sb.append("</html>");
    }

    public static TeaVmTemplateWebsite createSimpleBootPage(final TeaVmTemplateWebsiteBuilder builder) throws IOException {
        return new TeaVmTemplateWebsite(builder){

            protected IOStreamServer getWebServerSocket() throws IOException {
                if (null != this.serverSocketCreator) {
                    return (IOStreamServer)this.serverSocketCreator.getBy((Object)builder.port);
                }
                if (builder.port < 1 || builder.port > 65565) {
                    return IOStreamFactory.NO_OP_SERVER_SOCKET;
                }
                return IOStreamFactory.fromServerSocket((ServerSocket)new ServerSocket(builder.port));
            }

            @Override
            public void generateBootPage(Context ctx, List<String> css, List<String> preJs, List<String> postJs, PageId page) {
                6.renderBootPage(ctx, css, preJs, postJs, null == page ? null : page.getId());
            }
        };
    }

    public static class WebsiteResources {
        public List<String> css;
        public List<String> preJs;
        public List<String> postJs;
    }
}

