/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.teavm.templatesite;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.teavm.TeaVmWebCompiler;
import eu.javaexperience.web.MIME;
import eu.javaexperience.web.dispatch.url.CachedSaltedContentUrlNode;
import eu.javaexperience.web.dispatch.url.spec.compile.CompilerUrlNode;
import eu.javaexperience.web.dispatch.url.spec.compile.WebCompiler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class TeaVmUrlNode {
    protected boolean isProduction;
    protected String tmpDir;
    protected AbstractFile targetFile;
    protected Class<?> masterClass;
    protected CachedSaltedContentUrlNode scripts;

    public TeaVmUrlNode(boolean production, String tmpDir, final AbstractFile targetFile, Class<?> masterClass) {
        this.isProduction = production;
        this.tmpDir = tmpDir;
        this.targetFile = targetFile;
        this.masterClass = masterClass;
        this.scripts = production ? new CachedSaltedContentUrlNode("sitescript.js", MIME.javascript.mime){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public byte[] loadContent() {
                try (InputStream is = targetFile.openRead();){
                    byte[] byArray = IOTools.loadAllFromInputStream((InputStream)is);
                    return byArray;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Mirror.emptyByteArray;
                }
            }

            public long determineLastModified() {
                return targetFile.lastModified();
            }
        } : new CompilerUrlNode("sitescript.js", new File(null == targetFile ? tmpDir + "/final_out.js" : targetFile.getUrl()), (WebCompiler)new TeaVmWebCompiler(masterClass, new File(tmpDir)), production);
        if (!production) {
            this.scripts.setCheckModifiedOnRequest(true);
        }
        this.scripts.setValidForever(true);
        this.scripts.refresh();
    }

    public CachedSaltedContentUrlNode getScriptNode() {
        return this.scripts;
    }
}

