/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.activity;

import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.teasite.frontend.tools.TeasiteFrontendTools;
import eu.javaexperience.teavm.templatesite.common.PageStorage;
import eu.javaexperience.teavm.templatesite.frontend.PageStarter;
import eu.jvx.js.lib.HtmlActivity;
import eu.jvx.js.lib.HtmlTools;
import eu.jvx.js.lib.WrapperHtml;
import eu.jvx.js.lib.activity.StartablePageId;
import eu.jvx.js.lib.teavm.NativeJsSupportTeaVM;
import org.teavm.jso.dom.html.HTMLElement;

public abstract class AbstractPageStarter<P extends StartablePageId>
implements PageStarter<P> {
    public static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("AbstractPageStarter"));
    protected final PageStorage<? extends P> pageStorage;
    protected P currentPage;
    protected HtmlActivity currentActivity;
    protected WrapperHtml root;

    public AbstractPageStarter(PageStorage<? extends P> storage) {
        this.pageStorage = storage;
        TeasiteFrontendTools.registerInfrastructurePageStater(this);
    }

    public void startActivity(HtmlActivity act, P id) {
        this.currentActivity = act;
        this.currentPage = id;
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"startActivity(activity: %s, id: %s) | before invoking activity.start()", (Object)act, id);
        this.currentActivity.start();
    }

    @Override
    public void startPage(P id) {
        try {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"startPage(%s)", id);
            HtmlActivity newAct = id.getActivityClass().newInstance();
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"startPage - instance: %s", (Object)newAct);
            this.startActivity(newAct, id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HTMLElement getContentContainer() {
        if (null == this.root) {
            this.root = this.initPage();
            this.addOnPageLinkHandler();
        }
        return (HTMLElement)this.root.getContent();
    }

    public HTMLElement getResettedContainer() {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"getResettedContainer()", (Object[])new Object[0]);
        HTMLElement ret = this.getContentContainer();
        HtmlTools.removeChilds(ret);
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"getResettedContainer() - after removeChilds()", (Object[])new Object[0]);
        return ret;
    }

    protected abstract WrapperHtml initPage();

    protected void addOnPageLinkHandler() {
        TeasiteFrontendTools.addActivityStarterListener((HTMLElement)this.root.getRoot(), this.pageStorage, this);
        TeasiteFrontendTools.addActivityHistoryBackListener(this.pageStorage, this);
    }

    @Override
    public P getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public HtmlActivity getCurrentActivity() {
        return this.currentActivity;
    }

    static {
        NativeJsSupportTeaVM.init();
        new String[0].getClass().toString();
    }
}

