/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.generic;

import eu.jvx.js.generic.Language;
import eu.jvx.js.generic.Translation;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.bindings.VanillaTools;
import java.util.LinkedList;
import java.util.List;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;

public class LiveTranslation
implements ImpersonalisedHtml {
    protected static List<LiveTranslation> liveTranslations = new LinkedList<LiveTranslation>();
    protected Translation trans;
    protected HTMLElement container;

    private LiveTranslation() {
    }

    public static LiveTranslation register(Translation t, String tag, String ... attrs) {
        LiveTranslation lt = new LiveTranslation();
        lt.trans = t;
        lt.container = VanillaTools.inlineCreateElement(tag, attrs);
        liveTranslations.add(lt);
        return lt;
    }

    public static LiveTranslation register(final String id, String tag, String ... attrs) {
        LiveTranslation lt = new LiveTranslation();
        lt.trans = new Translation(){

            @Override
            public String getLabel() {
                return id;
            }

            @Override
            public String getContent(Language lang) {
                return null;
            }
        };
        lt.container = VanillaTools.inlineCreateElement(tag, attrs);
        liveTranslations.add(lt);
        return lt;
    }

    protected void updateLanguage(Language lang) {
        if (VanillaTools.isDetached(this.container)) {
            liveTranslations.remove(this);
            return;
        }
        if (null == lang) {
            this.container.setInnerHTML(this.trans.getLabel());
        } else {
            this.container.setInnerHTML(this.trans.getContent(lang));
        }
    }

    public static void updateAllTranslationLanguage(Language lang) {
        for (LiveTranslation lt : liveTranslations) {
            lt.updateLanguage(lang);
        }
    }

    @Override
    public Object getImpersonator() {
        return this;
    }

    @Override
    public Element getHtml() {
        return this.container;
    }
}

