/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.component.tabbed;

import eu.jvx.js.lib.ImpTools;
import eu.jvx.js.lib.ImpersonalisedHtml;
import eu.jvx.js.lib.ui.component.tabbed.TabEntry;
import eu.jvx.js.lib.ui.component.tabbed.TabStructureManager;
import java.util.ArrayList;
import java.util.List;
import org.teavm.jso.dom.html.HTMLElement;

public class TabbedPane
implements ImpersonalisedHtml {
    protected TabStructureManager tm;
    protected HTMLElement root;
    protected List<TabEntry> tabs;

    public TabbedPane(TabStructureManager builder) {
        this.tm = builder;
        this.root = ImpTools.appendImp(this.tm.createTabbedPaneSkel(), this);
        this.tabs = new ArrayList<TabEntry>();
    }

    public void initialize() {
        this.tm.initialize(this.root);
    }

    public TabEntry createNewTab() {
        TabEntry ent = this.tm.addTabToPoz(this.root, this.tabs.size());
        ent.setOwner(this);
        this.tabs.add(ent);
        return ent;
    }

    public List<TabEntry> getTabs() {
        return this.tabs;
    }

    @Override
    public Object getImpersonator() {
        return this;
    }

    public HTMLElement getHtml() {
        return this.root;
    }

    public void resetSelected() {
        if (0 != this.tabs.size()) {
            this.tm.setTabIndexActive(this.root, 0);
        }
    }

    public int getTabIndex(TabEntry tabEntry) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (tabEntry != this.tabs.get(i)) continue;
            return i;
        }
        return -1;
    }
}

