/*
 * Decompiled with CFR 0.152.
 */
package eu.jvx.js.lib.ui.component.tabbed.tbs;

import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.text.StringTools;
import eu.jvx.js.lib.SimpleWrapperHtml;
import eu.jvx.js.lib.bindings.VanillaTools;
import eu.jvx.js.lib.ui.component.tabbed.TabEntry;
import eu.jvx.js.lib.ui.component.tabbed.TabStructureManager;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.NodeList;

public class BootstrapTabStructureManager
implements TabStructureManager {
    public static final BootstrapTabStructureManager DEFAULT_INSTANCE = new BootstrapTabStructureManager();
    protected static final String[] CLASS_ACTIVE = new String[]{"active", "in"};
    protected static final String[] CLASS_HIDDEN = new String[]{"hidden"};

    @Override
    public HTMLElement createTabbedPaneSkel() {
        return VanillaTools.appendChilds(VanillaTools.inlineCreateElement("div", new String[0]), VanillaTools.inlineCreateElement("ul", "class", "tabed-panel-nav-selector nav nav-tabs"), VanillaTools.inlineCreateElement("div", "class", "tabed-panel-container-selector tab-content"));
    }

    @Override
    public TabEntry addTabToPoz(HTMLElement structureRoot, int absolutePosition) {
        HTMLElement nav = structureRoot.querySelector(".tabed-panel-nav-selector");
        HTMLElement container = structureRoot.querySelector(".tabed-panel-container-selector");
        String id = "tab_" + StringTools.randomString((int)50);
        HTMLElement rn = VanillaTools.inlineCreateElement("li", new String[0]);
        HTMLElement ra = VanillaTools.inlineCreateElement("a", "data-toggle", "tab", "href", "#" + id);
        rn.appendChild((Node)ra);
        SimpleWrapperHtml nnav = new SimpleWrapperHtml((Element)rn, (Element)ra);
        HTMLElement c = VanillaTools.inlineCreateElement("div", "id", id, "class", "tab-pane fade");
        SimpleWrapperHtml ncont = new SimpleWrapperHtml((Element)c, (Element)c);
        TabEntry ent = new TabEntry(nnav, ncont);
        if (VanillaTools.getChildren(container).getLength() == 0) {
            nav.appendChild((Node)rn);
            container.appendChild((Node)c);
        } else {
            nav.insertBefore((Node)rn, (Node)VanillaTools.getChildren(nav).get(absolutePosition));
            container.insertBefore((Node)c, (Node)VanillaTools.getChildren(container).get(absolutePosition));
        }
        if (null == structureRoot.querySelector(".nav-tabs li.active")) {
            VanillaTools.getClassList(rn).add("active");
        }
        return ent;
    }

    protected static void switchClassFrom(HTMLElement root, String select, String[] cls, @MayNull String[] to) {
        NodeList lst = root.querySelectorAll(select);
        for (int i = 0; i < lst.getLength(); ++i) {
            VanillaTools.ClassList cl = VanillaTools.getClassList((HTMLElement)lst.get(i));
            for (String s : cls) {
                cl.remove(s);
            }
            if (null == to) continue;
            for (String s : to) {
                cl.add(s);
            }
        }
    }

    protected static void switchToActive(HTMLElement elem) {
        VanillaTools.ClassList cl = VanillaTools.getClassList(elem);
        for (String s : CLASS_HIDDEN) {
            cl.remove(s);
        }
        for (String s : CLASS_ACTIVE) {
            cl.add(s);
        }
    }

    @Override
    public void setTabIndexActive(HTMLElement structureRoot, int absolutePosition) {
        BootstrapTabStructureManager.switchClassFrom(structureRoot, ".nav-tabs li.active", CLASS_ACTIVE, null);
        BootstrapTabStructureManager.switchToActive((HTMLElement)VanillaTools.getChildren(structureRoot.querySelector(".tabed-panel-nav-selector")).get(absolutePosition));
        BootstrapTabStructureManager.switchClassFrom(structureRoot, ".tab-pane", CLASS_ACTIVE, CLASS_HIDDEN);
        BootstrapTabStructureManager.switchToActive((HTMLElement)VanillaTools.getChildren(structureRoot.querySelector(".tabed-panel-container-selector")).get(absolutePosition));
    }

    @Override
    public boolean isTabIndexActive(HTMLElement html, int tabIndex) {
        return VanillaTools.getClassList((HTMLElement)VanillaTools.getChildren(html.querySelector(".tabed-panel-nav-selector")).get(tabIndex)).contains("active");
    }

    @Override
    public void initialize(HTMLElement root) {
    }

    @Override
    public void destroy(HTMLElement root) {
    }
}

